/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.handler;

import com.github.eterdelta.crittersandcompanions.entity.DumboOctopusEntity;
import com.github.eterdelta.crittersandcompanions.entity.KoiFishEntity;
import com.github.eterdelta.crittersandcompanions.extension.IBubbleState;
import com.github.eterdelta.crittersandcompanions.extension.IGrapplingState;
import com.github.eterdelta.crittersandcompanions.extension.ISilkLeashState;
import com.github.eterdelta.crittersandcompanions.item.SilkLeashItem;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundBubbleStatePacket;
import com.github.eterdelta.crittersandcompanions.network.ClientboundGrapplingStatePacket;
import com.github.eterdelta.crittersandcompanions.network.ClientboundSilkLeashStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class PlayerHandler {
    public static class_1268 getOppositeHand(class_1268 hand) {
        return hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
    }

    @Nullable
    public static class_1269 onPlayerEntityInteract(class_1297 target, class_1838 context) {
        boolean isClient = target.method_37908().method_8608();
        class_1657 class_16572 = context.method_8036();
        if (!(class_16572 instanceof ISilkLeashState)) {
            return null;
        }
        ISilkLeashState playerLeashState = (ISilkLeashState)class_16572;
        if (!(target instanceof class_1309)) {
            return null;
        }
        class_1309 entity = (class_1309)target;
        class_1799 handStack = context.method_8041();
        class_1799 otherHandStack = context.method_8036().method_5998(PlayerHandler.getOppositeHand(context.method_20287()));
        Set<class_1309> playerLeashingEntities = playerLeashState.getLeashingEntities();
        if (otherHandStack.method_31574((class_1792)CACItems.SILK_LEAD.get())) {
            return null;
        }
        if ((playerLeashingEntities.isEmpty() || playerLeashingEntities.contains(entity)) && !handStack.method_31574((class_1792)CACItems.SILK_LEAD.get()) && !handStack.method_31574(class_1802.field_8719) && context.method_20287() == class_1268.field_5808) {
            int unleashedStates = 0;
            unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates(entity, null) - 1);
            if ((unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates(null, entity) - 1)) > 0) {
                class_1542 leadEntity = new class_1542(context.method_8045(), entity.method_23317(), entity.method_23318(), entity.method_23321(), new class_1799((class_1935)CACItems.SILK_LEAD.get(), unleashedStates));
                context.method_8045().method_8649((class_1297)leadEntity);
                playerLeashState.sendLeashState();
                if (entity instanceof ISilkLeashState) {
                    ISilkLeashState entityLeashState = (ISilkLeashState)entity;
                    entityLeashState.sendLeashState();
                }
                return class_1269.method_29236((boolean)isClient);
            }
        } else {
            class_1309 uniqueLeash = (class_1309)Iterables.getFirst(playerLeashingEntities, null);
            if (uniqueLeash != null && SilkLeashItem.updateLeashStates(uniqueLeash, entity) != 0) {
                SilkLeashItem.updateLeashStates((class_1309)context.method_8036(), null);
                return class_1269.method_29236((boolean)isClient);
            }
        }
        return null;
    }

    public static void onPlayerTick(class_1657 player) {
        if (player.method_37908().method_8608()) {
            return;
        }
        List nearKoiFishes = player.method_37908().method_8390(KoiFishEntity.class, player.method_5829().method_1014(10.0), class_1301.field_6154);
        if (nearKoiFishes.size() >= 3) {
            player.method_6092(new class_1293(class_1294.field_5926, 210, 0, false, false));
        }
    }

    public static void onPlayerStartTracking(class_1297 target, class_1297 from) {
        if (target instanceof class_1309) {
            class_1309 trackedEntity = (class_1309)target;
            if (from instanceof class_3222) {
                class_3222 player = (class_3222)from;
                if (target instanceof ISilkLeashState) {
                    ISilkLeashState trackedState = (ISilkLeashState)target;
                    CACPacketHandler.SILK_LEASH_STATE.sendToPlayer(player, new ClientboundSilkLeashStatePacket(new ClientboundSilkLeashStatePacket.LeashData(trackedEntity.method_5628(), (IntList)new IntArrayList(trackedState.getLeashingEntities().stream().mapToInt(class_1297::method_5628).toArray()), (IntList)new IntArrayList(trackedState.getLeashedByEntities().stream().mapToInt(class_1297::method_5628).toArray()))));
                }
            }
        }
        if (target instanceof class_1657) {
            class_1657 trackedPlayer = (class_1657)target;
            if (from instanceof class_3222) {
                class_3222 fromPlayer = (class_3222)from;
                IBubbleState bubbleState = (IBubbleState)trackedPlayer;
                IGrapplingState grappleState = (IGrapplingState)trackedPlayer;
                CACPacketHandler.BUBBLE_STATE.sendToPlayer(fromPlayer, new ClientboundBubbleStatePacket(bubbleState.isBubbleActive(), trackedPlayer.method_5628()));
                CACPacketHandler.GRAPPLING_STATE.sendToPlayer(fromPlayer, new ClientboundGrapplingStatePacket(grappleState.getHook() != null ? Optional.of(grappleState.getHook().method_5628()) : Optional.empty(), trackedPlayer.method_5628()));
            }
        }
    }

    public static void onPlayerStopTracking(class_1297 target, class_1297 by) {
        DumboOctopusEntity dumboOctopus;
        if (target instanceof DumboOctopusEntity && (dumboOctopus = (DumboOctopusEntity)target).getBubbledPlayer() == by) {
            dumboOctopus.sendBubble((class_3222)by, false);
        }
    }
}

