/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.config;

import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;

public class CACCommonConfig {
    public final ForgeConfigSpec.DoubleValue necklaceGuardianDebuff;
    public final ForgeConfigSpec.DoubleValue necklaceDrownedDebuff;
    public final ForgeConfigSpec.DoubleValue necklaceSwimSpeed;
    public final ForgeConfigSpec.DoubleValue grapplingHookSpeed;
    public final ForgeConfigSpec.DoubleValue grapplingHookMaxSpeed;
    public final ForgeConfigSpec.DoubleValue grapplingHookMaxDistance;

    public double necklaceRangeDebuff(EntityType<?> type, int level) {
        if (type == EntityType.f_20455_ && level > 1) {
            return (Double)this.necklaceGuardianDebuff.get() * (double)level;
        }
        if (type == EntityType.f_20562_) {
            return (Double)this.necklaceDrownedDebuff.get() * (double)level;
        }
        return 0.0;
    }

    public CACCommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("necklace");
        this.necklaceSwimSpeed = builder.defineInRange("swim_sped", (double)0.2f, 0.0, 1.0);
        this.necklaceDrownedDebuff = builder.defineInRange("drowned_range_debuff", (double)0.1f, 0.0, 1.0);
        this.necklaceGuardianDebuff = builder.defineInRange("guardian_range_debuff", (double)0.1f, 0.0, 1.0);
        builder.pop();
        builder.push("grappling_hook");
        this.grapplingHookSpeed = builder.defineInRange("launch_speed", 1.0, 0.0, 10.0);
        this.grapplingHookMaxSpeed = builder.defineInRange("max_speed", 4.0, 1.0, 1000.0);
        this.grapplingHookMaxDistance = builder.defineInRange("max_distance", 32.0, 4.0, 128.0);
        builder.pop();
    }
}

