/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.entity.brain.SprintingFollowParentGoal;
import com.github.eterdelta.crittersandcompanions.entity.brain.TameableFollowParentGoal;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FerretEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(FerretEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DIGGING = SynchedEntityData.m_135353_(FerretEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(FerretEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(FerretEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final TagKey<Item> FOODS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)CrittersAndCompanions.createId("ferret_food"));
    private static final ResourceLocation DIGGABLES = CrittersAndCompanions.createId("gameplay/digging");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected BlockState stateToDig;
    protected int digCooldown;

    public FerretEntity(EntityType<? extends FerretEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FerretMoveControl();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(DIGGING, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new DigGoal());
        this.f_21345_.m_25352_(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new SleepGoal(200));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.6, 1.4, livingEntity -> livingEntity.m_7306_((Entity)this.m_21188_()) && !livingEntity.m_7306_((Entity)this.m_269323_())));
        this.f_21345_.m_25352_(6, (Goal)new BreedGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(7, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(8, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(FOODS_TAG), false));
        this.f_21345_.m_25352_(7, (Goal)new SprintingFollowParentGoal(this, 1.4, 10.0f, 5.0f, 2.0f));
        this.f_21345_.m_25352_(10, (Goal)new TameableFollowParentGoal(this, 1.0));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(13, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, false, false, entity -> entity instanceof Chicken || entity instanceof Rabbit));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sleeping", this.m_5803_());
        compound.m_128405_("Variant", this.getVariant());
        if (this.getCollarColor() != null) {
            compound.m_128405_("CollarColor", this.getCollarColor().m_41060_());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleeping(compound.m_128471_("Sleeping"));
        this.setVariant(compound.m_128451_("Variant"));
        if (compound.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)compound.m_128451_("CollarColor")));
        }
    }

    public int m_213860_() {
        return this.f_19796_.m_216339_(2, 5);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.digCooldown > 0) {
            --this.digCooldown;
        }
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageableMob) {
        FerretEntity baby = (FerretEntity)((EntityType)CACEntities.FERRET.get()).m_20615_((Level)level);
        if (baby == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (ageableMob instanceof FerretEntity) {
            DyeColor color;
            FerretEntity ferretEntity = (FerretEntity)ageableMob;
            if (this.f_19796_.m_188499_()) {
                baby.setVariant(this.getVariant());
            } else {
                baby.setVariant(ferretEntity.getVariant());
            }
            DyeColor dyeColor = color = this.f_19796_.m_188499_() ? this.getCollarColor() : ferretEntity.getCollarColor();
            if (color != null) {
                baby.setCollarColor(color);
            }
            if (uuid != null) {
                baby.m_21816_(uuid);
                baby.m_7105_(true);
            }
        }
        return baby;
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            this.m_5496_((SoundEvent)CACSounds.BITE_ATTACK.get(), this.m_6121_(), this.m_6100_());
            return true;
        }
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        if (this.m_5803_()) {
            return InteractionResult.PASS;
        }
        ItemStack handStack = player.m_21120_(interactionHand);
        if (!this.m_21824_() && handStack.m_150930_(Items.f_42697_)) {
            if (!player.m_150110_().f_35937_) {
                handStack.m_41774_(1);
            }
            if (!this.m_9236_().m_5776_()) {
                if (this.f_19796_.m_188503_(10) == 0 && Services.EVENTS.canTame((Animal)this, player)) {
                    this.m_21828_(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            InteractionResult digResult = this.startDigging(player, handStack);
            if (digResult != InteractionResult.PASS) {
                return digResult;
            }
            Item item = handStack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                if (this.getCollarColor() != dyeItem.m_41089_()) {
                    this.setCollarColor(dyeItem.m_41089_());
                    if (!player.m_150110_().f_35937_) {
                        handStack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            if (this.m_6898_(handStack)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_146852_(GameEvent.f_157806_, (Entity)this);
                    this.m_5634_(handStack.m_41720_().m_41473_().m_38744_());
                    if (!player.m_150110_().f_35937_) {
                        handStack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
            } else {
                this.m_21839_(!this.m_21827_());
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        }
        return super.m_6071_(player, interactionHand);
    }

    private InteractionResult startDigging(Player player, ItemStack handStack) {
        if (handStack.m_150930_(Items.f_42581_) && !this.m_6162_() && !this.m_21825_()) {
            if (this.digCooldown <= 0) {
                this.stateToDig = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
                if (this.stateToDig.m_204336_(BlockTags.f_144274_) || this.stateToDig.m_204336_(BlockTags.f_13029_) || this.stateToDig.m_60713_(Blocks.f_49994_)) {
                    this.setDigging(true);
                    this.digCooldown = 6000;
                    if (!player.m_150110_().f_35937_) {
                        handStack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
                this.stateToDig = null;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public boolean m_5957_() {
        return !this.isDigging() && super.m_5957_();
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(FOODS_TAG);
    }

    protected SoundEvent m_7515_() {
        return this.m_5803_() ? null : (SoundEvent)CACSounds.FERRET_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)CACSounds.FERRET_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CACSounds.FERRET_DEATH.get();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag p_146750_) {
        spawnGroupData = super.m_6518_(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, p_146750_);
        if (mobSpawnType.equals((Object)MobSpawnType.SPAWNER) && this.f_19796_.m_188501_() <= 0.2f) {
            for (int i = 0; i < this.f_19796_.m_216339_(1, 4); ++i) {
                FerretEntity baby = (FerretEntity)((EntityType)CACEntities.FERRET.get()).m_20615_(this.m_9236_());
                baby.setVariant(this.f_19796_.m_216339_(0, 2));
                baby.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                baby.m_6863_(true);
                levelAccessor.m_7967_((Entity)baby);
            }
        }
        this.setVariant(this.f_19796_.m_216339_(0, 2));
        return spawnGroupData;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.isDigging()) {
            event.getController().setAnimation(RawAnimation.begin().then("dig", Animation.LoopType.PLAY_ONCE));
        } else if (this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sit"));
        } else if (this.m_5803_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sleep"));
        } else if (this.m_20069_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("swim"));
        } else if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("run"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(DIGGING);
    }

    public void setDigging(boolean digging) {
        this.f_19804_.m_135381_(DIGGING, (Object)digging);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)Mth.m_14045_((int)variant, (int)0, (int)1));
    }

    @Nullable
    public DyeColor getCollarColor() {
        if (!this.m_21824_()) {
            return null;
        }
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    private void setCollarColor(DyeColor color) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)color.m_41060_());
    }

    class FerretMoveControl
    extends MoveControl {
        public FerretMoveControl() {
            super((Mob)FerretEntity.this);
        }

        public void m_8126_() {
            if (!FerretEntity.this.m_5803_()) {
                super.m_8126_();
            }
        }
    }

    public class DigGoal
    extends Goal {
        protected int digTime;

        public DigGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            return FerretEntity.this.isDigging();
        }

        public void m_8056_() {
            this.digTime = 35;
        }

        public void m_8037_() {
            if (this.digTime > 0) {
                --this.digTime;
                if (this.digTime % 5 == 0 && this.digTime >= 10) {
                    FerretEntity.this.m_9236_().m_6269_(null, (Entity)FerretEntity.this, SoundEvents.f_11995_, SoundSource.BLOCKS, 0.2f, 1.2f);
                    for (int i = 0; i < 4; ++i) {
                        double d0 = FerretEntity.this.f_19796_.m_188583_() * 0.01;
                        double d1 = FerretEntity.this.f_19796_.m_188583_() * 0.01;
                        double d2 = FerretEntity.this.f_19796_.m_188583_() * 0.01;
                        ((ServerLevel)FerretEntity.this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, FerretEntity.this.stateToDig), FerretEntity.this.m_20185_(), FerretEntity.this.m_20186_(), FerretEntity.this.m_20189_(), 2, d0, d1, d2, 0.1);
                    }
                }
                if (this.digTime == 10) {
                    LootTable digTable = FerretEntity.this.m_9236_().m_7654_().m_278653_().m_278676_(DIGGABLES);
                    ObjectArrayList dugItems = digTable.m_287195_(new LootParams.Builder((ServerLevel)FerretEntity.this.m_9236_()).m_287235_(LootContextParamSets.f_81410_));
                    if (!dugItems.isEmpty()) {
                        FerretEntity.this.m_9236_().m_6269_(null, (Entity)FerretEntity.this, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.1f, 1.2f);
                    }
                    for (ItemStack stack : dugItems) {
                        ItemEntity itemEntity = new ItemEntity(FerretEntity.this.m_9236_(), FerretEntity.this.m_20185_(), FerretEntity.this.m_20186_(), FerretEntity.this.m_20189_(), stack);
                        FerretEntity.this.m_9236_().m_7967_((Entity)itemEntity);
                    }
                    ExperienceOrb xp = new ExperienceOrb(FerretEntity.this.m_9236_(), FerretEntity.this.m_20185_(), FerretEntity.this.m_20186_(), FerretEntity.this.m_20189_(), FerretEntity.this.f_19796_.m_216339_(1, 6));
                    FerretEntity.this.m_9236_().m_7967_((Entity)xp);
                }
            } else {
                this.m_8041_();
            }
        }

        public void m_8041_() {
            FerretEntity.this.setDigging(false);
            FerretEntity.this.stateToDig = null;
            this.digTime = 0;
        }
    }

    public class SleepGoal
    extends Goal {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = FerretEntity.this.f_19796_.m_188503_(SleepGoal.m_186073_((int)countdownTime));
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (FerretEntity.this.f_20900_ == 0.0f && FerretEntity.this.f_20901_ == 0.0f && FerretEntity.this.f_20902_ == 0.0f) {
                return this.canSleep() || FerretEntity.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return FerretEntity.this.m_9236_().m_46462_();
        }

        public void m_8041_() {
            FerretEntity.this.setSleeping(false);
            this.countdown = FerretEntity.this.f_19796_.m_188503_(this.countdownTime);
        }

        public void m_8056_() {
            FerretEntity.this.m_21837_(false);
            FerretEntity.this.m_6862_(false);
            FerretEntity.this.setSleeping(true);
            FerretEntity.this.m_21573_().m_26573_();
            FerretEntity.this.m_21566_().m_6849_(FerretEntity.this.m_20185_(), FerretEntity.this.m_20186_(), FerretEntity.this.m_20189_(), 0.0);
        }
    }
}

