/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.item.DragonflyArmorItem;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DragonflyEntity
extends TamableAnimal
implements GeoEntity {
    private static final TagKey<Item> FOODS_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)CrittersAndCompanions.createId("dragonfly_food"));
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public DragonflyEntity(EntityType<? extends DragonflyEntity> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new DragonflyMoveControl(this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FLYING_SPEED, 0.25);
    }

    public static boolean checkDragonflySpawnRules(EntityType<DragonflyEntity> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource random) {
        int seaLevel = levelAccessor.getSeaLevel();
        return blockPos.getY() > seaLevel - 10 && blockPos.getY() <= seaLevel + 16 && levelAccessor.getBlockState(blockPos).isAir() && levelAccessor.getRawBrightness(blockPos, 0) > 8;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 6.0f, 2.0f));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(FOODS_TAG), false));
        this.goalSelector.addGoal(4, (Goal)new RandomFlyGoal());
        this.targetSelector.addGoal(0, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
    }

    public int getBaseExperienceReward() {
        return this.random.nextInt(2, 5);
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
    }

    public float getWalkTargetValue(BlockPos blockPos) {
        return !this.isTame() && this.level().getBiome(blockPos).is(Biomes.RIVER) ? 10.0f : 5.0f;
    }

    public boolean canBeLeashed() {
        return false;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.isOrderedToSit()) {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.16, 0.0));
        }
    }

    public void travel(Vec3 speed) {
        if (this.isEffectiveAi()) {
            this.moveRelative(this.getSpeed(), speed);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8));
        }
        this.calculateEntityAnimation(false);
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level);
        flyingPathNavigation.setCanFloat(true);
        return flyingPathNavigation;
    }

    public boolean causeFallDamage(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void checkFallDamage(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack handStack = player.getItemInHand(hand);
        if (this.isTame()) {
            if (handStack.is(FOODS_TAG) && this.getHealth() < this.getMaxHealth()) {
                this.gameEvent((Holder)GameEvent.EAT, (Entity)this);
                this.heal(2.0f);
                if (!player.getAbilities().instabuild) {
                    handStack.shrink(1);
                }
            } else if (this.isOwnedBy((LivingEntity)player)) {
                if (!this.level().isClientSide()) {
                    if (handStack.getItem() instanceof DragonflyArmorItem && this.getArmor().isEmpty()) {
                        this.setArmor(handStack.copy());
                        handStack.shrink(1);
                        if (!player.getAbilities().instabuild) {
                            handStack.shrink(1);
                        }
                        this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), 0.4f, 1.5f);
                    } else if (player.isCrouching() && !this.getArmor().isEmpty()) {
                        this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getArmor().copy()));
                        this.setArmor(ItemStack.EMPTY);
                        this.playSound(SoundEvents.ITEM_PICKUP, 0.2f, 1.0f);
                    } else {
                        this.setOrderedToSit(!this.isOrderedToSit());
                    }
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
        } else if (handStack.is(FOODS_TAG)) {
            if (!player.getAbilities().instabuild) {
                handStack.shrink(1);
            }
            if (!this.level().isClientSide()) {
                if (this.random.nextInt(10) == 0 && Services.EVENTS.canTame((Animal)this, player)) {
                    this.tame(player);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    public void setTame(boolean tame, boolean sideEffects) {
        super.setTame(tame, sideEffects);
        ResourceLocation tameModifier = CrittersAndCompanions.createId("tamed_health_boost");
        if (tame && sideEffects) {
            this.getAttribute(Attributes.MAX_HEALTH).addOrReplacePermanentModifier(new AttributeModifier(tameModifier, 4.0, AttributeModifier.Operation.ADD_VALUE));
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).removeModifier(tameModifier);
        }
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public boolean canBreed() {
        return false;
    }

    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.isInSittingPose()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dragonfly_sit"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dragonfly_fly"));
        }
        return PlayState.CONTINUE;
    }

    public ItemStack getArmor() {
        return this.getBodyArmorItem();
    }

    public void setArmor(ItemStack armorItem) {
        this.setBodyArmorItem(armorItem);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static class DragonflyMoveControl
    extends FlyingMoveControl {
        public DragonflyMoveControl(DragonflyEntity dragonfly) {
            super((Mob)dragonfly, 360, true);
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                this.operation = MoveControl.Operation.WAIT;
                this.mob.setNoGravity(true);
                double deltaX = this.wantedX - this.mob.getX();
                double deltaY = this.wantedY - this.mob.getY();
                double deltaZ = this.wantedZ - this.mob.getZ();
                double distanceSqrt = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
                if (distanceSqrt < 0.1) {
                    this.mob.setYya(this.mob.getRandom().nextFloat() - 0.5f);
                    this.mob.setZza(0.0f);
                    return;
                }
                float f = (float)(Mth.atan2((double)deltaZ, (double)deltaX) * 57.2957763671875) - 90.0f;
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f, 360.0f));
                float speed = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.FLYING_SPEED));
                this.mob.setSpeed(speed);
                double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                if (Math.abs(deltaY) > (double)1.0E-5f || Math.abs(horizontalDistance) > (double)1.0E-5f) {
                    float f2 = (float)(-(Mth.atan2((double)deltaY, (double)horizontalDistance) * 57.2957763671875));
                    this.mob.setXRot(this.rotlerp(this.mob.getXRot(), f2, 20.0f));
                    this.mob.setYya(deltaY > 0.0 ? speed : -speed);
                }
            } else {
                this.mob.setYya(this.mob.getRandom().nextFloat() - 0.5f);
                this.mob.setZza(0.0f);
            }
        }
    }

    public class RandomFlyGoal
    extends Goal {
        private static final int horizontalRange = 14;
        private static final int verticalRange = 4;

        public RandomFlyGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return !DragonflyEntity.this.isOrderedToSit() && DragonflyEntity.this.navigation.isDone() && DragonflyEntity.this.random.nextInt(10) == 0;
        }

        public void start() {
            Vec3 view = DragonflyEntity.this.getViewVector(0.0f);
            Vec3 randomPos = HoverRandomPos.getPos((PathfinderMob)DragonflyEntity.this, (int)14, (int)4, (double)view.x, (double)view.z, (float)2.0f, (int)3, (int)1);
            if (randomPos == null) {
                int y = DragonflyEntity.this.isInWater() ? 2 : -2;
                randomPos = AirAndWaterRandomPos.getPos((PathfinderMob)DragonflyEntity.this, (int)14, (int)4, (int)y, (double)view.x, (double)view.y, (double)2.0);
            }
            if (randomPos != null) {
                DragonflyEntity.this.navigation.moveTo(DragonflyEntity.this.navigation.createPath(BlockPos.containing((Position)randomPos), 1), 1.0);
            }
        }
    }
}

