/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.handler;

import com.github.eterdelta.crittersandcompanions.entity.DumboOctopusEntity;
import com.github.eterdelta.crittersandcompanions.entity.KoiFishEntity;
import com.github.eterdelta.crittersandcompanions.extension.IBubbleState;
import com.github.eterdelta.crittersandcompanions.extension.IGrapplingState;
import com.github.eterdelta.crittersandcompanions.extension.ISilkLeashState;
import com.github.eterdelta.crittersandcompanions.item.SilkLeashItem;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundBubbleStatePacket;
import com.github.eterdelta.crittersandcompanions.network.ClientboundGrapplingStatePacket;
import com.github.eterdelta.crittersandcompanions.network.ClientboundSilkLeashStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class PlayerHandler {
    public static InteractionHand getOppositeHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    @Nullable
    public static InteractionResult onPlayerEntityInteract(Entity target, UseOnContext context) {
        boolean isClient = target.level().isClientSide();
        Player player = context.getPlayer();
        if (!(player instanceof ISilkLeashState)) {
            return null;
        }
        ISilkLeashState playerLeashState = (ISilkLeashState)player;
        if (!(target instanceof LivingEntity)) {
            return null;
        }
        LivingEntity entity = (LivingEntity)target;
        ItemStack handStack = context.getItemInHand();
        ItemStack otherHandStack = context.getPlayer().getItemInHand(PlayerHandler.getOppositeHand(context.getHand()));
        Set<LivingEntity> playerLeashingEntities = playerLeashState.getLeashingEntities();
        if (otherHandStack.is((Item)CACItems.SILK_LEAD.get())) {
            return null;
        }
        if ((playerLeashingEntities.isEmpty() || playerLeashingEntities.contains(entity)) && !handStack.is((Item)CACItems.SILK_LEAD.get()) && !handStack.is(Items.LEAD) && context.getHand() == InteractionHand.MAIN_HAND) {
            int unleashedStates = 0;
            unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates(entity, null) - 1);
            if ((unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates(null, entity) - 1)) > 0) {
                ItemEntity leadEntity = new ItemEntity(context.getLevel(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)CACItems.SILK_LEAD.get(), unleashedStates));
                context.getLevel().addFreshEntity((Entity)leadEntity);
                playerLeashState.sendLeashState();
                if (entity instanceof ISilkLeashState) {
                    ISilkLeashState entityLeashState = (ISilkLeashState)entity;
                    entityLeashState.sendLeashState();
                }
                return InteractionResult.sidedSuccess((boolean)isClient);
            }
        } else {
            LivingEntity uniqueLeash = (LivingEntity)Iterables.getFirst(playerLeashingEntities, null);
            if (uniqueLeash != null && SilkLeashItem.updateLeashStates(uniqueLeash, entity) != 0) {
                SilkLeashItem.updateLeashStates((LivingEntity)context.getPlayer(), null);
                return InteractionResult.sidedSuccess((boolean)isClient);
            }
        }
        return null;
    }

    public static void onPlayerTick(Player player) {
        if (player.level().isClientSide()) {
            return;
        }
        List nearKoiFishes = player.level().getEntitiesOfClass(KoiFishEntity.class, player.getBoundingBox().inflate(10.0), EntitySelector.ENTITY_STILL_ALIVE);
        if (nearKoiFishes.size() >= 3) {
            player.addEffect(new MobEffectInstance(MobEffects.LUCK, 210, 0, false, false));
        }
    }

    public static void onPlayerStartTracking(Entity target, Entity from) {
        if (target instanceof LivingEntity) {
            LivingEntity trackedEntity = (LivingEntity)target;
            if (from instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)from;
                if (target instanceof ISilkLeashState) {
                    ISilkLeashState trackedState = (ISilkLeashState)target;
                    if (trackedState.getLeashedByEntities().isEmpty() && trackedState.getLeashingEntities().isEmpty()) {
                        return;
                    }
                    CACPacketHandler.SILK_LEASH_STATE.sendToPlayer(player, new ClientboundSilkLeashStatePacket(new ClientboundSilkLeashStatePacket.LeashData(trackedEntity.getId(), (IntList)new IntArrayList(trackedState.getLeashingEntities().stream().mapToInt(Entity::getId).toArray()), (IntList)new IntArrayList(trackedState.getLeashedByEntities().stream().mapToInt(Entity::getId).toArray()))));
                }
            }
        }
        if (target instanceof Player) {
            Player trackedPlayer = (Player)target;
            if (from instanceof ServerPlayer) {
                ServerPlayer fromPlayer = (ServerPlayer)from;
                IBubbleState bubbleState = (IBubbleState)trackedPlayer;
                IGrapplingState grappleState = (IGrapplingState)trackedPlayer;
                CACPacketHandler.BUBBLE_STATE.sendToPlayer(fromPlayer, new ClientboundBubbleStatePacket(bubbleState.isBubbleActive(), trackedPlayer.getId()));
                CACPacketHandler.GRAPPLING_STATE.sendToPlayer(fromPlayer, new ClientboundGrapplingStatePacket(grappleState.getHook() != null ? OptionalInt.of(grappleState.getHook().getId()) : OptionalInt.empty(), trackedPlayer.getId()));
            }
        }
    }

    public static void onPlayerStopTracking(Entity target, Entity by) {
        DumboOctopusEntity dumboOctopus;
        if (target instanceof DumboOctopusEntity && (dumboOctopus = (DumboOctopusEntity)target).getBubbledPlayer() == by) {
            dumboOctopus.sendBubble((ServerPlayer)by, false);
        }
    }
}

