/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.extension.IGrapplingState;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundGrapplingStatePacket;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import java.util.OptionalInt;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_3417;
import net.minecraft.class_3857;

public class GrapplingHookEntity
extends class_3857 {
    protected boolean isStick;
    protected double stickLength;
    private boolean addedToWorld;

    public GrapplingHookEntity(class_1299<? extends GrapplingHookEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public GrapplingHookEntity(class_1657 owner, class_1799 ownerStack, class_1937 level) {
        this((class_1299<? extends GrapplingHookEntity>)((class_1299)CACEntities.GRAPPLING_HOOK.get()), level);
        this.method_5808(owner.method_23317(), owner.method_23320(), owner.method_23321(), owner.method_5791(), owner.method_36455());
        this.method_7432((class_1297)owner);
        this.method_16940(ownerStack);
    }

    protected class_1792 method_16942() {
        return (class_1792)CACItems.GRAPPLING_HOOK.get();
    }

    public void method_5773() {
        super.method_5773();
        if (!this.addedToWorld) {
            this.updateOwnerState();
            this.addedToWorld = true;
        }
        double offsetLengthSqr = this.method_5858(this.method_24921());
        Double maxDistance = (Double)Services.CONFIGS.common().grapplingHookMaxDistance.get();
        double maxDistanceSqr = maxDistance * maxDistance;
        if (!(this.method_37908().method_8608() || this.isFocused() && !(offsetLengthSqr > maxDistanceSqr))) {
            this.method_31472();
            return;
        }
        class_238 collidableBox = this.method_5829().method_1014(0.25);
        Iterable collisions = this.method_37908().method_20812((class_1297)this, collidableBox);
        boolean willStick = false;
        for (class_265 shape : collisions) {
            if (shape.method_1110() || !shape.method_1107().method_994(collidableBox)) continue;
            willStick = true;
            break;
        }
        if (willStick && !this.isStick) {
            this.stickLength = offsetLengthSqr;
            this.method_43077(class_3417.field_15095);
        }
        this.isStick = willStick;
        if (this.isStick && this.method_24921() != null) {
            if (offsetLengthSqr > this.stickLength) {
                class_243 direction = this.method_19538().method_1020(this.method_24921().method_19538()).method_1029();
                Double maxSpeed = (Double)Services.CONFIGS.common().grapplingHookMaxSpeed.get();
                double scale = Math.min(maxSpeed, 0.01 * Math.sqrt(offsetLengthSqr));
                if (scale >= 0.0) {
                    this.method_24921().method_18799(this.method_24921().method_18798().method_1019(direction.method_1021(scale)));
                    this.method_24921().field_6037 = true;
                }
            }
            this.method_18800(0.0, 0.0, 0.0);
        } else {
            this.method_18799(this.method_18798().method_1021(0.98));
            this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    public void method_5650(class_1297.class_5529 removalReason) {
        super.method_5650(removalReason);
        this.updateOwnerState();
    }

    public boolean method_5640(double distance) {
        return distance < 4096.0;
    }

    public void pull() {
        if (this.method_24921() != null) {
            if (this.isStick) {
                double pullSpeed = (Double)Services.CONFIGS.common().grapplingHookSpeed.get() / 4.0;
                Double maxSpeed = (Double)Services.CONFIGS.common().grapplingHookMaxSpeed.get();
                class_243 direction = this.method_19538().method_1020(this.method_24921().method_19538()).method_1029();
                float distance = this.method_5739(this.method_24921());
                this.method_24921().method_18799(direction.method_1021(Math.min(maxSpeed, pullSpeed * (double)distance)));
            }
            this.method_31472();
        }
    }

    public void updateOwnerState() {
        class_1297 class_12972;
        if (!this.method_37908().method_8608() && this.method_24921() != null && (class_12972 = this.method_24921()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            class_12972 = this.method_24921();
            if (class_12972 instanceof IGrapplingState) {
                IGrapplingState grapplingState = (IGrapplingState)class_12972;
                grapplingState.setHook(this.method_5805() ? this : null);
                CACPacketHandler.GRAPPLING_STATE.sendToTracking((class_1297)player, new ClientboundGrapplingStatePacket(this.method_5805() ? OptionalInt.of(this.method_5628()) : OptionalInt.empty(), player.method_5628()));
            }
        }
    }

    public boolean isFocused() {
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            return class_1799.method_31577((class_1799)player.method_6047(), (class_1799)this.method_7495()) || class_1799.method_31577((class_1799)player.method_6079(), (class_1799)this.method_7495());
        }
        return false;
    }
}

