/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.render;

import info.ata4.minecraft.dragon.client.model.DragonModel;
import info.ata4.minecraft.dragon.server.entity.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class DragonRenderer
extends RenderLiving {
    public static boolean updateModel;
    private final Minecraft mc = Minecraft.func_71410_x();
    private Map breedModels = new EnumMap(DragonBreed.class);

    public DragonRenderer() {
        super(null, 0.0f);
        this.initModels();
    }

    private void initModels() {
        this.breedModels.clear();
        for (DragonBreed breed : DragonBreed.values()) {
            this.breedModels.put(breed, new DragonModel(breed));
        }
        this.setModel(EntityTameableDragon.DEFAULT_BREED);
    }

    private void setModel(DragonBreed breed) {
        this.field_77045_g = this.field_77046_h = (ModelBase)this.breedModels.get((Object)breed);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTicks) {
        this.doRender((EntityTameableDragon)entity, x, y, z, yaw, partialTicks);
    }

    public void doRender(EntityTameableDragon dragon, double x, double y, double z, float yaw, float partialTicks) {
        this.setModel(dragon.getBreed());
        this.renderOverlay(dragon);
        this.passSpecialRender2((EntityLiving)dragon, x, y, z);
        if (dragon.isEgg()) {
            this.renderEgg(dragon, x, y, z, yaw, partialTicks);
        } else {
            super.func_76986_a((Entity)dragon, x, y, z, yaw, partialTicks);
        }
    }

    protected void func_77036_a(EntityLiving entity, float moveTime, float moveSpeed, float ticksExisted, float lookYaw, float lookPitch, float scale) {
        this.renderModel((EntityTameableDragon)entity, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
    }

    protected void renderModel(EntityTameableDragon dragon, float moveTime, float moveSpeed, float ticksExisted, float lookYaw, float lookPitch, float scale) {
        ((DragonModel)this.field_77046_h).renderPass = -1;
        if (dragon.getDeathTime() > 0) {
            float alpha = (float)dragon.getDeathTime() / (float)dragon.getMaxDeathTime();
            GL11.glDepthFunc((int)515);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)alpha);
            this.func_76984_a(dragon.field_70120_cr, dragon.getTexture(3));
            this.field_77045_g.func_78088_a((Entity)dragon, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDepthFunc((int)514);
        }
        super.func_77036_a((EntityLiving)dragon, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
    }

    protected void renderEgg(EntityTameableDragon dragon, double x, double y, double z, float pitch, float partialTicks) {
        this.func_76985_a("/terrain.png");
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float tickX = dragon.getEggWiggleX();
        float tickZ = dragon.getEggWiggleZ();
        float rotX = 0.0f;
        float rotZ = 0.0f;
        if (tickX > 0.0f) {
            rotX = (float)Math.sin(tickX - partialTicks) * 8.0f;
        }
        if (tickZ > 0.0f) {
            rotZ = (float)Math.sin(tickZ - partialTicks) * 8.0f;
        }
        GL11.glRotatef((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        int bx = MathHelper.func_76128_c((double)dragon.field_70165_t);
        int by = MathHelper.func_76128_c((double)dragon.field_70163_u);
        int bz = MathHelper.func_76128_c((double)dragon.field_70161_v);
        double tx = (double)(-bx) - 0.5;
        double ty = -by;
        double tz = (double)(-bz) - 0.5;
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78373_b(tx, ty, tz);
        this.field_76988_d.field_78669_a = dragon.field_70170_p;
        this.field_76988_d.func_78612_b(Block.field_72084_bK, bx, by, bz);
        t.func_78373_b(0.0, 0.0, 0.0);
        t.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void renderOverlay(EntityTameableDragon dragon) {
        boolean playerDragon;
        EntityClientPlayerMP player = this.mc.field_71439_g;
        if (player == null) {
            return;
        }
        boolean focusedDragon = this.mc.field_71476_x != null && this.mc.field_71476_x.field_72308_g == dragon;
        boolean riddenDragon = dragon.field_70153_n == player;
        boolean bl = playerDragon = dragon.func_70909_n() && dragon.func_70905_p() != null && dragon.func_70905_p().equals(player.field_71092_bJ);
        if (playerDragon && (focusedDragon || riddenDragon)) {
            BossStatus.func_82824_a((IBossDisplayData)dragon, (boolean)false);
            BossStatus.field_82828_a = (float)dragon.func_70968_i() / (float)dragon.func_70667_aM();
        }
    }

    public int func_77032_a(EntityLiving entity, int pass, float scale) {
        return this.shouldRenderPass((EntityTameableDragon)entity, pass, scale);
    }

    public int shouldRenderPass(EntityTameableDragon dragon, int pass, float scale) {
        if (pass == 0 && updateModel && dragon.field_70173_aa % 20 == 0) {
            this.initModels();
        }
        ((DragonModel)this.field_77046_h).renderPass = pass;
        switch (pass) {
            case 0: {
                if (!dragon.isSaddled()) break;
                this.func_76985_a(dragon.getTexture(1));
                return 1;
            }
            case 1: {
                this.func_76985_a(dragon.getTexture(2));
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                GL11.glDisable((int)2896);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)65536.0f, (float)0.0f);
                return 1;
            }
            case 2: {
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3042);
            }
        }
        return -1;
    }

    protected void func_77043_a(EntityLiving par1EntityLiving, float par2, float par3, float par4) {
        this.rotateCorpse((EntityTameableDragon)par1EntityLiving, par2, par3, par4);
    }

    protected void rotateCorpse(EntityTameableDragon dragon, float par2, float par3, float par4) {
        GL11.glRotatef((float)(180.0f - par3), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    protected void func_96449_a(EntityLiving entity, double par2, double par4, double par6, String par8Str, float par9, double par10) {
        double yOfs = entity.field_70153_n != null ? 1.0 : 0.0;
        this.func_77038_a(entity, par8Str, par2, par4 + yOfs, par6, 128);
    }

    protected void func_77033_b(EntityLiving entity, double x, double y, double z) {
    }

    protected void passSpecialRender2(EntityLiving par1EntityLiving, double par2, double par4, double par6) {
        super.func_77033_b(par1EntityLiving, par2, par4, par6);
    }

    protected void func_77041_b(EntityLiving entity, float partialTicks) {
        this.preRenderCallback((EntityTameableDragon)entity, partialTicks);
    }

    protected void preRenderCallback(EntityTameableDragon dragon, float partialTicks) {
        float size = dragon.getSize() * 0.8f;
        GL11.glScalef((float)size, (float)size, (float)size);
    }
}

