/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.util;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import info.ata4.minecraft.dragon.DragonsModForge;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;

public class ThirdPersonCameraAccessor {
    private static final Logger L = DragonsModForge.L;
    private final EntityRenderer renderer;
    private float defaultDist;

    public ThirdPersonCameraAccessor(EntityRenderer renderer) {
        this.renderer = renderer;
        this.setDefaultThirdPersonDistance();
    }

    public ThirdPersonCameraAccessor() {
        this(Minecraft.func_71410_x().field_71460_t);
    }

    public void resetThirdPersonDistance() {
        this.setThirdPersonDistance(this.defaultDist);
    }

    public void setThirdPersonDistance(float dist) {
        try {
            ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.renderer, (Object)Float.valueOf(dist), (String[])new String[]{"thirdPersonDistance", "B"});
        }
        catch (Exception ex) {
            L.log(Level.WARNING, "Can't set third person distance!", ex);
        }
    }

    public float getThirdPersonDistance() {
        try {
            return ((Float)ObfuscationReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.renderer, (String[])new String[]{"thirdPersonDistance", "B"})).floatValue();
        }
        catch (Exception ex) {
            L.log(Level.WARNING, "Can't get third person distance!", ex);
            return 0.0f;
        }
    }

    private void setDefaultThirdPersonDistance() {
        this.defaultDist = this.getThirdPersonDistance();
    }

    public float getDefaultThirdPersonDistance() {
        return this.defaultDist;
    }
}

