/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import info.ata4.minecraft.dragon.DragonsModForge;
import info.ata4.minecraft.dragon.client.gui.GuiHandler;
import info.ata4.minecraft.dragon.server.block.DragonEggBlock;
import info.ata4.minecraft.dragon.server.cmd.CommandDragon;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.net.MovementInputPacketHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class ServerProxy {
    private static final Logger L = DragonsModForge.L;
    private boolean chestItems = false;

    public void preInit(FMLPreInitializationEvent evt) {
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        Property eggsInChests = config.get("world", "eggsInChests", false, "Spawns dragon eggs in generated chests when enabled");
        this.chestItems = eggsInChests.getBoolean(false);
        L.log(Level.CONFIG, "Dragon eggs in chests: {0}", this.chestItems);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public void onInit(FMLInitializationEvent evt) {
        this.registerEntities();
        this.registerLocalizations();
        this.registerBlocks();
        this.registerGUIHandlers();
        if (this.chestItems) {
            this.registerChestItems();
        }
    }

    public void onServerStarted(FMLServerStartedEvent evt) {
        this.registerServerCommands();
    }

    public void onServerStopped(FMLServerStoppedEvent evt) {
        MovementInputPacketHandler.getInstance().clearMapping();
    }

    private void registerEntities() {
        int dragonMountId = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(EntityTameableDragon.class, (String)"DragonMount", (int)dragonMountId, (int)0, (int)0xCC00FF);
    }

    private void registerLocalizations() {
        LanguageRegistry lr = LanguageRegistry.instance();
        lr.loadLocalization("/resources/dragons/lang/en_US.lang", "en_US", false);
    }

    private void registerBlocks() {
        Block.field_71973_m[Block.field_72084_bK.field_71990_ca] = null;
        Item.field_77698_e[Block.field_72084_bK.field_71990_ca] = null;
        DragonEggBlock newEgg = new DragonEggBlock();
        GameRegistry.registerBlock((Block)newEgg, (String)"dragonEggHatchable");
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            Field[] fields = Block.class.getDeclaredFields();
            boolean found = false;
            for (Field field : fields) {
                int fieldMod = field.getModifiers();
                field.setAccessible(true);
                if (!Modifier.isStatic(fieldMod)) continue;
                if (Modifier.isFinal(fieldMod)) {
                    modifiersField.setInt(field, fieldMod & 0xFFFFFFEF);
                }
                if (field.get(null) != Block.field_72084_bK) continue;
                field.set(null, (Object)newEgg);
                found = true;
                break;
            }
            if (!found) {
                L.log(Level.WARNING, "Couldn't find dragon egg block to override!");
            }
        }
        catch (Exception ex) {
            L.log(Level.WARNING, "Couldn't override dragon egg block!", ex);
        }
    }

    public void registerChestItems() {
        ChestGenHooks chestGenHooksDungeon = ChestGenHooks.getInfo((String)"dungeonChest");
        chestGenHooksDungeon.addItem(new WeightedRandomChestContent(new ItemStack(Block.field_72084_bK), 1, 1, 70));
        ChestGenHooks chestGenHooksMineshaft = ChestGenHooks.getInfo((String)"mineshaftCorridor");
        chestGenHooksMineshaft.addItem(new WeightedRandomChestContent(new ItemStack(Block.field_72084_bK), 1, 1, 5));
        ChestGenHooks chestGenHooksJungleChest = ChestGenHooks.getInfo((String)"pyramidJungleChest");
        chestGenHooksJungleChest.addItem(new WeightedRandomChestContent(new ItemStack(Block.field_72084_bK), 1, 1, 15));
        ChestGenHooks chestGenHooksDesertChest = ChestGenHooks.getInfo((String)"pyramidDesertyChest");
        chestGenHooksDesertChest.addItem(new WeightedRandomChestContent(new ItemStack(Block.field_72084_bK), 1, 1, 10));
    }

    private void registerGUIHandlers() {
        NetworkRegistry.instance().registerGuiHandler((Object)DragonsModForge.instance, (IGuiHandler)new GuiHandler());
    }

    private void registerServerCommands() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ServerCommandManager cmdman = (ServerCommandManager)server.func_71187_D();
        cmdman.func_71560_a((ICommand)new CommandDragon());
    }
}

