/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.DamageSource;
import net.minecraft.world.biome.BiomeGenBase;

public enum DragonBreed {
    END("ender", 11221438, new DamageSource[]{DamageSource.field_76376_m}, new Integer[]{Block.field_72082_bJ.field_71990_ca, Block.field_72089_ap.field_71990_ca}, new BiomeGenBase[]{BiomeGenBase.field_76779_k}),
    AIR("aether", 1950963, new DamageSource[]{DamageSource.field_76376_m}, new Integer[0], new BiomeGenBase[]{BiomeGenBase.field_76770_e}),
    WATER("sylphid", 5204392, new DamageSource[]{DamageSource.field_76369_e}, new Integer[]{Block.field_71943_B.field_71990_ca, Block.field_71942_A.field_71990_ca, Block.field_72037_aS.field_71990_ca, Block.field_72036_aT.field_71990_ca}, new BiomeGenBase[]{BiomeGenBase.field_76771_b, BiomeGenBase.field_76781_i, BiomeGenBase.field_76776_l, BiomeGenBase.field_76777_m, BiomeGenBase.field_76780_h}),
    FIRE("fire", 9833231, new DamageSource[]{DamageSource.field_76372_a, DamageSource.field_76370_b, DamageSource.field_76371_c}, new Integer[]{Block.field_71944_C.field_71990_ca, Block.field_71938_D.field_71990_ca, Block.field_72067_ar.field_71990_ca, Block.field_72052_aC.field_71990_ca}, new BiomeGenBase[]{BiomeGenBase.field_76778_j, BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s}),
    GHOST("undead", 0xBEBEBE, new DamageSource[]{DamageSource.field_82727_n}, new Integer[]{Block.field_71955_W.field_71990_ca}, new BiomeGenBase[0]);

    private static final String TEX_BASE = "/resources/dragons/textures/";
    public final int color;
    public final String bodyTex;
    public final String saddleTex;
    public final String glowTex;
    public final String dissolveTex;
    private Set immunities = new HashSet();
    private Set breedBlockIDs = new HashSet();
    private Set biomes = new HashSet();

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private DragonBreed(DamageSource[] skin, Integer[] color, BiomeGenBase[] immunity) {
        void biome;
        void blockIDs;
        this.bodyTex = TEX_BASE + (String)skin + "/body.png";
        this.saddleTex = TEX_BASE + (String)skin + "/saddle.png";
        this.glowTex = TEX_BASE + (String)skin + "/glow.png";
        this.dissolveTex = "/resources/dragons/textures/dissolve.png";
        this.color = (int)color;
        this.immunities.addAll(Arrays.asList(immunity));
        this.breedBlockIDs.addAll(Arrays.asList(blockIDs));
        this.biomes.addAll(Arrays.asList(biome));
    }

    public String getTexture(int index) {
        switch (index) {
            case 0: {
                return this.bodyTex;
            }
            case 1: {
                return this.saddleTex;
            }
            case 2: {
                return this.glowTex;
            }
            case 3: {
                return this.dissolveTex;
            }
        }
        return null;
    }

    public boolean isImmuneToDamage(DamageSource dmg) {
        if (this.immunities.isEmpty()) {
            return false;
        }
        return this.immunities.contains(dmg);
    }

    public boolean isBreedBlockID(int blockID) {
        if (this.breedBlockIDs.isEmpty()) {
            return false;
        }
        return this.breedBlockIDs.contains(blockID);
    }

    public boolean isBreedBiome(BiomeGenBase biome) {
        if (this.biomes.isEmpty()) {
            return false;
        }
        return this.biomes.contains(biome);
    }

    public int getColor() {
        return this.color;
    }

    public float getColorR() {
        return (float)(this.color >> 16 & 0xFF) / 255.0f;
    }

    public float getColorG() {
        return (float)(this.color >> 8 & 0xFF) / 255.0f;
    }

    public float getColorB() {
        return (float)(this.color & 0xFF) / 255.0f;
    }
}

