/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity;

import info.ata4.minecraft.dragon.DragonsModForge;
import info.ata4.minecraft.dragon.server.entity.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;

class DragonBreedHelper {
    private static final Logger L = DragonsModForge.L;
    private static final int BLOCK_RANGE = 2;
    private static final String NBT_BREED_POINTS = "breedPoints";
    private final EntityTameableDragon dragon;
    private Map breedPoints = new EnumMap(DragonBreed.class);

    DragonBreedHelper(EntityTameableDragon dragon) {
        this.dragon = dragon;
        for (DragonBreed breed : DragonBreed.values()) {
            this.breedPoints.put(breed, new AtomicInteger());
        }
    }

    void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound breedPointTag = new NBTTagCompound();
        for (Map.Entry breedPoint : this.breedPoints.entrySet()) {
            breedPointTag.func_74768_a(((DragonBreed)((Object)breedPoint.getKey())).name(), ((AtomicInteger)breedPoint.getValue()).get());
        }
        nbt.func_74766_a(NBT_BREED_POINTS, breedPointTag);
    }

    void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound breedPointTag = nbt.func_74775_l(NBT_BREED_POINTS);
        for (Map.Entry breedPoint : this.breedPoints.entrySet()) {
            ((AtomicInteger)breedPoint.getValue()).set(breedPointTag.func_74762_e(((DragonBreed)((Object)breedPoint.getKey())).name()));
        }
    }

    void dumpToLog() {
        L.log(Level.FINER, "Dragon {0} breeding points:", this.dragon.field_70157_k);
        for (Map.Entry breedPoint : this.breedPoints.entrySet()) {
            L.log(Level.FINER, "  {0}: {1}", new Object[]{((DragonBreed)((Object)breedPoint.getKey())).name(), ((AtomicInteger)breedPoint.getValue()).get()});
        }
    }

    void onUpdate() {
        int bx = MathHelper.func_76128_c((double)this.dragon.field_70165_t);
        int by = MathHelper.func_76128_c((double)this.dragon.field_70163_u);
        int bz = MathHelper.func_76128_c((double)this.dragon.field_70161_v);
        for (int xn = -2; xn <= 2; ++xn) {
            for (int zn = -2; zn <= 2; ++zn) {
                for (int yn = -2; yn <= 2; ++yn) {
                    int blockId = this.dragon.field_70170_p.func_72798_a(bx + xn, by + yn, bz + zn);
                    for (DragonBreed breed : DragonBreed.values()) {
                        if (!breed.isBreedBlockID(blockId)) continue;
                        ((AtomicInteger)this.breedPoints.get((Object)breed)).incrementAndGet();
                    }
                }
            }
        }
        if (this.dragon.field_70163_u > (double)this.dragon.field_70170_p.func_72800_K() * 0.66) {
            ((AtomicInteger)this.breedPoints.get((Object)DragonBreed.AIR)).addAndGet(5);
        } else if (this.dragon.field_70163_u < (double)this.dragon.field_70170_p.func_72800_K() * 0.25 && !this.dragon.field_70170_p.func_72937_j(bx, by, bz) && this.dragon.field_70170_p.func_72957_l(bx, by, bz) <= 4) {
            ((AtomicInteger)this.breedPoints.get((Object)DragonBreed.GHOST)).addAndGet(5);
        }
        BiomeGenBase biome = this.dragon.field_70170_p.func_72807_a(bx, bz);
        for (DragonBreed breed : DragonBreed.values()) {
            if (!breed.isBreedBiome(biome)) continue;
            ((AtomicInteger)this.breedPoints.get((Object)breed)).incrementAndGet();
        }
        int maxPoints = 0;
        DragonBreed dominantBreed = this.dragon.getBreed();
        for (Map.Entry breedPoint : this.breedPoints.entrySet()) {
            int points = ((AtomicInteger)breedPoint.getValue()).get();
            if (points <= maxPoints) continue;
            dominantBreed = (DragonBreed)((Object)breedPoint.getKey());
            maxPoints = points;
        }
        this.dragon.setBreed(dominantBreed);
        if (L.isLoggable(Level.FINER)) {
            this.dumpToLog();
            L.log(Level.FINER, "Dominant: {0}", dominantBreed.name());
        }
    }

    void onBreedChanged(DragonBreed oldBreed, DragonBreed newBreed) {
        PathNavigate nav = this.dragon.func_70661_as();
        nav.func_75504_d(newBreed == DragonBreed.GHOST);
        nav.func_75491_a(newBreed == DragonBreed.FIRE);
        this.dragon.setImmuneToFire(newBreed == DragonBreed.FIRE);
    }

    EnumCreatureAttribute getCreatureAttribute() {
        return this.dragon.getBreed() == DragonBreed.GHOST ? EnumCreatureAttribute.UNDEAD : EnumCreatureAttribute.UNDEFINED;
    }

    void addBreedPoints(DragonBreed breed, int points) {
        ((AtomicInteger)this.breedPoints.get((Object)breed)).addAndGet(points);
    }
}

