/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity;

import info.ata4.minecraft.dragon.util.math.MathX;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntityFlyingTameable
extends EntityTameable {
    private static final int INDEX_FLYING = 18;
    private static String NBT_FLYING = "Flying";
    private static String NBT_WAYPOINT_X = "WaypointX";
    private static String NBT_WAYPOINT_Y = "WaypointX";
    private static String NBT_WAYPOINT_Z = "WaypointX";
    protected float moveSpeedAir = 1.0f;
    protected float moveSpeedAirVert = 0.0f;
    public int yawSpeed = 30;
    public int inAirTicks;
    protected Vec3 waypoint = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    protected float yawAdd;
    protected EntityAITasks airTasks;
    protected boolean canFly = true;

    public EntityFlyingTameable(World world) {
        super(world);
        this.airTasks = new EntityAITasks(world != null ? world.field_72984_F : null);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a(NBT_FLYING, this.isFlying());
        nbt.func_74780_a(NBT_WAYPOINT_X, this.waypoint.field_72450_a);
        nbt.func_74780_a(NBT_WAYPOINT_Y, this.waypoint.field_72448_b);
        nbt.func_74780_a(NBT_WAYPOINT_Z, this.waypoint.field_72449_c);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setFlying(nbt.func_74767_n(NBT_FLYING));
        this.waypoint.field_72450_a = nbt.func_74769_h(NBT_WAYPOINT_X);
        this.waypoint.field_72448_b = nbt.func_74769_h(NBT_WAYPOINT_Y);
        this.waypoint.field_72449_c = nbt.func_74769_h(NBT_WAYPOINT_Z);
    }

    public boolean isFlying() {
        return (this.field_70180_af.func_75683_a(18) & 1) != 0;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_75692_b(18, (Object)(flying ? (byte)1 : 0));
    }

    public void func_70636_d() {
        if (this.field_70734_aK <= 0) {
            return;
        }
        if (this.isServer()) {
            this.inAirTicks = !this.field_70122_E ? ++this.inAirTicks : 0;
            this.setFlying(this.inAirTicks > 10 && this.canFly);
        }
        if (this.isFlying()) {
            this.field_70177_z = MathX.normDeg(this.field_70177_z);
            if (this.isClient()) {
                this.onFlyingClient();
            } else {
                this.onFlyingServer();
            }
            this.field_70761_aq = this.field_70177_z;
        } else {
            if (this.isClient()) {
                this.onGroundClient();
            } else {
                this.onGroundServer();
            }
            super.func_70636_d();
        }
    }

    protected void onFlyingClient() {
        if (this.field_70716_bi > 0) {
            double px = this.field_70165_t + (this.field_70709_bj - this.field_70165_t) / (double)this.field_70716_bi;
            double py = this.field_70163_u + (this.field_70710_bk - this.field_70163_u) / (double)this.field_70716_bi;
            double pz = this.field_70161_v + (this.field_70711_bl - this.field_70161_v) / (double)this.field_70716_bi;
            double newYaw = MathX.normDeg(this.field_70712_bm - (double)this.field_70177_z);
            this.field_70177_z += (float)newYaw / (float)this.field_70716_bi;
            this.field_70125_A += ((float)this.field_70705_bn - this.field_70125_A) / (float)this.field_70716_bi;
            --this.field_70716_bi;
            this.func_70107_b(px, py, pz);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    protected void onFlyingServer() {
        double deltaX = this.waypoint.field_72450_a - this.field_70165_t;
        double deltaY = this.waypoint.field_72448_b - this.field_70163_u;
        double deltaZ = this.waypoint.field_72449_c - this.field_70161_v;
        double dist = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        if (dist > 0.001) {
            deltaY /= Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            deltaY = MathX.clamp(deltaY, (double)(-this.moveSpeedAir), (double)this.moveSpeedAir) / 3.0;
            double newYaw = Math.toDegrees(Math.PI * 2 - Math.atan2(deltaX, deltaZ));
            double yawDelta = MathX.normDeg(newYaw - (double)this.field_70177_z);
            yawDelta = MathX.clamp(yawDelta, (double)(-this.yawSpeed), (double)this.yawSpeed);
            Vec3 motionVec = Vec3.field_82592_a.func_72345_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
            Vec3 deltaVec = Vec3.field_82592_a.func_72345_a(deltaX, deltaY, deltaZ).func_72432_b();
            Vec3 rotVec = Vec3.field_82592_a.func_72345_a(-Math.sin(Math.toRadians(this.field_70177_z)), this.field_70181_x, Math.cos(Math.toRadians(this.field_70177_z))).func_72432_b();
            double motion1 = Math.hypot(this.field_70159_w, this.field_70179_y) + 1.0;
            double motion2 = motion1 > 40.0 ? 40.0 : motion1;
            this.yawAdd *= 0.8f;
            this.yawAdd = (float)((double)this.yawAdd + yawDelta * (0.7 / motion2 / motion1));
            this.field_70177_z += this.yawAdd * 0.1f;
            float tmp1 = (float)(rotVec.func_72430_b(deltaVec) + 0.5) / 1.5f;
            if (tmp1 < 0.0f) {
                tmp1 = 0.0f;
            }
            float tmp2 = (float)(2.0 / (motion2 + 1.0));
            float acc = 0.06f * (tmp1 * tmp2 + (1.0f - tmp2));
            this.field_70181_x = deltaY + (double)this.moveSpeedAirVert;
            this.func_70060_a(0.0f, this.moveSpeedAir, acc);
            float friction = (float)(motionVec.func_72430_b(rotVec) + 1.0) / 2.0f;
            friction = 0.8f + 0.15f * friction;
            if (this.field_70171_ac) {
                friction *= 0.8f;
            }
            this.field_70159_w *= (double)friction;
            this.field_70181_x *= (double)friction;
            this.field_70179_y *= (double)friction;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        if (this.func_70650_aV()) {
            this.field_70170_p.field_72984_F.func_76320_a("newAi");
            this.func_70619_bc();
            this.field_70170_p.field_72984_F.func_76319_b();
        } else {
            this.field_70170_p.field_72984_F.func_76320_a("oldAi");
            this.func_70626_be();
            this.field_70170_p.field_72984_F.func_76319_b();
            this.field_70759_as = this.field_70177_z;
        }
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.0));
        if (entities != null && !entities.isEmpty()) {
            for (Entity entity : entities) {
                if (!entity.func_70104_M()) continue;
                entity.func_70108_f((Entity)this);
            }
        }
    }

    protected void onGroundClient() {
    }

    protected void onGroundServer() {
        this.resetWaypoint();
    }

    public void setWaypoint(double x, double y, double z) {
        this.waypoint.field_72450_a = x;
        this.waypoint.field_72448_b = y;
        this.waypoint.field_72449_c = z;
    }

    public void setWaypoint(Vec3 waypoint) {
        this.setWaypoint(waypoint.field_72450_a, waypoint.field_72448_b, waypoint.field_72449_c);
    }

    public void resetWaypoint() {
        this.setWaypoint(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public double getDistanceTo(Vec3 vec) {
        double tx = vec.field_72450_a - this.field_70165_t;
        double ty = vec.field_72448_b - this.field_70163_u;
        double tz = vec.field_72449_c - this.field_70161_v;
        return tx * tx + ty * ty + tz * tz;
    }

    public double getDistanceToWaypoint() {
        return this.getDistanceTo(this.waypoint);
    }

    public float getYawSpeed() {
        return 6.0f;
    }

    public float getMoveSpeedAir() {
        return this.moveSpeedAir;
    }

    public void setMoveSpeedAir(float moveSpeedAir) {
        this.moveSpeedAir = moveSpeedAir;
    }

    public float getMoveSpeedAirVertical() {
        return this.moveSpeedAirVert;
    }

    public void setMoveSpeedAirVertical(float moveSpeedAirVert) {
        this.moveSpeedAirVert = moveSpeedAirVert;
    }

    public float getMoveSpeedGround() {
        return this.field_70697_bw;
    }

    public void setMoveSpeedGround(float moveSpeed) {
        this.field_70697_bw = moveSpeed;
    }

    public double getAltitude() {
        int blockX = (int)(this.field_70165_t - 0.5);
        int blockZ = (int)(this.field_70161_v - 0.5);
        return this.field_70163_u - (double)this.field_70170_p.func_72976_f(blockX, blockZ);
    }

    protected void func_70664_aZ() {
        super.func_70664_aZ();
        this.field_70181_x += 0.5;
        this.inAirTicks += 20;
    }

    protected void func_70619_bc() {
        if (this.isFlying()) {
            this.airTasks.func_75774_a();
        }
        super.func_70619_bc();
    }

    public boolean isClient() {
        return this.field_70170_p.field_72995_K;
    }

    public boolean isServer() {
        return !this.field_70170_p.field_72995_K;
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.field_70153_n instanceof EntityLiving) {
            EntityLiving rider = (EntityLiving)this.field_70153_n;
            rider.field_70127_C = rider.field_70125_A;
            rider.field_70126_B = rider.field_70177_z;
            rider.field_70761_aq = this.field_70761_aq;
        }
    }
}

