/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import info.ata4.minecraft.dragon.DragonsModForge;
import info.ata4.minecraft.dragon.client.model.anim.DragonAnimator;
import info.ata4.minecraft.dragon.server.entity.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.DragonBreedHelper;
import info.ata4.minecraft.dragon.server.entity.DragonLifeStage;
import info.ata4.minecraft.dragon.server.entity.EntityFlyingTameable;
import info.ata4.minecraft.dragon.server.entity.ai.DragonBodyHelper;
import info.ata4.minecraft.dragon.server.entity.ai.DragonMoveHelper;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIBlock;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIDragonMate;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIFlyToOwner;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIFlyToTarget;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIFollowConspecific;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIFollowOwnerGround;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIPanicChild;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIRideAir;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIRideGround;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIRoamAir;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAITargetAttacker;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIWatchLiving;
import info.ata4.minecraft.dragon.server.util.ItemUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityTameableDragon
extends EntityFlyingTameable
implements IBossDisplayData,
IAnimals {
    private static final Logger L = DragonsModForge.L;
    public static final DragonBreed DEFAULT_BREED = DragonBreed.END;
    private static final int INDEX_SADDLED = 19;
    private static final int INDEX_HEALTH = 20;
    private static final int INDEX_BREEDER = 21;
    private static final int INDEX_BREED = 22;
    private static final String NBT_SADDLED = "Saddle";
    private static final String NBT_BREEDER = "HatchedBy";
    private static final String NBT_BREED = "Breed";
    private DragonLifeStage lifeStage = null;
    private DragonLifeStage lifeStagePrev = null;
    private DragonBreed breed = DEFAULT_BREED;
    private DragonBreedHelper breedHelper;
    private DragonAnimator animator;
    private int eggWiggleX;
    private int eggWiggleZ;

    public EntityTameableDragon(World world) {
        super(world);
        try {
            ObfuscationReflectionHelper.setPrivateValue(EntityLiving.class, (Object)((Object)this), (Object)((Object)new DragonMoveHelper(this)), (String[])new String[]{"moveHelper", "bK"});
            ObfuscationReflectionHelper.setPrivateValue(EntityLiving.class, (Object)((Object)this), (Object)((Object)new DragonBodyHelper(this)), (String[])new String[]{"bodyHelper", "bM"});
        }
        catch (Exception ex) {
            L.log(Level.WARNING, "Can't override AI helper!", ex);
        }
        this.breedHelper = new DragonBreedHelper(this);
        this.field_70138_W = 1.0f;
        this.field_70697_bw = 0.3f;
        this.moveSpeedAir = 1.0f;
        this.field_70747_aH = this.field_70746_aG;
        this.field_70158_ak = true;
        if (this.isClient()) {
            this.animator = new DragonAnimator(this);
        } else {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIBlock(this));
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRideGround(this, this.field_70697_bw));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIDragonMate(this, this.field_70697_bw * 0.75f));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, this.field_70697_bw * 0.5f, Item.field_77754_aU.field_77779_bT, false));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackOnCollide((EntityLiving)this, this.field_70697_bw, true));
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFollowConspecific((EntityAnimal)this, this.field_70697_bw * 0.8f));
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollowOwnerGround(this, this.field_70697_bw, 12.0f, 24.0f, 32.0f));
            this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIPanicChild(this, this.field_70697_bw));
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, this.field_70697_bw));
            this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchLiving(this, 16.0f, 0.05f));
            this.airTasks.func_75776_a(0, (EntityAIBase)new EntityAIRideAir(this, this.moveSpeedAir));
            this.airTasks.func_75776_a(1, (EntityAIBase)new EntityAIRoamAir(this, this.moveSpeedAir, 100.0, 22500.0, 80, 32, 0.12f));
            this.airTasks.func_75776_a(2, (EntityAIBase)new EntityAIFlyToTarget(this, this.moveSpeedAir));
            this.airTasks.func_75776_a(3, (EntityAIBase)new EntityAIFlyToOwner(this, this.moveSpeedAir));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttacker((EntityLiving)this, false));
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)"");
        this.field_70180_af.func_75682_a(22, (Object)DEFAULT_BREED.name());
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a(NBT_SADDLED, this.isSaddled());
        nbt.func_74778_a(NBT_BREEDER, this.getBreederName() == null ? "" : this.getBreederName());
        nbt.func_74778_a(NBT_BREED, this.getBreed() == null ? "" : this.getBreed().name());
        this.breedHelper.writeToNBT(nbt);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSaddled(nbt.func_74767_n(NBT_SADDLED));
        this.setBreederName(nbt.func_74779_i(NBT_BREEDER));
        String breedName = nbt.func_74779_i(NBT_BREED);
        try {
            this.setBreed(DragonBreed.valueOf(breedName));
        }
        catch (IllegalArgumentException ex) {
            L.log(Level.WARNING, "Dragon {0} loaded with invalid breed type {1}, using {2}", new Object[]{this.field_70157_k, breedName, DEFAULT_BREED.name()});
            this.setBreed(DEFAULT_BREED);
        }
        this.breedHelper.readFromNBT(nbt);
    }

    public boolean isSaddled() {
        return (this.field_70180_af.func_75683_a(19) & 1) != 0;
    }

    public void setSaddled(boolean saddled) {
        if (this.isSaddled() != saddled) {
            L.log(Level.FINE, "Dragon {0} changed saddled to {1}", new Object[]{this.field_70157_k, saddled});
        }
        this.field_70180_af.func_75692_b(19, (Object)(saddled ? (byte)1 : 0));
    }

    public DragonBreed getBreed() {
        block3: {
            String breedName = this.field_70180_af.func_75681_e(22);
            if (this.breed.name().equals(breedName)) {
                return this.breed;
            }
            try {
                this.breed = DragonBreed.valueOf(breedName);
            }
            catch (IllegalArgumentException ex) {
                this.breed = DEFAULT_BREED;
                if (!this.isServer()) break block3;
                L.log(Level.WARNING, "Dragon {0} fixed invalid breed type {1} to {2}", new Object[]{this.field_70157_k, breedName, DEFAULT_BREED.name()});
                this.setBreed(this.breed);
            }
        }
        return this.breed;
    }

    public void setBreed(DragonBreed breed) {
        DragonBreed oldBreed = this.getBreed();
        this.field_70180_af.func_75692_b(22, (Object)breed.name());
        if (oldBreed != breed) {
            L.log(Level.FINE, "Dragon {0} changed breed to {1}", new Object[]{this.field_70157_k, breed});
            this.breedHelper.onBreedChanged(oldBreed, breed);
        }
    }

    public int func_70968_i() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setDragonHealth(int health) {
        if (this.func_70968_i() != health) {
            L.log(Level.FINE, "Dragon {0} health set to {1}", new Object[]{this.field_70157_k, health});
        }
        this.field_70180_af.func_75692_b(20, (Object)health);
    }

    public String getBreederName() {
        return this.field_70180_af.func_75681_e(21);
    }

    public EntityPlayer getBreeder() {
        String breederName = this.getBreederName();
        return this.field_70170_p.func_72924_a(breederName);
    }

    public void setBreederName(String breederName) {
        if (!this.getBreederName().equals(breederName)) {
            L.log(Level.FINE, "Dragon {0} breeder set to {1}", new Object[]{this.field_70157_k, breederName});
        }
        this.field_70180_af.func_75692_b(21, (Object)breederName);
    }

    public boolean isOwner(EntityPlayer player) {
        return player.field_71092_bJ.equalsIgnoreCase(this.func_70905_p());
    }

    public boolean isRiddenByOwner() {
        return this.field_70153_n == this.func_70902_q();
    }

    public String func_70023_ak() {
        if (this.func_94056_bM()) {
            return this.func_94057_bL();
        }
        String entName = EntityList.func_75621_b((Entity)this);
        return StatCollector.func_74838_a((String)("entity." + entName + "." + this.breed.name().toLowerCase() + ".name"));
    }

    public EntityPlayer getRidingPlayer() {
        if (this.field_70153_n instanceof EntityPlayer) {
            return (EntityPlayer)this.field_70153_n;
        }
        return null;
    }

    public void setRidingPlayer(EntityPlayer player) {
        if (this.field_70153_n == player) {
            float heightTmp = this.field_70131_O;
            this.field_70131_O = 1.0f;
            player.func_70078_a(null);
            this.field_70131_O = heightTmp;
        } else {
            player.func_70078_a((Entity)this);
        }
    }

    public DragonAnimator getAnimator() {
        return this.animator;
    }

    @Override
    public void func_70636_d() {
        int age = this.func_70874_b();
        this.lifeStage = DragonLifeStage.getLifeStageForAge(age);
        if (this.lifeStagePrev != this.lifeStage) {
            this.onNewLifeStage();
            this.lifeStagePrev = this.lifeStage;
        }
        if (this.isServer() && this.func_70906_o() && (this.isHatchling() || this.isJuvenile())) {
            this.field_70911_d.func_75270_a(false);
        }
        if (this.isClient()) {
            if (this.isEgg()) {
                int hatchAge;
                int eggAge = DragonLifeStage.EGG.getAgeLimit();
                float chance = (float)(age - eggAge) / (float)((hatchAge = DragonLifeStage.HATCHLING.getAgeLimit()) - eggAge);
                if (chance > 0.66f) {
                    chance /= 60.0f;
                    if (this.eggWiggleX > 0) {
                        --this.eggWiggleX;
                    } else if (this.field_70146_Z.nextFloat() < chance) {
                        this.eggWiggleX = this.field_70146_Z.nextBoolean() ? 10 : 20;
                        this.playEggCrackEffect();
                    }
                    if (this.eggWiggleZ > 0) {
                        --this.eggWiggleZ;
                    } else if (this.field_70146_Z.nextFloat() < chance) {
                        this.eggWiggleZ = this.field_70146_Z.nextBoolean() ? 10 : 20;
                        this.playEggCrackEffect();
                    }
                }
                double px = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5);
                double py = this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5);
                double pz = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5);
                double ox = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                double oy = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                double oz = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                this.field_70170_p.func_72869_a("portal", px, py, pz, ox, oy, oz);
                if (this.breed != DEFAULT_BREED && this.field_70173_aa % 2 == 0) {
                    this.field_70170_p.func_72869_a("reddust", px, py + 1.0, pz, (double)this.breed.getColorR(), (double)this.breed.getColorG(), (double)this.breed.getColorB());
                }
            } else {
                this.animator.setOnGround(!this.isFlying());
                this.animator.update();
            }
        } else {
            this.setDragonHealth(this.field_70734_aK);
            if (this.isEgg() && this.field_70173_aa % 20 == 0) {
                this.breedHelper.onUpdate();
            }
        }
        super.func_70636_d();
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70078_a(null);
        }
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70177_z = this.field_70126_B;
        this.field_70759_as = this.field_70758_at;
        if (this.isEgg()) {
            if (this.isClient()) {
                this.playEggCrackEffect();
            }
            this.func_70106_y();
        } else {
            if (this.isClient() && this.field_70725_aQ < this.getMaxDeathTime() - 20) {
                this.spawnBodyParticles("cloud", 4);
            }
            if (this.field_70725_aQ == this.getMaxDeathTime()) {
                this.func_70106_y();
            }
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (this.isEgg()) {
            return false;
        }
        if (this.func_70909_n() || this.func_70631_g_()) {
            ItemFood food = null;
            if (this.func_70968_i() != this.func_70667_aM()) {
                food = (ItemFood)ItemUtils.consumeEquipped(player, Item.field_77754_aU, Item.field_77784_aq, Item.field_77741_bi, Item.field_77735_bk);
            }
            if (food != null) {
                this.func_70691_i(food.func_77847_f());
                this.field_70170_p.func_72956_a((Entity)this, "random.eat", 0.7f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.5f);
                return true;
            }
            if (!this.isOwner(player)) {
                if (this.isServer()) {
                    player.func_71035_c("dragon.owned");
                }
            } else if (!this.func_70631_g_()) {
                if (!this.isSaddled() && ItemUtils.consumeEquipped(player, Item.field_77765_aA)) {
                    if (this.isServer()) {
                        L.log(Level.FINE, "Dragon {0} was saddled by {1}", new Object[]{this.field_70157_k, player.field_71092_bJ});
                        this.setSaddled(true);
                    }
                } else if (this.field_70153_n == null && ItemUtils.hasEquipped(player, Item.field_77755_aX)) {
                    if (this.isServer()) {
                        L.log(Level.FINE, "Dragon {0} was told to sit by {1}", new Object[]{this.field_70157_k, player.field_71092_bJ});
                        this.field_70911_d.func_75270_a(!this.func_70906_o());
                        this.field_70703_bu = false;
                        this.func_70778_a(null);
                    }
                } else if (this.field_70153_n == null && ItemUtils.hasEquipped(player, Item.field_77760_aL)) {
                    if (this.isClient()) {
                        player.openGui((Object)DragonsModForge.instance, 0, this.field_70170_p, this.field_70157_k, 0, 0);
                    }
                } else if (this.field_70153_n == null && ItemUtils.consumeEquipped(player, Item.field_77754_aU)) {
                    if (this.isClient()) {
                        this.spawnBodyParticles("heart");
                    }
                    this.field_70881_d = 600;
                    this.field_70789_a = null;
                } else if (this.isSaddled() && !ItemUtils.hasEquippedUsable(player) && this.isServer()) {
                    L.log(Level.FINE, "Dragon {0} got a mount request from {1}", new Object[]{this.field_70157_k, player.field_71092_bJ});
                    this.setRidingPlayer(player);
                }
            }
        } else {
            if (this.isServer() && ItemUtils.consumeEquipped(player, Item.field_77754_aU)) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.func_70778_a(null);
                    this.func_70624_b(null);
                    this.func_70910_a(player.field_71092_bJ);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return false;
    }

    protected void func_70628_a(boolean par1, int par2) {
        super.func_70628_a(par1, par2);
        if (this.isSaddled()) {
            this.func_70025_b(Item.field_77765_aA.field_77779_bT, 1);
        }
    }

    public boolean func_70652_k(Entity victim) {
        this.field_70170_p.func_72956_a((Entity)this, "random.eat", 0.7f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.5f);
        this.field_70724_aR = 20;
        this.func_70607_j(victim);
        int damage = (int)(8.0f * this.getSize());
        return victim.func_70097_a(DamageSource.func_76358_a((EntityLiving)this), damage);
    }

    public boolean func_70097_a(DamageSource src, int par2) {
        if (this.isImmuneToDamage(src)) {
            return false;
        }
        this.field_70911_d.func_75270_a(false);
        if (!this.isEgg() && src.func_76346_g() != null && src.func_76346_g() != this.func_70643_av() && src.func_76346_g() != this.func_70902_q()) {
            this.field_70170_p.func_72956_a((Entity)this, "mob.enderdragon.growl", 1.0f, 0.5f + 1.0f / this.lifeStage.getSize() * 0.5f);
        }
        return super.func_70097_a(src, par2);
    }

    public boolean isImmuneToDamage(DamageSource src) {
        Entity srcEnt = src.func_76346_g();
        if (srcEnt != null) {
            if (srcEnt == this) {
                return true;
            }
            if (srcEnt == this.field_70153_n) {
                return true;
            }
        }
        if (src.field_76373_n.equals("inWall")) {
            return true;
        }
        if (src.field_76373_n.equals("drown")) {
            return true;
        }
        return this.breed.isImmuneToDamage(src);
    }

    public boolean func_70067_L() {
        EntityPlayer rider = this.getRidingPlayer();
        if (rider != null && ItemUtils.hasEquipped(rider, (Item)Item.field_77707_k)) {
            return false;
        }
        return super.func_70067_L();
    }

    protected void func_70069_a(float par1) {
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public boolean func_70104_M() {
        return this.isEgg();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void transformToEgg() {
        if (this.func_70630_aN() <= 0) {
            return;
        }
        this.field_70170_p.func_72956_a((Entity)this, "mob.enderdragon.transform", 1.0f, 0.5f + (0.5f - this.field_70146_Z.nextFloat()) * 0.1f);
        if (this.isSaddled()) {
            this.func_70025_b(Item.field_77765_aA.field_77779_bT, 1);
        }
        this.func_70099_a(new ItemStack(Block.field_72084_bK), 0.0f);
        this.func_70106_y();
        L.log(Level.FINE, "Dragon {0} transformed to egg", this.field_70157_k);
    }

    public float func_70047_e() {
        float eyeHeight = this.field_70131_O;
        eyeHeight *= 2.0f + (float)this.func_70968_i() / (float)this.func_70667_aM() * 2.0f;
        if (this.func_70906_o()) {
            eyeHeight *= 0.8f;
        }
        return eyeHeight;
    }

    public boolean func_70878_b(EntityAnimal mate) {
        if (mate == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(mate instanceof EntityTameableDragon)) {
            return false;
        }
        EntityTameableDragon dragonMate = (EntityTameableDragon)mate;
        return !dragonMate.func_70909_n() ? false : this.func_70880_s() && dragonMate.func_70880_s();
    }

    public EntityAgeable func_90011_a(EntityAgeable mate) {
        if (!(mate instanceof EntityTameableDragon)) {
            throw new IllegalArgumentException("The mate isn't a dragon");
        }
        EntityTameableDragon parent1 = this;
        EntityTameableDragon parent2 = (EntityTameableDragon)mate;
        EntityTameableDragon baby = new EntityTameableDragon(this.field_70170_p);
        if (this.func_70909_n()) {
            if (parent1.func_94056_bM() && parent2.func_94056_bM()) {
                String babyName;
                String p1Name = parent1.func_94057_bL();
                String p2Name = parent2.func_94057_bL();
                if (p1Name.contains(" ") || p2Name.contains(" ")) {
                    String[] p1Names = p1Name.split(" ");
                    String[] p2Names = p2Name.split(" ");
                    p1Name = this.fixName(p1Names[this.field_70146_Z.nextInt(p1Names.length)]);
                    p2Name = this.fixName(p2Names[this.field_70146_Z.nextInt(p2Names.length)]);
                    babyName = this.field_70146_Z.nextBoolean() ? p1Name + " " + p2Name : p2Name + " " + p1Name;
                } else {
                    p1Name = this.field_70146_Z.nextBoolean() ? p1Name.substring(0, (p1Name.length() - 1) / 2) : p1Name.substring((p1Name.length() - 1) / 2);
                    p2Name = this.field_70146_Z.nextBoolean() ? p2Name.substring(0, (p2Name.length() - 1) / 2) : p2Name.substring((p2Name.length() - 1) / 2);
                    p2Name = this.fixName(p2Name);
                    babyName = this.field_70146_Z.nextBoolean() ? p1Name + p2Name : p2Name + p1Name;
                }
                baby.func_94058_c(babyName);
            }
            baby.breedHelper.addBreedPoints(parent1.getBreed(), 1800 + parent1.field_70146_Z.nextInt(1800));
            baby.breedHelper.addBreedPoints(parent2.getBreed(), 1800 + parent2.field_70146_Z.nextInt(1800));
        }
        return baby;
    }

    private String fixName(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        char[] chars = text.toLowerCase().toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public String getTexture(int index) {
        return this.getBreed().getTexture(index);
    }

    public String func_70073_O() {
        return this.getTexture(0);
    }

    public double func_70042_X() {
        return this.func_70906_o() ? (double)1.7f : (double)2.2f;
    }

    protected String func_70639_aQ() {
        if (this.isEgg() || this.isFlying()) {
            return "";
        }
        if (this.getBreed() == DragonBreed.GHOST) {
            return "mob.skeleton.say";
        }
        return "mob.enderdragon.idle";
    }

    protected String func_70621_aR() {
        if (this.isEgg()) {
            return "mob.zombie.wood";
        }
        return "mob.enderdragon.hit";
    }

    protected String func_70673_aS() {
        if (this.isEgg()) {
            return "mob.zombie.woodbreak";
        }
        return "mob.enderdragon.death";
    }

    protected String getWingsSound() {
        return this.field_70171_ac ? null : "mob.enderdragon.wings";
    }

    protected void func_70036_a(int x, int y, int z, int blockId) {
        if (!this.isEgg() && !this.field_70171_ac) {
            if (this.isHatchling()) {
                super.func_70036_a(x, y, z, blockId);
            } else {
                this.field_70170_p.func_72956_a((Entity)this, "mob.enderdragon.walk", 0.5f, 1.0f);
            }
        }
    }

    public void func_70642_aH() {
        String sound;
        if (!this.field_70171_ac && (sound = this.func_70639_aQ()) != null && this.field_70146_Z.nextBoolean()) {
            this.func_85030_a(sound, this.func_70599_aP(), this.func_70647_i() * 0.5f);
        }
    }

    public void onWingsDown(float speed) {
        float pitch = 0.8f + (0.5f - this.field_70146_Z.nextFloat()) * 0.3f + (1.0f - speed) * 0.2f;
        float volume = 0.3f + (1.0f - speed) * 0.2f;
        this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getWingsSound(), volume, pitch *= this.getSize(), false);
    }

    protected void spawnBodyParticle(String effect) {
        double oz;
        double oy;
        double ox;
        float s = this.getSize() * 1.2f;
        if (effect.equals("explode")) {
            ox = this.field_70146_Z.nextGaussian() * (double)s;
            oy = this.field_70146_Z.nextGaussian() * (double)s;
            oz = this.field_70146_Z.nextGaussian() * (double)s;
        } else if (effect.equals("cloud")) {
            ox = (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
            oy = this.field_70146_Z.nextDouble() * 0.2;
            oz = (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
        } else if (effect.equals("reddust")) {
            ox = 0.8;
            oy = 0.0;
            oz = 0.8;
        } else {
            ox = 0.0;
            oy = 0.0;
            oz = 0.0;
        }
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * (double)s;
        double y = this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70131_O * (double)s;
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * (double)s;
        this.field_70170_p.func_72869_a(effect, x, y, z, ox, oy, oz);
    }

    protected void spawnBodyParticles(String effect, int baseAmount) {
        int amount = (int)((float)baseAmount * this.getSize());
        for (int i = 0; i < amount; ++i) {
            this.spawnBodyParticle(effect);
        }
    }

    protected void spawnBodyParticles(String effect) {
        this.spawnBodyParticles(effect, 32);
    }

    public void func_70656_aK() {
        this.spawnBodyParticles("explode");
    }

    protected void func_70908_e(boolean success) {
        this.spawnBodyParticles(success ? "heart" : "smoke");
    }

    public int getEggWiggleX() {
        return this.eggWiggleX;
    }

    public int getEggWiggleZ() {
        return this.eggWiggleZ;
    }

    public int getDeathTime() {
        return this.field_70725_aQ;
    }

    public int getMaxDeathTime() {
        return 120;
    }

    public int func_70667_aM() {
        return (int)(80.0f * this.getSize());
    }

    public float getSize() {
        return this.getLifeStage().getSize();
    }

    public DragonLifeStage getLifeStage() {
        return this.lifeStage == null ? DragonLifeStage.EGG : this.lifeStage;
    }

    public final void setLifeStage(DragonLifeStage lifeStage) {
        this.func_70873_a(lifeStage.getAgeLimit());
    }

    public boolean isEgg() {
        return this.lifeStage == DragonLifeStage.EGG;
    }

    public boolean isHatchling() {
        return this.lifeStage == DragonLifeStage.HATCHLING;
    }

    public boolean isJuvenile() {
        return this.lifeStage == DragonLifeStage.JUVENILE;
    }

    public boolean isAdult() {
        return this.lifeStage == DragonLifeStage.ADULT;
    }

    private void onNewLifeStage() {
        L.log(Level.FINE, "Dragon {0} entered life stage {1}", new Object[]{this.field_70157_k, this.lifeStage});
        boolean hatched = this.lifeStagePrev == DragonLifeStage.EGG && this.isHatchling();
        boolean bl = this.canFly = !this.isEgg() && !this.isHatchling();
        if (this.isClient()) {
            if (hatched) {
                this.playEggCrackEffect();
            } else {
                this.func_70656_aK();
            }
        } else {
            this.func_70661_as().func_75490_c(this.isHatchling());
            if (this.isEgg()) {
                this.field_70911_d.func_75270_a(true);
                this.func_70778_a(null);
                this.func_70624_b(null);
            }
            this.func_70606_j(this.func_70667_aM());
        }
        this.func_70105_a(-1.0f, 0.0f);
        if (this.isEgg()) {
            this.func_70105_a(0.98f, 0.98f);
        } else {
            float multi = this.getSize();
            this.func_70105_a(multi * 4.0f, multi * 3.0f);
        }
    }

    @Override
    protected void func_70619_bc() {
        if (!this.isEgg()) {
            super.func_70619_bc();
        }
    }

    private void playEggCrackEffect() {
        int bx = (int)Math.round(this.field_70165_t - 0.5);
        int by = (int)Math.round(this.field_70163_u);
        int bz = (int)Math.round(this.field_70161_v - 0.5);
        this.field_70170_p.func_72926_e(2001, bx, by, bz, Block.field_72084_bK.field_71990_ca);
    }

    void setImmuneToFire(boolean isImmuneToFire) {
        this.field_70178_ae = isImmuneToFire;
    }

    @Override
    protected void func_70664_aZ() {
        if (this.isRiddenByOwner()) {
            super.func_70664_aZ();
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return this.breedHelper.getCreatureAttribute();
    }

    public void func_98054_a(boolean par1) {
    }
}

