/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.ai;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityAIFollowOwnerGround
extends EntityAIBase {
    private final EntityTameableDragon dragon;
    private EntityLiving owner;
    private final float moveSpeed;
    private final float minDist;
    private final float maxDist;
    private final float maxDistTele;
    private boolean avoidWater;
    private PathNavigate nav;

    public EntityAIFollowOwnerGround(EntityTameableDragon dragon, float moveSpeed, float minDist, float maxDist, float maxDistTele) {
        this.dragon = dragon;
        this.nav = dragon.func_70661_as();
        this.moveSpeed = moveSpeed;
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.maxDistTele = maxDistTele;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.dragon.func_70909_n() || this.dragon.func_70906_o() || this.dragon.func_70631_g_()) {
            return false;
        }
        if (this.dragon.field_70153_n != null) {
            return false;
        }
        EntityLiving currentOwner = this.dragon.func_70902_q();
        if (currentOwner == null) {
            return false;
        }
        this.owner = currentOwner;
        double dist = this.dragon.func_70068_e((Entity)this.dragon.func_70902_q());
        return dist > (double)(this.minDist * this.minDist);
    }

    public void func_75249_e() {
        this.avoidWater = this.dragon.func_70661_as().func_75486_a();
        this.dragon.func_70661_as().func_75491_a(false);
    }

    public void func_75251_c() {
        this.nav.func_75499_g();
        this.dragon.resetWaypoint();
        this.dragon.func_70661_as().func_75491_a(this.avoidWater);
    }

    public void func_75246_d() {
        double dist = this.dragon.func_70068_e((Entity)this.owner);
        if (dist > (double)(this.maxDistTele * this.maxDistTele)) {
            this.teleportToOwner();
        } else {
            this.dragon.func_70671_ap().func_75651_a((Entity)this.owner, this.dragon.getYawSpeed(), (float)this.dragon.func_70646_bf());
            if (!this.nav.func_75497_a(this.owner, this.moveSpeed)) {
                // empty if block
            }
        }
    }

    private void teleportToOwner() {
        World world = this.owner.field_70170_p;
        int tx = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
        int tz = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
        int ty = MathHelper.func_76128_c((double)this.owner.field_70121_D.field_72338_b);
        for (int x = 0; x <= 4; ++x) {
            for (int z = 0; z <= 4; ++z) {
                if (x >= 1 && z >= 1 && x <= 3 && z <= 3 || !world.func_72809_s(tx + x, ty - 1, tz + z) || world.func_72809_s(tx + x, ty, tz + z) || world.func_72809_s(tx + x, ty + 1, tz + z)) continue;
                this.dragon.func_70012_b((float)(tx + x) + 0.5f, ty, (float)(tz + z) + 0.5f, this.dragon.field_70177_z, this.dragon.field_70125_A);
                this.dragon.func_70661_as().func_75499_g();
                return;
            }
        }
    }
}

