/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.ai;

import info.ata4.minecraft.dragon.DragonsModForge;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.util.math.MathX;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityAIRoamAir
extends EntityAIBase {
    private static final Logger L = DragonsModForge.L;
    private final EntityTameableDragon dragon;
    private final float speed;
    private final double minRange;
    private final double maxRange;
    private final int horizRange;
    private final int vertRange;
    private final float landChance;
    private double minAltitude = 16.0;
    private int collidedTicks;

    public EntityAIRoamAir(EntityTameableDragon dragon, float speed, double minRange, double maxRange, int horizRange, int vertRange, float landChance) {
        this.dragon = dragon;
        this.speed = speed;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.horizRange = horizRange;
        this.vertRange = vertRange;
        this.landChance = landChance;
        this.func_75248_a(1);
    }

    public boolean func_75252_g() {
        return false;
    }

    public boolean func_75253_b() {
        return false;
    }

    public boolean func_75250_a() {
        if (this.dragon.func_70909_n()) {
            return false;
        }
        if (this.dragon.field_70132_H) {
            ++this.collidedTicks;
            this.collidedTicks %= 40;
        } else {
            this.collidedTicks = 0;
        }
        return this.isNearWaypoint() || this.collidedTicks == 20;
    }

    public void func_75249_e() {
        World world = this.dragon.field_70170_p;
        double maxBlockY = world.func_72800_K();
        Vec3 wp = null;
        for (int i = 0; i < 8; ++i) {
            boolean landing;
            wp = RandomPositionGenerator.func_75463_a((EntityCreature)this.dragon, (int)this.horizRange, (int)this.vertRange);
            int blockX = (int)(wp.field_72450_a - 0.5);
            int blockZ = (int)(wp.field_72449_c - 0.5);
            double terrainHeight = world.func_72976_f(blockX, blockZ);
            float landChance2 = this.landChance * (1.0f / this.dragon.getLifeStage().getSize());
            boolean bl = landing = this.dragon.func_70681_au().nextFloat() < landChance2;
            if (landing) {
                Material material;
                int blockY = (int)(terrainHeight - 0.5);
                int blockBeneath = world.func_72798_a(blockX, blockY - 1, blockZ);
                Material material2 = material = blockBeneath != 0 ? Block.field_71973_m[blockBeneath].field_72018_cp : Material.field_76249_a;
                if (material.func_76224_d()) {
                    wp = null;
                    continue;
                }
                wp.field_72448_b = terrainHeight - this.minRange;
            } else {
                wp.field_72448_b = MathX.clamp(wp.field_72448_b, terrainHeight + this.minAltitude, maxBlockY);
            }
            double dist = this.dragon.getDistanceTo(wp);
            if (!(dist < this.minRange) && !(dist > this.maxRange)) continue;
            wp = null;
        }
        if (wp == null) {
            L.log(Level.FINE, "No valid waypoint found for dragon {0}!", this.dragon.field_70157_k);
        } else {
            L.log(Level.FINE, "Set new waypoint for dragon {0} to {1}", new Object[]{this.dragon.field_70157_k, wp});
            this.dragon.setMoveSpeedAir(this.speed);
            this.dragon.setWaypoint(wp);
        }
    }

    private boolean isNearWaypoint() {
        double dist = this.dragon.getDistanceToWaypoint();
        return dist < this.minRange || dist > this.maxRange;
    }
}

