/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.net;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import info.ata4.minecraft.dragon.DragonsModForge;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.net.IPacketHandlerSubscriber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class DragonRenamePacketHandler
implements IPacketHandlerSubscriber {
    public static final String CHANNEL = "DragonRename";
    private static final Logger L = DragonsModForge.L;
    private static final Pattern FILTER = Pattern.compile("[^a-zA-Z0-9-_ ]$");
    private static final DragonRenamePacketHandler INSTANCE = new DragonRenamePacketHandler();

    public static DragonRenamePacketHandler getInstance() {
        return INSTANCE;
    }

    public static String filterName(String name) {
        return FILTER.matcher(name).replaceAll("");
    }

    private DragonRenamePacketHandler() {
    }

    @Override
    public String getChannel() {
        return CHANNEL;
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        String newName;
        int entityId;
        if (!packet.field_73630_a.equals(CHANNEL)) {
            throw new IllegalArgumentException("Wrong channel");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(packet.field_73629_c);
        DataInputStream dis = new DataInputStream(bis);
        try {
            entityId = dis.readInt();
            newName = DragonRenamePacketHandler.filterName(dis.readUTF());
            dis.close();
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Can't read packet", ex);
            return;
        }
        this.renameDragonServer((EntityPlayerMP)player, entityId, newName);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityTameableDragon getRenameableDragon(EntityPlayerSP player, int entityId) {
        Entity dragonEnt = player.field_70170_p.func_73045_a(entityId);
        if (dragonEnt == null) {
            L.log(Level.WARNING, "Server requested to rename an invalid entity with the ID {0}", entityId);
            return null;
        }
        if (!(dragonEnt instanceof EntityTameableDragon)) {
            L.log(Level.WARNING, "Server requested to rename a non-dragon entity {0}:\"{1}\"", new Object[]{dragonEnt.field_70157_k, dragonEnt.func_70023_ak()});
            return null;
        }
        EntityTameableDragon dragon = (EntityTameableDragon)dragonEnt;
        if (!dragon.func_70905_p().equals(player.field_71092_bJ)) {
            L.log(Level.WARNING, "Server requested to rename {0}'s dragon", dragon.func_70905_p());
            return null;
        }
        L.log(Level.FINE, "Found renameable dragon for player {0}", player.field_71092_bJ);
        return dragon;
    }

    @SideOnly(value=Side.CLIENT)
    public void renameDragonClient(EntityPlayerSP player, int entityId, String newName) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(entityId);
            dos.writeUTF(newName);
            dos.close();
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Can't write packet", ex);
            return;
        }
        byte[] data = bos.toByteArray();
        Packet250CustomPayload packet = new Packet250CustomPayload(CHANNEL, data);
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }

    public boolean renameDragonServer(EntityPlayerMP player, int entityId, String newName) {
        Entity dragonEnt = player.field_70170_p.func_73045_a(entityId);
        if (newName.isEmpty()) {
            L.log(Level.WARNING, "Player {0} attempted to rename a dragon with an empty name", player.field_71092_bJ);
            return false;
        }
        if (dragonEnt == null) {
            L.log(Level.WARNING, "Player {0} attempted to rename an invalid entity with the ID {1}", new Object[]{player.field_71092_bJ, entityId});
            return false;
        }
        if (!(dragonEnt instanceof EntityTameableDragon)) {
            L.log(Level.WARNING, "Player {0} attempted to rename the non-dragon entity {1}:\"{2}\"", new Object[]{player.field_71092_bJ, dragonEnt.field_70157_k, dragonEnt.func_70023_ak()});
            return false;
        }
        EntityTameableDragon dragon = (EntityTameableDragon)dragonEnt;
        if (!dragon.func_70905_p().equals(player.field_71092_bJ)) {
            L.log(Level.WARNING, "Player {0} attempted to rename {1}'s dragon", new Object[]{player.field_71092_bJ, dragon.func_70905_p()});
            return false;
        }
        String oldName = dragon.func_70023_ak();
        dragon.func_94058_c(newName);
        L.log(Level.FINE, "Player {0} renamed dragon {1} from \"{2}\" to \"{3}\"", new Object[]{player.field_71092_bJ, entityId, oldName, newName});
        return true;
    }
}

