/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.net;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import info.ata4.minecraft.dragon.DragonsModForge;
import info.ata4.minecraft.dragon.server.net.IPacketHandlerSubscriber;
import info.ata4.minecraft.dragon.server.net.MovementInputProxy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.MovementInput;

public class MovementInputPacketHandler
implements IPacketHandlerSubscriber {
    public static final String CHANNEL = "PlayerMoveInput";
    private static final Logger L = DragonsModForge.L;
    private static final MovementInputPacketHandler INSTANCE = new MovementInputPacketHandler();
    private Map moveMap = new HashMap();

    public static MovementInputPacketHandler getInstance() {
        return INSTANCE;
    }

    private MovementInputPacketHandler() {
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        MovementInputProxy input;
        if (!packet.field_73630_a.equals(CHANNEL)) {
            throw new IllegalArgumentException("Wrong channel");
        }
        EntityPlayer playerEnt = (EntityPlayer)player;
        if (!this.moveMap.containsKey(playerEnt)) {
            input = new MovementInputProxy();
            this.moveMap.put(playerEnt, input);
        } else {
            input = (MovementInputProxy)this.moveMap.get(playerEnt);
        }
        this.unpack(packet.field_73629_c, input);
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerMovementChanged(EntityPlayerSP player) {
        byte[] data = this.pack(player.field_71158_b);
        Packet250CustomPayload packet = new Packet250CustomPayload(CHANNEL, data);
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }

    public void clearMapping() {
        this.moveMap.clear();
    }

    @Override
    public String getChannel() {
        return CHANNEL;
    }

    public MovementInputProxy getMovementInputForPlayer(EntityPlayer player) {
        return (MovementInputProxy)this.moveMap.get(player);
    }

    @SideOnly(value=Side.CLIENT)
    public byte[] pack(MovementInput input) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeFloat(input.field_78900_b);
            dos.writeFloat(input.field_78902_a);
            dos.writeBoolean(input.field_78901_c);
            dos.writeBoolean(input.field_78899_d);
            dos.close();
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Can't write packet", ex);
        }
        return bos.toByteArray();
    }

    public MovementInputProxy unpack(byte[] data, MovementInputProxy input) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bis);
        try {
            input.moveForward = dis.readFloat();
            input.moveStrafe = dis.readFloat();
            input.jump = dis.readBoolean();
            input.sneak = dis.readBoolean();
            float f = input.moveForward < -1.0f ? -1.0f : (input.moveForward = input.moveForward > 1.0f ? 1.0f : input.moveForward);
            input.moveStrafe = input.moveStrafe < -1.0f ? -1.0f : (input.moveStrafe > 1.0f ? 1.0f : input.moveStrafe);
            dis.close();
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Can't read packet", ex);
        }
        return input;
    }
}

