/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.model.anim;

import info.ata4.minecraft.dragon.util.math.Interpolation;
import java.util.Arrays;

public class CircularBuffer {
    private float[] buffer;
    private int index = 0;

    public CircularBuffer(int size) {
        this.buffer = new float[size];
    }

    public void fill(float value) {
        Arrays.fill(this.buffer, value);
    }

    public void update(float value) {
        ++this.index;
        this.index %= this.buffer.length;
        this.buffer[this.index] = value;
    }

    public float get(float x, int offset) {
        int i = this.index - offset;
        int len = this.buffer.length - 1;
        return Interpolation.linear(this.buffer[i - 1 & len], this.buffer[i & len], x);
    }

    public float get(float x, int offset1, int offset2) {
        return this.get(x, offset2) - this.get(x, offset1);
    }
}

