/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.breeds;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DragonBreedForest
extends DragonBreed {
    private static final int GRASS_LIGHT_THRESHOLD = 4;

    DragonBreedForest() {
        super("forest", 2977280);
        this.addHabitatBlock(Blocks.field_150364_r);
        this.addHabitatBlock(Blocks.field_150363_s);
        this.addHabitatBlock((Block)Blocks.field_150362_t);
        this.addHabitatBlock((Block)Blocks.field_150361_u);
        this.addHabitatBlock((Block)Blocks.field_150327_N);
        this.addHabitatBlock((Block)Blocks.field_150328_O);
        this.addHabitatBlock(Blocks.field_150341_Y);
        this.addHabitatBlock(Blocks.field_150395_bd);
        this.addHabitatBlock(Blocks.field_150345_g);
        this.addHabitatBiome(Biomes.field_76767_f);
        this.addHabitatBiome(Biomes.field_76785_t);
        this.addHabitatBiome(Biomes.field_76782_w);
        this.addHabitatBiome(Biomes.field_76792_x);
    }

    @Override
    protected void placeFootprintBlock(EntityTameableDragon dragon, BlockPos blockPos) {
        World world = dragon.field_70170_p;
        BlockPos blockPosGround = blockPos.func_177977_b();
        BlockPos blockPosSurface = blockPos;
        IBlockState blockStateUnderFoot = world.func_180495_p(blockPosGround);
        Block blockUnderFoot = blockStateUnderFoot.func_177230_c();
        boolean plantFlower = false;
        boolean plantMushroom = false;
        if (blockUnderFoot == Blocks.field_150349_c) {
            plantFlower = true;
        } else if (blockUnderFoot == Blocks.field_150346_d) {
            BlockDirt.DirtType dirtType = (BlockDirt.DirtType)blockStateUnderFoot.func_177229_b((IProperty)BlockDirt.field_176386_a);
            if (dirtType != BlockDirt.DirtType.DIRT) {
                plantMushroom = true;
            } else if (world.func_175671_l(blockPosSurface) >= 4) {
                world.func_175656_a(blockPosGround, Blocks.field_150349_c.func_176223_P());
                plantFlower = world.field_73012_v.nextBoolean();
            }
        } else if (blockUnderFoot == Blocks.field_150391_bh) {
            plantMushroom = true;
        }
        BlockBush blockPlant = null;
        IBlockState statePlant = null;
        if (plantFlower) {
            BlockFlower.EnumFlowerType flower = world.func_180494_b(blockPosSurface).func_180623_a(world.field_73012_v, blockPosSurface);
            BlockFlower blockFlower = flower.func_176964_a().func_180346_a();
            blockPlant = blockFlower;
            statePlant = blockFlower.func_176223_P().func_177226_a(blockFlower.func_176494_l(), (Comparable)flower);
        }
        if (plantMushroom) {
            blockPlant = world.field_73012_v.nextBoolean() ? Blocks.field_150337_Q : Blocks.field_150338_P;
            statePlant = blockPlant.func_176223_P();
        }
        if (blockPlant != null && blockPlant.func_180671_f(world, blockPosSurface, statePlant)) {
            world.func_175656_a(blockPosSurface, statePlant);
        }
    }

    @Override
    protected float getFootprintChance() {
        return 0.05f;
    }

    @Override
    public void onEnable(EntityTameableDragon dragon) {
    }

    @Override
    public void onDisable(EntityTameableDragon dragon) {
    }

    @Override
    public void onDeath(EntityTameableDragon dragon) {
    }
}

