/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.breeds;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;

public class DragonBreedGhost
extends DragonBreed {
    private final Map<EntityTameableDragon, EntityAIRestrictSun> appliedTasks = new HashMap<EntityTameableDragon, EntityAIRestrictSun>();

    DragonBreedGhost() {
        super("undead", 0xBEBEBE);
        this.addImmunity(DamageSource.field_82727_n);
        this.addHabitatBlock(Blocks.field_150321_G);
    }

    @Override
    public void onEnable(EntityTameableDragon dragon) {
        EntityAIRestrictSun restrictSun = new EntityAIRestrictSun((EntityCreature)dragon);
        dragon.field_70714_bg.func_75776_a(2, (EntityAIBase)restrictSun);
        this.appliedTasks.put(dragon, restrictSun);
    }

    @Override
    public void onDisable(EntityTameableDragon dragon) {
        if (this.appliedTasks.containsKey((Object)dragon)) {
            dragon.field_70714_bg.func_85156_a((EntityAIBase)this.appliedTasks.get((Object)dragon));
            this.appliedTasks.remove((Object)dragon);
        }
    }

    @Override
    public boolean isHabitatEnvironment(EntityTameableDragon dragon) {
        if (dragon.field_70163_u > (double)dragon.field_70170_p.func_72800_K() * 0.25) {
            return false;
        }
        BlockPos pos = dragon.func_180425_c();
        if (dragon.field_70170_p.func_175710_j(pos)) {
            return false;
        }
        return dragon.field_70170_p.func_175699_k(pos) <= 4;
    }

    @Override
    public SoundEvent getLivingSound() {
        return SoundEvents.field_187854_fc;
    }

    @Override
    public float getSoundPitch(SoundEvent sound) {
        if (sound.equals(this.getLivingSound())) {
            return 0.5f;
        }
        return super.getSoundPitch(sound);
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public void onDeath(EntityTameableDragon dragon) {
    }
}

