/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.util;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;

public class EntityClassPredicate
implements Predicate<Entity> {
    private final Set<Class> classSet;

    public EntityClassPredicate(Class<? extends Entity> ... c) {
        this.classSet = Collections.unmodifiableSet(new HashSet<Class<? extends Entity>>(Arrays.asList(c)));
    }

    public boolean apply(Entity input) {
        Class<?> c = input.getClass();
        do {
            if (!this.classSet.contains(c)) continue;
            return true;
        } while ((c = c.getSuperclass()) != null);
        return false;
    }
}

