/*
 * Decompiled with CFR 0.152.
 */
package net.solocraft.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.solocraft.SololevelingMod;
import net.solocraft.procedures.SkillCycle10Procedure;
import net.solocraft.procedures.SkillCycle1Procedure;
import net.solocraft.procedures.SkillCycle2Procedure;
import net.solocraft.procedures.SkillCycle3Procedure;
import net.solocraft.procedures.SkillCycle4Procedure;
import net.solocraft.procedures.SkillCycle5Procedure;
import net.solocraft.procedures.SkillCycle6Procedure;
import net.solocraft.procedures.SkillCycle7Procedure;
import net.solocraft.procedures.SkillCycle8Procedure;
import net.solocraft.procedures.SkillCycle9Procedure;
import net.solocraft.world.inventory.CycleCircleMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CycleCircleButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public CycleCircleButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public CycleCircleButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(CycleCircleButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(CycleCircleButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            CycleCircleButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = CycleCircleMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SkillCycle1Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SkillCycle2Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SkillCycle6Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SkillCycle9Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SkillCycle3Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SkillCycle4Procedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            SkillCycle5Procedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            SkillCycle7Procedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            SkillCycle8Procedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            SkillCycle10Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SololevelingMod.addNetworkMessage(CycleCircleButtonMessage.class, CycleCircleButtonMessage::buffer, CycleCircleButtonMessage::new, CycleCircleButtonMessage::handler);
    }
}

