/*
 * Decompiled with CFR 0.152.
 */
package dikiy.weever.stone_legacy.mixin;

import com.github.standobyte.jojo.action.ActionTarget;
import com.github.standobyte.jojo.action.non_stand.NonStandAction;
import com.github.standobyte.jojo.action.non_stand.VampirismAction;
import com.github.standobyte.jojo.action.non_stand.VampirismZombieSummon;
import com.github.standobyte.jojo.entity.mob.HungryZombieEntity;
import com.github.standobyte.jojo.init.ModCustomStats;
import com.github.standobyte.jojo.init.power.non_stand.ModPowers;
import com.github.standobyte.jojo.power.impl.nonstand.INonStandPower;
import com.github.standobyte.jojo.power.impl.nonstand.type.NonStandPowerType;
import com.github.standobyte.jojo.power.impl.nonstand.type.zombie.ZombiePowerType;
import com.github.standobyte.jojo.util.mc.MCUtil;
import dikiy.weever.stone_legacy.capability.ZombieUtilProvider;
import dikiy.weever.stone_legacy.mixin_helper.INonStandPowerMixinHelper;
import dikiy.weever.stone_legacy.network.AddonPackets;
import dikiy.weever.stone_legacy.network.server.TrResetDeathTimePacket;
import dikiy.weever.stone_legacy.network.server.TrSyncGivePowerDataPacket;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={VampirismZombieSummon.class})
public class VampireActionMixin
extends VampirismAction {
    public VampireActionMixin(NonStandAction.Builder builder) {
        super(builder);
    }

    @Overwrite
    protected void perform(World world, LivingEntity user, INonStandPower power, ActionTarget targets) {
        if (!world.func_201670_d()) {
            List entitiesAround = MCUtil.entitiesAround(LivingEntity.class, (Entity)user, (double)16.0, (boolean)false, null);
            int canSpawn = world.func_175659_aa().func_151525_a();
            AtomicInteger spawned = new AtomicInteger();
            entitiesAround.forEach(entity -> {
                if (spawned.get() < canSpawn && entity.field_70725_aQ >= 1) {
                    INonStandPower.getNonStandPowerOptional((LivingEntity)entity).ifPresent(nonPower -> {
                        if (nonPower.getType() == ModPowers.HAMON.get() && nonPower.getEnergy() < 5.0f) {
                            this.stoneLegacyAddon$giveZombie((INonStandPower)nonPower, user.func_110124_au());
                            spawned.getAndIncrement();
                        } else {
                            this.stoneLegacyAddon$giveZombie((INonStandPower)nonPower, user.func_110124_au());
                            spawned.getAndIncrement();
                        }
                    });
                }
            });
            if (spawned.get() < canSpawn) {
                for (int i = spawned.get(); i < canSpawn; ++i) {
                    HungryZombieEntity zombie = new HungryZombieEntity(world);
                    zombie.setSummonedFromAbility();
                    zombie.func_82149_j((Entity)user);
                    zombie.setOwner(user);
                    world.func_217376_c((Entity)zombie);
                }
                if (user instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)user).func_195067_a(ModCustomStats.VAMPIRE_ZOMBIES_SUMMONED, canSpawn - spawned.get());
                }
            }
        }
    }

    @Unique
    private void stoneLegacyAddon$giveZombie(INonStandPower nonPower, UUID ownerUUID) {
        LivingEntity user = nonPower.getUser();
        user.getCapability(ZombieUtilProvider.CAPABILITY).ifPresent(cap -> cap.setOwnerUUID(ownerUUID));
        float previousEnergy = nonPower.getEnergy();
        float previousMaxEnergy = nonPower.getMaxEnergy();
        if (nonPower instanceof INonStandPowerMixinHelper) {
            ((INonStandPowerMixinHelper)nonPower).stoneLegacyAddon$givePower((NonStandPowerType)ModPowers.ZOMBIE.get(), true);
            if (!user.field_70170_p.field_72995_K) {
                AddonPackets.sendToClientsTrackingAndSelf(new TrSyncGivePowerDataPacket(user.func_145782_y(), ((ZombiePowerType)ModPowers.ZOMBIE.get()).getRegistryName(), true), (Entity)user);
            }
            nonPower.setEnergy((float)(Math.pow(1.6 * (double)previousEnergy, 1.8) / Math.pow(previousMaxEnergy, 2.0)));
            this.stoneLegacyAddon$onEntityResurrect(user);
            user.func_70606_j(2.0f);
        }
    }

    @Unique
    private void stoneLegacyAddon$onEntityResurrect(LivingEntity entity) {
        if (entity.field_70725_aQ >= 1) {
            entity.field_70725_aQ = 0;
            AddonPackets.sendToClientsTrackingAndSelf(new TrResetDeathTimePacket(entity.func_145782_y()), (Entity)entity);
        }
    }
}

