/*
 * Decompiled with CFR 0.152.
 */
package dikiy.weever.stone_legacy.util;

import com.github.standobyte.jojo.block.PillarmanBossMultiBlock;
import com.github.standobyte.jojo.init.ModBlocks;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StoneLegacyUtil {
    public static boolean checkStoneFormationBehind(LivingEntity livingEntity) {
        if (livingEntity == null) {
            return false;
        }
        return StoneLegacyUtil.getStoneBlocksCounter(livingEntity) >= 6;
    }

    private static int getStoneBlocksCounter(LivingEntity livingEntity) {
        World world = livingEntity.field_70170_p;
        Direction playerFacing = livingEntity.func_174811_aO();
        Direction behind = playerFacing.func_176734_d();
        Direction leftOfPlayer = playerFacing.func_176735_f();
        BlockPos bottomLeftPos = livingEntity.func_233580_cy_().func_177972_a(behind).func_177972_a(leftOfPlayer);
        int stoneBlocksCounter = 0;
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 2; ++i) {
                BlockPos posToCheck = bottomLeftPos.func_177981_b(j).func_177967_a(playerFacing.func_176746_e(), i);
                if (world.func_180495_p(posToCheck).func_185904_a() != Material.field_151576_e) continue;
                ++stoneBlocksCounter;
            }
        }
        return stoneBlocksCounter;
    }

    public static void replaceStoneWithSlumberingPillarman(LivingEntity living) {
        if (!StoneLegacyUtil.checkStoneFormationBehind(living)) {
            return;
        }
        World world = living.field_70170_p;
        Direction playerFacing = living.func_174811_aO();
        Direction statueFacing = playerFacing.func_176734_d();
        Direction behind = playerFacing.func_176734_d();
        Direction leftOfPlayer = playerFacing.func_176735_f();
        BlockPos bottomLeftPos = living.func_233580_cy_().func_177972_a(behind).func_177972_a(leftOfPlayer);
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 2; ++i) {
                BlockPos posToReplace = bottomLeftPos.func_177981_b(j).func_177967_a(playerFacing.func_176746_e(), i);
                int yIndexInStructure = 2 - j;
                int horizontalPartId = 1 - i;
                int partId = yIndexInStructure * 2 + horizontalPartId;
                BlockState pillarmanState = (BlockState)((BlockState)((PillarmanBossMultiBlock)ModBlocks.SLUMBERING_PILLARMAN.get()).func_176223_P().func_206870_a((Property)PillarmanBossMultiBlock.FACING, (Comparable)statueFacing)).func_206870_a((Property)PillarmanBossMultiBlock.PART, (Comparable)Integer.valueOf(partId));
                if (world.func_180495_p(posToReplace).func_185904_a() != Material.field_151576_e) continue;
                world.func_180501_a(posToReplace, pillarmanState, 3);
                world.func_72863_F().func_212863_j_().func_215568_a(posToReplace);
            }
        }
    }
}

