/*
 * Decompiled with CFR 0.152.
 */
package dikiy.weever.stone_legacy.mixin;

import com.github.standobyte.jojo.init.ModStatusEffects;
import dikiy.weever.stone_legacy.init.InitItems;
import dikiy.weever.stone_legacy.items.FruitItem;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class FruitEatingMixin
extends Entity {
    public FruitEatingMixin(EntityType<?> p_i48580_1_, World p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    @Shadow
    public abstract boolean isUsingItem();

    @Shadow
    public abstract void spawnItemParticles(ItemStack var1, int var2);

    @Shadow
    public abstract boolean addEffect(EffectInstance var1);

    @Shadow
    @Nullable
    public abstract EffectInstance getEffect(Effect var1);

    @Inject(method={"triggerItemUseEffects(Lnet/minecraft/item/ItemStack;I)V"}, at={@At(value="HEAD", target="Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/LivingEntity.isUsingItem()Z")}, cancellable=true)
    public void getHurtSoundAndAnimation(ItemStack stack, int randomValue, CallbackInfo ci) {
        if (stack.func_77973_b() == InitItems.FRUIT.get() && this.isUsingItem() && FruitItem.getStage(stack) == 630) {
            this.spawnItemParticles(stack, 1);
            if (!(this.getEffect(Effects.field_76429_m) != null || this.getEntity() instanceof PlayerEntity && ((PlayerEntity)this.getEntity()).func_184812_l_())) {
                this.func_184185_a(SoundEvents.field_187800_eb, 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                int amplifier = this.getEffect((Effect)ModStatusEffects.BLEEDING.get()) != null ? this.getEffect((Effect)ModStatusEffects.BLEEDING.get()).func_76458_c() + 1 : 0;
                this.addEffect(new EffectInstance((Effect)ModStatusEffects.BLEEDING.get(), 45, amplifier, false, false, true));
                ci.cancel();
            }
        }
    }

    @Inject(method={"spawnItemParticles(Lnet/minecraft/item/ItemStack;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void spawnTeethParticles(ItemStack stack, int particles, CallbackInfo ci) {
        if (stack.func_77973_b() instanceof FruitItem && FruitItem.getStage(stack) == 630) {
            for (int i = 0; i < particles; ++i) {
                Vector3d vector3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vector3d = vector3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                vector3d = vector3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                double d0 = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
                Vector3d vector3d1 = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3, d0, 0.6);
                vector3d1 = vector3d1.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                vector3d1 = vector3d1.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                vector3d1 = vector3d1.func_72441_c(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
                if (this.field_70170_p instanceof ServerWorld) {
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Items.field_221574_b)), vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, 1, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c, 0.0);
                    continue;
                }
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Items.field_221574_b)), vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
            }
            ci.cancel();
        }
    }
}

