/*
 * Decompiled with CFR 0.152.
 */
package dikiy.weever.stone_legacy.network.server;

import com.github.standobyte.jojo.client.ClientUtil;
import com.github.standobyte.jojo.network.packets.IModPacketHandler;
import dikiy.weever.stone_legacy.capability.PillarmanUtilProvider;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class TrPillarmanDataPacket {
    private final int entityId;
    private final boolean hamonUserState;

    public TrPillarmanDataPacket(int entityId, boolean hamonUserState) {
        this.entityId = entityId;
        this.hamonUserState = hamonUserState;
    }

    public static class Handler
    implements IModPacketHandler<TrPillarmanDataPacket> {
        public void encode(TrPillarmanDataPacket msg, PacketBuffer buf) {
            buf.writeInt(msg.entityId);
            buf.writeBoolean(msg.hamonUserState);
        }

        public TrPillarmanDataPacket decode(PacketBuffer buf) {
            int entityId = buf.readInt();
            return new TrPillarmanDataPacket(entityId, buf.readBoolean());
        }

        public void handle(TrPillarmanDataPacket msg, Supplier<NetworkEvent.Context> ctx) {
            Entity entity = ClientUtil.getEntityById((int)msg.entityId);
            if (entity != null) {
                entity.getCapability(PillarmanUtilProvider.CAPABILITY).ifPresent(cap -> cap.setHamonUser(msg.hamonUserState));
            }
        }

        public Class<TrPillarmanDataPacket> getPacketClass() {
            return TrPillarmanDataPacket.class;
        }
    }
}

