/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.neoforge;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import me.shedaniel.lightoverlay.common.neoforge.CubicChunkPos;
import me.shedaniel.lightoverlay.common.neoforge.LightOverlay;
import me.shedaniel.lightoverlay.common.neoforge.neoforge.LightOverlayTickerImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import sun.misc.Unsafe;

public class LightOverlayTicker {
    private long ticks = 0L;
    private static int threadNumber = 0;
    private static final ThreadPoolExecutor EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
        Thread thread = new Thread(r, "light-overlay-" + threadNumber++);
        thread.setDaemon(true);
        return thread;
    });
    public final Set<CubicChunkPos> POS = Collections.synchronizedSet(new HashSet());
    public final Set<CubicChunkPos> CALCULATING_POS = Collections.synchronizedSet(new HashSet());
    public final Map<CubicChunkPos, Long2ByteMap> CHUNK_MAP = Maps.newConcurrentMap();
    private static final Supplier<EntityType<Entity>> TESTING_ENTITY_TYPE = Suppliers.memoize(() -> {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Unsafe unsafe = (Unsafe)f.get(null);
            return (EntityType)unsafe.allocateInstance(EntityType.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    });

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void populateEntityType(EntityType<Entity> type) {
        LightOverlayTickerImpl.populateEntityType(type);
    }

    public void queueChunk(CubicChunkPos pos) {
        if (LightOverlay.enabled && LightOverlay.caching && !this.CALCULATING_POS.contains(pos)) {
            this.POS.add(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(Minecraft minecraft) {
        block23: {
            while (LightOverlay.enableOverlay.consumeClick()) {
                LightOverlay.enabled = !LightOverlay.enabled;
            }
            try {
                ++this.ticks;
                if (minecraft.player == null || !LightOverlay.enabled) {
                    this.POS.clear();
                    this.CALCULATING_POS.clear();
                    EXECUTOR.getQueue().clear();
                    this.CHUNK_MAP.clear();
                    break block23;
                }
                LocalPlayer player = minecraft.player;
                ClientLevel world = minecraft.level;
                CollisionContext collisionContext = CollisionContext.of((Entity)player);
                if (!LightOverlay.caching) {
                    this.CALCULATING_POS.clear();
                    this.POS.clear();
                    this.CHUNK_MAP.clear();
                    BlockPos playerPos = player.blockPosition();
                    assert (world != null);
                    LayerLightEventListener block = world.getLightEngine().getLayerListener(LightLayer.BLOCK);
                    LayerLightEventListener sky = LightOverlay.showNumber ? null : world.getLightEngine().getLayerListener(LightLayer.SKY);
                    BlockPos.MutableBlockPos downPos = new BlockPos.MutableBlockPos();
                    Iterable iterate = BlockPos.betweenClosed((int)(playerPos.getX() - LightOverlay.reach), (int)(playerPos.getY() - LightOverlay.reach), (int)(playerPos.getZ() - LightOverlay.reach), (int)(playerPos.getX() + LightOverlay.reach), (int)(playerPos.getY() + LightOverlay.reach), (int)(playerPos.getZ() + LightOverlay.reach));
                    Long2ByteOpenHashMap chunkData = new Long2ByteOpenHashMap();
                    this.CHUNK_MAP.put(new CubicChunkPos(0, 0, 0), (Long2ByteMap)chunkData);
                    for (BlockPos blockPos : iterate) {
                        downPos.set(blockPos.getX(), blockPos.getY() - 1, blockPos.getZ());
                        if (LightOverlay.showNumber) {
                            int level = LightOverlayTicker.getCrossLevel(blockPos, (BlockPos)downPos, (BlockGetter)world, block, collisionContext);
                            if (level < 0) continue;
                            chunkData.put(blockPos.asLong(), (byte)level);
                            continue;
                        }
                        Holder biome = !LightOverlay.mushroom ? world.getBiome(blockPos) : null;
                        byte type = this.getCrossType(blockPos, (Holder<Biome>)biome, (BlockPos)downPos, (BlockGetter)world, block, sky, collisionContext);
                        if (type == 3) continue;
                        chunkData.put(blockPos.asLong(), type);
                    }
                    break block23;
                }
                assert (Minecraft.getInstance().level != null);
                int height = Mth.ceil((double)((double)Minecraft.getInstance().level.getHeight() / 32.0));
                int start = Math.floorDiv(Minecraft.getInstance().level.getMinY(), 32);
                int playerPosX = (int)player.getX() >> 4;
                int playerPosY = (int)player.getY() >> 5;
                int playerPosZ = (int)player.getZ() >> 4;
                int chunkRange = LightOverlay.getChunkRange();
                for (int chunkX = playerPosX - chunkRange; chunkX <= playerPosX + chunkRange; ++chunkX) {
                    for (int chunkY = Math.max(playerPosY - Math.max(1, chunkRange >> 1), start); chunkY <= playerPosY + Math.max(1, chunkRange >> 1) && chunkY <= start + height; ++chunkY) {
                        for (int chunkZ = playerPosZ - chunkRange; chunkZ <= playerPosZ + chunkRange; ++chunkZ) {
                            CubicChunkPos chunkPos;
                            if (Mth.abs((int)(chunkX - playerPosX)) > chunkRange || Mth.abs((int)(chunkY - playerPosY)) > chunkRange || Mth.abs((int)(chunkZ - playerPosZ)) > chunkRange || this.CHUNK_MAP.containsKey(chunkPos = new CubicChunkPos(chunkX, chunkY, chunkZ))) continue;
                            this.queueChunk(chunkPos);
                        }
                    }
                }
                for (int p = 0; p < 3 && EXECUTOR.getQueue().size() < Runtime.getRuntime().availableProcessors(); ++p) {
                    double d1 = Double.MAX_VALUE;
                    double d2 = Double.MAX_VALUE;
                    double d3 = Double.MAX_VALUE;
                    CubicChunkPos c1 = null;
                    CubicChunkPos c2 = null;
                    CubicChunkPos c3 = null;
                    Set<CubicChunkPos> set = this.POS;
                    synchronized (set) {
                        Iterator<CubicChunkPos> iterator = this.POS.iterator();
                        while (iterator.hasNext()) {
                            int dz;
                            int dy;
                            CubicChunkPos pos = iterator.next();
                            if (Mth.abs((int)(pos.x - playerPosX)) > chunkRange || Mth.abs((int)(pos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || Mth.abs((int)(pos.z - playerPosZ)) > chunkRange || this.CALCULATING_POS.contains(pos)) {
                                iterator.remove();
                                continue;
                            }
                            if (!LightOverlay.renderer.isFrustumVisible(pos.getMinBlockX(), pos.getMinBlockY(), pos.getMinBlockZ(), pos.getMaxBlockX(), pos.getMaxBlockY(), pos.getMaxBlockZ())) continue;
                            int dx = Math.abs(pos.x - playerPosX);
                            double distance = Math.sqrt(dx * dx + (dy = Math.abs(pos.y - playerPosY) << 1) * dy + (dz = Math.abs(pos.z - playerPosZ)) * dz);
                            if (distance < d1) {
                                d3 = d2;
                                d2 = d1;
                                d1 = distance;
                                c3 = c2;
                                c2 = c1;
                                c1 = pos;
                                continue;
                            }
                            if (distance < d2) {
                                d3 = d2;
                                d2 = distance;
                                c3 = c2;
                                c2 = pos;
                                continue;
                            }
                            if (!(distance < d3)) continue;
                            d3 = distance;
                            c3 = pos;
                        }
                    }
                    CubicChunkPos finalC1 = c1;
                    CubicChunkPos finalC2 = c2;
                    CubicChunkPos finalC3 = c3;
                    if (finalC1 == null) continue;
                    this.CALCULATING_POS.add(finalC1);
                    this.POS.remove(finalC1);
                    if (finalC2 != null) {
                        this.CALCULATING_POS.add(finalC2);
                        this.POS.remove(finalC2);
                        if (finalC3 != null) {
                            this.CALCULATING_POS.add(finalC3);
                            this.POS.remove(finalC3);
                        }
                    }
                    EXECUTOR.submit(() -> {
                        int playerPosX1 = (int)minecraft.player.getX() >> 4;
                        int playerPosY1 = (int)minecraft.player.getY() >> 5;
                        int playerPosZ1 = (int)minecraft.player.getZ() >> 4;
                        this.processChunk(finalC1, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        if (finalC2 != null) {
                            this.processChunk(finalC2, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                        if (finalC3 != null) {
                            this.processChunk(finalC3, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                    });
                }
                if (this.ticks % 50L == 0L) {
                    this.CHUNK_MAP.entrySet().removeIf(entry -> Mth.abs((int)(((CubicChunkPos)entry.getKey()).x - playerPosX)) > chunkRange * 2 || Mth.abs((int)(((CubicChunkPos)entry.getKey()).y - playerPosY)) > chunkRange * 2 || Mth.abs((int)(((CubicChunkPos)entry.getKey()).z - playerPosZ)) > chunkRange * 2);
                }
            }
            catch (Throwable throwable) {
                LogManager.getLogger().throwing(throwable);
            }
        }
    }

    private void processChunk(CubicChunkPos pos, int playerPosX, int playerPosY, int playerPosZ, CollisionContext context) {
        Minecraft minecraft = Minecraft.getInstance();
        this.CALCULATING_POS.remove(pos);
        int chunkRange = LightOverlay.getChunkRange();
        if (Mth.abs((int)(pos.x - playerPosX)) > chunkRange || Mth.abs((int)(pos.y - playerPosY)) > Math.max(1, chunkRange >> 1) || Mth.abs((int)(pos.z - playerPosZ)) > chunkRange || this.POS.contains(pos)) {
            return;
        }
        try {
            assert (minecraft.level != null);
            this.calculateChunk(minecraft.level.getChunkSource().getChunk(pos.x, pos.z, ChunkStatus.FULL, false), (Level)minecraft.level, pos, context);
        }
        catch (Throwable throwable) {
            LogManager.getLogger().throwing(throwable);
        }
    }

    private void calculateChunk(LevelChunk chunk, Level world, CubicChunkPos chunkPos, CollisionContext collisionContext) {
        if (world != null && chunk != null) {
            Long2ByteOpenHashMap chunkData = new Long2ByteOpenHashMap();
            LayerLightEventListener block = world.getLightEngine().getLayerListener(LightLayer.BLOCK);
            LayerLightEventListener sky = LightOverlay.showNumber ? null : world.getLightEngine().getLayerListener(LightLayer.SKY);
            for (BlockPos pos : BlockPos.betweenClosed((int)chunkPos.getMinBlockX(), (int)chunkPos.getMinBlockY(), (int)chunkPos.getMinBlockZ(), (int)chunkPos.getMaxBlockX(), (int)chunkPos.getMaxBlockY(), (int)chunkPos.getMaxBlockZ())) {
                BlockPos down = pos.below();
                if (LightOverlay.showNumber) {
                    int level = LightOverlayTicker.getCrossLevel(pos, down, (BlockGetter)chunk, block, collisionContext);
                    if (level < 0) continue;
                    chunkData.put(pos.asLong(), (byte)level);
                    continue;
                }
                Holder biome = !LightOverlay.mushroom ? world.getBiome(pos) : null;
                byte type = this.getCrossType(pos, (Holder<Biome>)biome, down, (BlockGetter)chunk, block, sky, collisionContext);
                if (type == 3) continue;
                chunkData.put(pos.asLong(), type);
            }
            this.CHUNK_MAP.put(chunkPos, (Long2ByteMap)chunkData);
        } else {
            this.CHUNK_MAP.remove(chunkPos);
        }
    }

    public byte getCrossType(BlockPos pos, Holder<Biome> biome, BlockPos down, BlockGetter world, LayerLightEventListener block, LayerLightEventListener sky, CollisionContext entityContext) {
        BlockState blockBelowState = world.getBlockState(down);
        BlockState blockUpperState = world.getBlockState(pos);
        VoxelShape upperCollisionShape = blockUpperState.getCollisionShape(world, pos, entityContext);
        if (!LightOverlay.underwater && !blockUpperState.getFluidState().isEmpty()) {
            return 3;
        }
        if (Block.isFaceFull((VoxelShape)upperCollisionShape, (Direction)Direction.UP)) {
            return 3;
        }
        if (blockUpperState.isSignalSource()) {
            return 3;
        }
        if (upperCollisionShape.max(Direction.Axis.Y) > 0.0) {
            return 3;
        }
        if (blockUpperState.is(BlockTags.RAILS)) {
            return 3;
        }
        if (!blockBelowState.isValidSpawn(world, down, TESTING_ENTITY_TYPE.get())) {
            return 3;
        }
        if (!LightOverlay.mushroom && LightOverlayTicker.isMushroom(biome)) {
            return 3;
        }
        int blockLightLevel = block.getLightValue(pos);
        int skyLightLevel = sky.getLightValue(pos);
        if (blockLightLevel > LightOverlay.higherCrossLevel) {
            return 3;
        }
        if (skyLightLevel > LightOverlay.higherCrossLevel) {
            return LightOverlay.higherCross;
        }
        return LightOverlay.lowerCrossLevel >= 0 && blockLightLevel > LightOverlay.lowerCrossLevel ? LightOverlay.lowerCross : (byte)1;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean isMushroom(Holder<Biome> biome) {
        return LightOverlayTickerImpl.isMushroom(biome);
    }

    public static int getCrossLevel(BlockPos pos, BlockPos down, BlockGetter world, LayerLightEventListener view, CollisionContext collisionContext) {
        BlockState blockBelowState = world.getBlockState(down);
        BlockState blockUpperState = world.getBlockState(pos);
        VoxelShape collisionShape = blockBelowState.getCollisionShape(world, down, collisionContext);
        VoxelShape upperCollisionShape = blockUpperState.getCollisionShape(world, pos, collisionContext);
        if (!LightOverlay.underwater && !blockUpperState.getFluidState().isEmpty()) {
            return -1;
        }
        if (!blockBelowState.getFluidState().isEmpty()) {
            return -1;
        }
        if (blockBelowState.isAir()) {
            return -1;
        }
        if (Block.isFaceFull((VoxelShape)upperCollisionShape, (Direction)Direction.DOWN)) {
            return -1;
        }
        return view.getLightValue(pos);
    }
}

