/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.linearxp.Handler;

import celia.adwadg.linearxp.Utils.ExpUtils;
import celia.adwadg.linearxp.Utils.ExperienceCalculator;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="linearxp")
public class ExpDisplayHandler {
    private static final long CHECK_INTERVAL = 10L;
    private static long tickCounter = 0L;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.level().isClientSide()) {
            return;
        }
        if (++tickCounter % 10L != 0L) {
            return;
        }
        long accuratedExp = ExpUtils.getAccuratedExpValue(player);
        int actualExp = ExpUtils.getActualExp(player);
        int currentLevel = player.experienceLevel;
        ExpDisplayHandler.checkLevelUp(player, accuratedExp, currentLevel);
        ExpDisplayHandler.updateExperienceBar(player, accuratedExp, currentLevel);
    }

    public static void updatePlayerExpBar(Player player) {
        long accuratedExp = ExpUtils.getAccuratedExpValue(player);
        int actualExp = ExpUtils.getActualExp(player);
        int currentLevel = player.experienceLevel;
        ExpDisplayHandler.checkLevelUp(player, accuratedExp, currentLevel);
        ExpDisplayHandler.updateExperienceBar(player, accuratedExp, currentLevel);
    }

    private static void checkLevelUp(Player player, long accuratedExp, int currentLevel) {
        long requiredExpAccurated = ExperienceCalculator.calculateAccuratedExperience(currentLevel);
        while (accuratedExp >= requiredExpAccurated) {
            long finalAccuratedExp = accuratedExp -= requiredExpAccurated;
            ExpUtils.getAccuratedExp(player).ifPresent(data -> data.setAccuratedExp(finalAccuratedExp));
            requiredExpAccurated = ExperienceCalculator.calculateAccuratedExperience(player.experienceLevel);
        }
    }

    private static void updateExperienceBar(Player player, long accuratedExp, int currentLevel) {
        float progress;
        if (currentLevel < 0) {
            return;
        }
        player.experienceProgress = progress = ExperienceCalculator.getExpProgress(accuratedExp, currentLevel);
    }
}

