/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.linearxp.Utils;

import celia.adwadg.linearxp.ExperienceManager;
import celia.adwadg.linearxp.ExperienceType;
import celia.adwadg.linearxp.LinearXp;

public class ExperienceCalculator {
    public static int calculateExperience(int level) {
        if (level < 0) {
            return 0;
        }
        int currentTotal = ExperienceCalculator.getTotalExperienceForLevel(level);
        int nextTotal = ExperienceCalculator.getTotalExperienceForLevel(level + 1);
        return nextTotal - currentTotal;
    }

    private static int getTotalExperienceForLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    public static double calculateFormula(String formula, int base, int level) {
        String expression = formula.replace("base", String.valueOf(base)).replace("level", String.valueOf(level));
        return ExperienceCalculator.evaluateExpression(expression);
    }

    private static double evaluateExpression(String expr) {
        char c;
        int i;
        int bracketStart = (expr = expr.replaceAll("\\s+", "")).lastIndexOf(40);
        if (bracketStart != -1) {
            int bracketEnd = expr.indexOf(41, bracketStart);
            if (bracketEnd == -1) {
                throw new RuntimeException("\u62ec\u53f7\u4e0d\u5339\u914d");
            }
            double innerResult = ExperienceCalculator.evaluateExpression(expr.substring(bracketStart + 1, bracketEnd));
            String newExpr = expr.substring(0, bracketStart) + innerResult + expr.substring(bracketEnd + 1);
            return ExperienceCalculator.evaluateExpression(newExpr);
        }
        for (i = expr.length() - 1; i >= 0; --i) {
            c = expr.charAt(i);
            if (c != '*' && c != '/') continue;
            double left = ExperienceCalculator.evaluateExpression(expr.substring(0, i));
            double right = ExperienceCalculator.evaluateExpression(expr.substring(i + 1));
            return c == '*' ? left * right : left / right;
        }
        for (i = expr.length() - 1; i >= 0; --i) {
            c = expr.charAt(i);
            if (c != '+' && c != '-' || i <= 0 || "+-*/".indexOf(expr.charAt(i - 1)) != -1) continue;
            double left = ExperienceCalculator.evaluateExpression(expr.substring(0, i));
            double right = ExperienceCalculator.evaluateExpression(expr.substring(i + 1));
            return c == '+' ? left + right : left - right;
        }
        try {
            return Double.parseDouble(expr);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u8868\u8fbe\u5f0f: " + expr);
        }
    }

    public static double MultiplyXpDouble(int original, int level) {
        double handled;
        LinearXp.LOGGER.debug("\u8ba1\u7b97\u53c2\u6570 - \u539f\u59cb\u7ecf\u9a8c: {}, \u7b49\u7ea7: {}, \u6a21\u5f0f: {}", new Object[]{original, level, ExperienceManager.XPMODE});
        handled = switch (ExperienceManager.XPMODE) {
            default -> throw new IncompatibleClassChangeError();
            case ExperienceType.STATIC -> {
                int levelNeed = ExperienceCalculator.calculateExperience(level);
                LinearXp.LOGGER.debug("STATIC\u6a21\u5f0f - \u7b49\u7ea7\u9700\u6c42: {}, \u9759\u6001\u7ecf\u9a8c: {}", (Object)levelNeed, (Object)ExperienceManager.STATICXP);
                if (levelNeed == 0) {
                    yield original;
                }
                double ratio = (double)levelNeed / (double)ExperienceManager.STATICXP.intValue();
                handled = (double)original * ratio;
                LinearXp.LOGGER.debug("STATIC\u8ba1\u7b97\u7ed3\u679c - \u6bd4\u7387: {}, \u7ed3\u679c: {}", (Object)ratio, (Object)handled);
                yield handled;
            }
            case ExperienceType.LINEAR -> {
                int levelNeed = ExperienceCalculator.calculateExperience(level);
                double linearNeed = ExperienceManager.LINEARBASE + ExperienceManager.LINEARADDITION * level;
                LinearXp.LOGGER.debug("LINEAR\u6a21\u5f0f - \u539f\u7248\u9700\u6c42: {}, \u7ebf\u6027\u9700\u6c42: {} (\u57fa\u7840: {}, \u52a0\u6210: {})", new Object[]{levelNeed, linearNeed, ExperienceManager.LINEARBASE, ExperienceManager.LINEARADDITION});
                if (linearNeed == 0.0) {
                    yield original;
                }
                double ratio = (double)levelNeed / linearNeed;
                handled = (double)original * ratio;
                LinearXp.LOGGER.debug("LINEAR\u8ba1\u7b97\u7ed3\u679c - \u6bd4\u7387: {}, \u7ed3\u679c: {}", (Object)ratio, (Object)handled);
                yield handled;
            }
            case ExperienceType.FORMULA -> {
                int levelNeed = ExperienceCalculator.calculateExperience(level);
                double formulaneed = ExperienceCalculator.calculateFormula(ExperienceManager.FORMULA, ExperienceManager.FORMULABASE, level);
                LinearXp.LOGGER.debug("FORMULA\u6a21\u5f0f - \u539f\u7248\u9700\u6c42: {}, \u516c\u5f0f\u9700\u6c42: {} (\u57fa\u7840: {}, \u516c\u5f0f\u7ed3\u679c: {})", new Object[]{levelNeed, formulaneed, ExperienceManager.FORMULABASE, ExperienceCalculator.calculateFormula(ExperienceManager.FORMULA, ExperienceManager.FORMULABASE, level)});
                if (formulaneed == 0.0) {
                    yield original;
                }
                double ratio = (double)levelNeed / formulaneed;
                handled = (double)original * ratio;
                LinearXp.LOGGER.debug("FORMULA\u8ba1\u7b97\u7ed3\u679c - \u6bd4\u7387: {}, \u7ed3\u679c: {}", (Object)ratio, (Object)handled);
                yield handled;
            }
        };
        return handled;
    }

    public static long MultiplyXpToAccurated(int original, int level) {
        double result = ExperienceCalculator.MultiplyXpDouble(original, level);
        return (long)(result * 1000.0);
    }

    public static int MultiplyXp(int original, int level) {
        double result = ExperienceCalculator.MultiplyXpDouble(original, level);
        return (int)Math.floor(result);
    }

    public static long calculateAccuratedExperience(int level) {
        int original = ExperienceCalculator.calculateExperience(level);
        return (long)original * 1000L;
    }

    public static boolean canLevelUp(long playerAccuratedExp, int currentLevel) {
        long requiredExp = ExperienceCalculator.calculateAccuratedExperience(currentLevel);
        return playerAccuratedExp >= requiredExp;
    }

    public static long getRemainingExpAfterLevelUp(long playerAccuratedExp, int currentLevel) {
        long requiredExp = ExperienceCalculator.calculateAccuratedExperience(currentLevel);
        return playerAccuratedExp - requiredExp;
    }

    public static float getExpProgress(long playerAccuratedExp, int currentLevel) {
        long requiredExp = ExperienceCalculator.calculateAccuratedExperience(currentLevel);
        if (requiredExp <= 0L) {
            return 1.0f;
        }
        return Math.min(1.0f, (float)playerAccuratedExp / (float)requiredExp);
    }
}

