/*
 * Decompiled with CFR 0.152.
 */
package fuzs.partycreepers.handler;

import fuzs.partycreepers.PartyCreepers;
import fuzs.partycreepers.config.ServerConfig;
import fuzs.partycreepers.init.ModRegistry;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class CreeperConfettiHandler {
    private static final BlockParticleOption INVISIBLE_EXPLOSION_PARTICLES = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50016_.m_49966_());

    public static void onExplosionDetonate(Level level, Explosion explosion, List<BlockPos> affectedBlocks, List<Entity> affectedEntities) {
        Entity entity = explosion.m_253049_();
        if (entity != null && entity.m_6095_().m_204039_(ModRegistry.EXPLOSIVE_CREEPERS_ENTITY_TYPE_TAG)) {
            if (!((ServerConfig)PartyCreepers.CONFIG.get(ServerConfig.class)).damageTerrain) {
                explosion.m_46080_();
            }
            affectedEntities.removeIf(Predicate.not(((ServerConfig)PartyCreepers.CONFIG.get(ServerConfig.class)).damageEntities::filter));
            if (level.m_213780_().m_188500_() < ((ServerConfig)PartyCreepers.CONFIG.get(ServerConfig.class)).confettiChance) {
                Creeper creeper;
                explosion.f_303246_ = explosion.f_302779_ = INVISIBLE_EXPLOSION_PARTICLES;
                ItemStack itemStack = new ItemStack((ItemLike)Items.f_42688_);
                CompoundTag compoundTag = itemStack.m_41698_("Fireworks");
                boolean largeExplosion = entity instanceof Creeper && (creeper = (Creeper)entity).m_7090_();
                CreeperConfettiHandler.addFireworkTag(compoundTag, level.m_213780_(), largeExplosion);
                FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity(level, entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), itemStack);
                level.m_7967_((Entity)fireworkRocketEntity);
                fireworkRocketEntity.m_37080_();
            }
        }
    }

    private static void addFireworkTag(CompoundTag itemTag, RandomSource randomSource, boolean largeExplosion) {
        ListTag listTag = new ListTag();
        itemTag.m_128365_("Explosions", (Tag)listTag);
        int[] colors = new int[randomSource.m_188503_(5) + 4];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = CreeperConfettiHandler.nextColor(randomSource);
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128385_("Colors", colors);
        compoundTag.m_128379_("Flicker", true);
        FireworkRocketItem.Shape shape = largeExplosion ? FireworkRocketItem.Shape.LARGE_BALL : FireworkRocketItem.Shape.SMALL_BALL;
        compoundTag.m_128344_("Type", (byte)shape.m_41236_());
        listTag.add((Object)compoundTag);
        compoundTag = new CompoundTag();
        compoundTag.m_128385_("Colors", colors);
        compoundTag.m_128379_("Trail", true);
        compoundTag.m_128344_("Type", (byte)FireworkRocketItem.Shape.BURST.m_41236_());
        listTag.add((Object)compoundTag);
    }

    private static int nextColor(RandomSource randomSource) {
        return FastColor.ARGB32.m_13660_((int)0, (int)CreeperConfettiHandler.nextColorComponent(randomSource), (int)CreeperConfettiHandler.nextColorComponent(randomSource), (int)CreeperConfettiHandler.nextColorComponent(randomSource));
    }

    private static int nextColorComponent(RandomSource randomSource) {
        return (int)(Mth.m_14008_((double)(randomSource.m_188583_() / 6.0 + 0.5), (double)0.0, (double)1.0) * 255.0);
    }
}

