/*
 * Decompiled with CFR 0.152.
 */
package fuzs.partycreepers.handler;

import fuzs.partycreepers.PartyCreepers;
import fuzs.partycreepers.config.ServerConfig;
import fuzs.partycreepers.init.ModRegistry;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class CreeperConfettiHandler {
    private static final BlockParticleOption INVISIBLE_EXPLOSION_PARTICLES = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.AIR.defaultBlockState());

    public static void onExplosionDetonate(Level level, Explosion explosion, List<BlockPos> affectedBlocks, List<Entity> affectedEntities) {
        Entity entity = explosion.getDirectSourceEntity();
        if (entity != null && entity.getType().is(ModRegistry.EXPLOSIVE_CREEPERS_ENTITY_TYPE_TAG)) {
            if (!((ServerConfig)PartyCreepers.CONFIG.get(ServerConfig.class)).damageTerrain) {
                explosion.clearToBlow();
            }
            affectedEntities.removeIf(Predicate.not(((ServerConfig)PartyCreepers.CONFIG.get(ServerConfig.class)).damageEntities::filter));
            if (level.getRandom().nextDouble() < ((ServerConfig)PartyCreepers.CONFIG.get(ServerConfig.class)).confettiChance) {
                Creeper creeper;
                explosion.smallExplosionParticles = explosion.largeExplosionParticles = INVISIBLE_EXPLOSION_PARTICLES;
                ItemStack itemStack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
                CompoundTag compoundTag = itemStack.getOrCreateTagElement("Fireworks");
                boolean largeExplosion = entity instanceof Creeper && (creeper = (Creeper)entity).isPowered();
                CreeperConfettiHandler.addFireworkTag(compoundTag, level.getRandom(), largeExplosion);
                FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity(level, entity.getX(), entity.getEyeY(), entity.getZ(), itemStack);
                level.addFreshEntity((Entity)fireworkRocketEntity);
                fireworkRocketEntity.explode();
            }
        }
    }

    private static void addFireworkTag(CompoundTag itemTag, RandomSource randomSource, boolean largeExplosion) {
        ListTag listTag = new ListTag();
        itemTag.put("Explosions", (Tag)listTag);
        int[] colors = new int[randomSource.nextInt(5) + 4];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = CreeperConfettiHandler.nextColor(randomSource);
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putIntArray("Colors", colors);
        compoundTag.putBoolean("Flicker", true);
        FireworkRocketItem.Shape shape = largeExplosion ? FireworkRocketItem.Shape.LARGE_BALL : FireworkRocketItem.Shape.SMALL_BALL;
        compoundTag.putByte("Type", (byte)shape.getId());
        listTag.add((Object)compoundTag);
        compoundTag = new CompoundTag();
        compoundTag.putIntArray("Colors", colors);
        compoundTag.putBoolean("Trail", true);
        compoundTag.putByte("Type", (byte)FireworkRocketItem.Shape.BURST.getId());
        listTag.add((Object)compoundTag);
    }

    private static int nextColor(RandomSource randomSource) {
        return FastColor.ARGB32.color((int)0, (int)CreeperConfettiHandler.nextColorComponent(randomSource), (int)CreeperConfettiHandler.nextColorComponent(randomSource), (int)CreeperConfettiHandler.nextColorComponent(randomSource));
    }

    private static int nextColorComponent(RandomSource randomSource) {
        return (int)(Mth.clamp((double)(randomSource.nextGaussian() / 6.0 + 0.5), (double)0.0, (double)1.0) * 255.0);
    }
}

