/*
 * Decompiled with CFR 0.152.
 */
package fuzs.partycreepers.config;

import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ServerConfig
implements ConfigCore {
    @Config(description={"Damage surrounding blocks when a creeper explodes."})
    public boolean damageTerrain = false;
    @Config(description={"Kind of entities to damage when a creeper explodes. Living does exclude e.g. items laying on the ground."})
    public EntityDamage damageEntities = EntityDamage.LIVING_ONLY;
    @Config(description={"Chance a creeper will burst into fireworks, otherwise vanilla explosion particles show.", "Other changes to explosion behavior still apply such as no damage to terrain."})
    @Config.DoubleRange(min=0.0, max=1.0)
    public double confettiChance = 1.0;

    public static enum EntityDamage {
        NONE,
        LIVING_ONLY,
        PLAYERS_ONLY,
        ALL;


        public boolean filter(Entity entity) {
            return switch (this.ordinal()) {
                case 0 -> false;
                case 1 -> entity instanceof LivingEntity;
                case 2 -> entity instanceof Player;
                default -> true;
            };
        }
    }
}

