/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.worldplaytime.common.mixin;

import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Dynamic;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import me.khajiitos.worldplaytime.common.util.IWithPlayTime;
import net.minecraft.class_32;
import net.minecraft.class_34;
import net.minecraft.class_5218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_32.class})
public class LevelStorageSourceMixin {
    @Inject(at={@At(value="RETURN")}, method={"makeLevelSummary"})
    public void onMakeLevelSummary(Dynamic<?> dynamic, class_32.class_7411 levelDirectory, boolean idk, CallbackInfoReturnable<class_34> cir) {
        class_34 levelSummary = (class_34)cir.getReturnValue();
        if (levelSummary instanceof IWithPlayTime) {
            File[] saveFiles;
            IWithPlayTime withPlayTime = (IWithPlayTime)levelSummary;
            Path stats = levelDirectory.method_43423(class_5218.field_24181);
            File statsFile = stats.toFile();
            if (statsFile.isDirectory() && (saveFiles = statsFile.listFiles()) != null) {
                int totalPlayTime = 0;
                for (File file : saveFiles) {
                    try (FileReader fileReader = new FileReader(file);){
                        JsonObject customObject;
                        JsonObject statsObject;
                        JsonObject jsonObject = JsonParser.parseReader((Reader)fileReader).getAsJsonObject();
                        if (!jsonObject.has("stats") || !(statsObject = jsonObject.getAsJsonObject("stats")).has("minecraft:custom") || !(customObject = statsObject.getAsJsonObject("minecraft:custom")).has("minecraft:play_time")) continue;
                        int playTime = customObject.get("minecraft:play_time").getAsInt();
                        totalPlayTime += playTime;
                    }
                    catch (JsonIOException | IOException | IllegalStateException throwable) {
                        // empty catch block
                    }
                }
                if (totalPlayTime > 0) {
                    withPlayTime.setPlayTimeTicks(totalPlayTime);
                }
            }
        }
    }
}

