/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.worldplaytime.common.mixin;

import me.khajiitos.worldplaytime.common.config.WPTConfig;
import me.khajiitos.worldplaytime.common.util.Color;
import me.khajiitos.worldplaytime.common.util.IWithPlayTime;
import me.khajiitos.worldplaytime.common.util.PlayTimeRenderer;
import me.khajiitos.worldplaytime.common.util.WorldEntryRenderPos;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.world.level.storage.LevelSummary;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldSelectionList.WorldListEntry.class})
public class WorldListEntryMixin {
    @Shadow
    @Final
    LevelSummary summary;

    @Inject(at={@At(value="TAIL")}, method={"renderContent"})
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean pHovering, float pPartialTick, CallbackInfo ci) {
        if (!((Boolean)WPTConfig.showWorldPlayTime.get()).booleanValue()) {
            return;
        }
        LevelSummary levelSummary = this.summary;
        if (levelSummary instanceof IWithPlayTime) {
            IWithPlayTime withPlayTime = (IWithPlayTime)levelSummary;
            WorldSelectionList.WorldListEntry entry = (WorldSelectionList.WorldListEntry)this;
            int ticks = withPlayTime.getPlayTimeTicks();
            int indicatorWidth = PlayTimeRenderer.getWholeWidth(ticks);
            if (indicatorWidth != 0) {
                int renderY;
                int renderX;
                switch ((WorldEntryRenderPos)((Object)WPTConfig.worldPlayTimePosition.get())) {
                    case TOP_RIGHT: {
                        renderX = entry.getContentX() + entry.getContentWidth() - indicatorWidth - 1;
                        renderY = entry.getContentY();
                        break;
                    }
                    case LEFT: {
                        renderX = entry.getContentX() - indicatorWidth - 5;
                        renderY = entry.getContentY() + 10;
                        break;
                    }
                    case RIGHT: {
                        renderX = entry.getContentX() + entry.getContentWidth() + 14;
                        renderY = entry.getContentY() + 10;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                PlayTimeRenderer.render(guiGraphics, renderX, renderY, ticks, (Color)WPTConfig.worldPlayTimeColor.get());
            }
        }
    }
}

