/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.entities;

import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.AnimationName;
import com.trongthang.welcometomyworld.classes.StartAnimation;
import com.trongthang.welcometomyworld.managers.SoundsManager;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1405;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5532;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class FallenKnight
extends class_1321
implements StartAnimation {
    ConcurrentHashMap<AnimationName, class_7094> animationHashMap = new ConcurrentHashMap();
    private static final class_2940<Boolean> IS_USING_SKILL = class_2945.method_12791(FallenKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_RANDOM_FIRST_TIME = class_2945.method_12791(FallenKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CAN_BE_TAMED_SET = class_2945.method_12791(FallenKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CAN_BE_TAMED = class_2945.method_12791(FallenKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_PATROLLING = class_2945.method_12791(FallenKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> ALL_SKILL_COOLDOWN = class_2945.method_12791(FallenKnight.class, (class_2941)class_2943.field_13320);
    private static final int WALK_CYCLE_DURATION_MS = 4000;
    private static final int[] FOOTSTEP_TIMINGS_MS = new int[]{1080, 3210};
    private int previousWalkPosition = -1;
    private static final int ATTACK_2_DURATION_MS = 1460;
    private static final int[] ATTACK_2_SOUND_TIMINGS_MS = new int[]{670};
    private final Set<Integer> attack2PlayedFrames = new HashSet<Integer>();
    private static final int ATTACK_3_DURATION_MS = 2500;
    private static final int[] ATTACK_3_SOUND_TIMINGS_MS = new int[]{400, 1220};
    private final Set<Integer> attack3PlayedFrames = new HashSet<Integer>();
    private static final int TELEPORT_DURATION_MS = 8000;
    private static final int[] TELEPORT_SOUND_TIMINGS_MS = new int[]{0, 4300, 4900};
    private final Set<Integer> teleportPlayedFrames = new HashSet<Integer>();
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 walkAnimationState = new class_7094();
    public final class_7094 attackAnimationState = new class_7094();
    public final class_7094 attack2AnimationState = new class_7094();
    public final class_7094 attack3AnimationState = new class_7094();
    public final class_7094 teleportAnimationState = new class_7094();
    public final class_7094 tameableAnimationState = new class_7094();
    public final class_7094 sitAnimationState = new class_7094();
    private double skillCooldownDecreasedBasedOnMobScale = 1.0;
    private int useSkillCooldownCounter = 0;
    private int attack2Range = 8;
    private int attack3Range = 15;
    private int maxScale = 8;
    private int patrolRadius = 7;
    public class_2338 patrolCenterPos = null;
    public int animationTimeout = 0;
    public static final int DEFAULT_ANIMATION_TIMEOUT = 15;
    private int healthUpdateCooldown = 100;
    private int getHealthUpdateCounter = 0;
    private double healthDecreaseWhenTameablePercent = 0.01f;
    private float healthIncreaseWhenTamed = 0.005f;
    private float percentHealthToBeTamed = 0.15f;
    private int canBeTamedChance = 70;
    private int attack2DamageMultiply = 3;
    private int attack3DamageMultiply = 4;

    public FallenKnight(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.animationHashMap.put(AnimationName.IDLE, this.idleAnimationState);
        this.animationHashMap.put(AnimationName.WALK, this.walkAnimationState);
        this.animationHashMap.put(AnimationName.ATTACK, this.attackAnimationState);
        this.animationHashMap.put(AnimationName.ATTACK2, this.attack2AnimationState);
        this.animationHashMap.put(AnimationName.ATTACK3, this.attack3AnimationState);
        this.animationHashMap.put(AnimationName.TAMEABLE, this.tameableAnimationState);
        this.animationHashMap.put(AnimationName.SIT, this.sitAnimationState);
        this.animationHashMap.put(AnimationName.TELEPORT, this.teleportAnimationState);
        if (!this.method_37908().field_9236 && !this.getIsRandomFirstTime()) {
            double scale;
            this.skillCooldownDecreasedBasedOnMobScale = scale = WelcomeToMyWorld.random.nextDouble(1.0, this.maxScale);
            this.method_5996(class_5134.field_23716).method_6192(this.method_26826(class_5134.field_23716) * scale);
            this.method_5996(class_5134.field_23721).method_6192(this.method_26826(class_5134.field_23721) * (scale / 2.0));
            this.method_5996(class_5134.field_23724).method_6192(this.method_26826(class_5134.field_23724) * (scale / 2.5));
            this.method_5996(class_5134.field_23725).method_6192(this.method_26826(class_5134.field_23725) * (scale / 2.5));
            if (this.skillCooldownDecreasedBasedOnMobScale / 3.0 > 1.0) {
                this.setAllSkillCooldown((float)((double)this.getAllSkillCooldown() / (this.skillCooldownDecreasedBasedOnMobScale / 3.0)));
            }
            if (this.getAllSkillCooldown() <= 80.0f) {
                this.setAllSkillCooldown(80.0f);
            }
            this.method_6033(this.method_6063());
            this.setIsRandomFirstTime(true);
        }
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 500.0).method_26868(class_5134.field_23719, (double)0.1f).method_26868(class_5134.field_23721, 40.0).method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23724, 10.0).method_26868(class_5134.field_23725, 10.0).method_26868(class_5134.field_23718, 1.0);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    protected class_2960 method_5991() {
        return new class_2960("welcometomyworld", "entities/fallen_knight");
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_USING_SKILL, (Object)false);
        this.field_6011.method_12784(IS_RANDOM_FIRST_TIME, (Object)false);
        this.field_6011.method_12784(CAN_BE_TAMED, (Object)false);
        this.field_6011.method_12784(CAN_BE_TAMED_SET, (Object)false);
        this.field_6011.method_12784(IS_PATROLLING, (Object)false);
        this.field_6011.method_12784(ALL_SKILL_COOLDOWN, (Object)Float.valueOf(200.0f));
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new StopMoveAndLookWhenCanBeTamed(this));
        this.field_6201.method_6277(2, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(4, (class_1352)new PatrollingGoal(this));
        this.field_6201.method_6277(5, (class_1352)new CustomFollowOwnerGoal(this, 0.8, 15.0f, 25.0f, false));
        this.field_6201.method_6277(6, (class_1352)new StopWhenUsingSkill(this));
        this.field_6201.method_6277(7, (class_1352)new CustomMeleeAttackGoal(this, 30, 1.5f));
        this.field_6201.method_6277(8, (class_1352)new LargeEntityWanderGoal((class_1314)this, 1.0, 1));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(11, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new CustomTrackOwnerAttackGoal(this));
        this.field_6185.method_6277(3, (class_1352)new CustomAttackWithOwnerGoal(this));
        this.field_6185.method_6277(4, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public void setAnimationStates() {
        if (this.method_37908().field_9236) {
            if (!this.getCanBeTamed()) {
                boolean isMoving;
                if (this.method_6172()) {
                    if (!this.sitAnimationState.method_41327()) {
                        this.startAnimation(AnimationName.SIT);
                    }
                    return;
                }
                class_243 velocity = this.method_18798();
                boolean bl = isMoving = velocity.field_1352 != 0.0 || velocity.field_1350 != 0.0;
                if (this.animationTimeout <= 0 && !this.getIsUsingSkill()) {
                    if (isMoving) {
                        if (!this.walkAnimationState.method_41327()) {
                            this.startAnimation(AnimationName.WALK);
                        }
                    } else if (!this.idleAnimationState.method_41327()) {
                        this.startAnimation(AnimationName.IDLE);
                    }
                }
            } else if (this.getCanBeTamed() && this.method_35057() == null && !this.tameableAnimationState.method_41327()) {
                this.startAnimation(AnimationName.TAMEABLE);
            }
        } else if (!(this.getCanBeTamedSet() || !(this.method_6032() <= this.method_6063() * this.percentHealthToBeTamed) || this.method_35057() != null && this.method_6181() || this.getCanBeTamed())) {
            if (WelcomeToMyWorld.random.nextInt(0, 100) < this.canBeTamedChance) {
                this.setCanBeTamed(true);
            } else {
                this.setCanBeTamed(false);
            }
            this.setCanBeTamedSet(true);
            if (this.getCanBeTamed()) {
                Utils.playSound((class_3218)this.method_37908(), this.method_24515(), SoundsManager.FALLEN_KNIGHT_ARMOR_SHAKING, 0.8f, WelcomeToMyWorld.random.nextFloat(0.8f, 1.1f));
                Utils.addRunAfter(() -> Utils.playSound((class_3218)this.method_37908(), this.method_24515(), SoundsManager.FALLEN_KNIGHT_FALL, 0.5f, WelcomeToMyWorld.random.nextFloat(0.8f, 1.1f)), 12);
            }
        }
        if (this.animationTimeout >= 0) {
            --this.animationTimeout;
        }
    }

    public void method_5773() {
        super.method_5773();
        this.setAnimationStates();
        if (!this.method_37908().field_9236) {
            if (this.method_5968() != null && this.method_5968().method_6032() <= 0.0f) {
                this.method_5980(null);
            }
            if (this.getHealthUpdateCounter <= this.healthUpdateCooldown) {
                ++this.getHealthUpdateCounter;
            }
            if (this.getHealthUpdateCounter > this.healthUpdateCooldown) {
                this.getHealthUpdateCounter = 0;
                if (this.getCanBeTamed()) {
                    this.method_5643(this.method_37908().method_48963().method_48830(), (float)((double)this.method_6063() * this.healthDecreaseWhenTameablePercent));
                } else {
                    this.method_6033(this.method_6032() + this.method_6063() * this.healthIncreaseWhenTamed);
                }
            }
        }
        this.usingSkillsHandler();
        this.handleAnimationSoundsAndEffect();
    }

    private void usingSkillsHandler() {
        if (!(this.method_37908().field_9236 || this.getCanBeTamed() || this.method_6172())) {
            if (this.getIsUsingSkill()) {
                return;
            }
            if ((float)this.useSkillCooldownCounter < this.getAllSkillCooldown() && !this.getIsUsingSkill()) {
                ++this.useSkillCooldownCounter;
                return;
            }
            if (this.method_5968() != null) {
                double distance = this.method_5739((class_1297)this.method_5968());
                int timeout = 0;
                if (distance > 15.0 || this.method_5968().method_23318() > this.method_23318() && Math.abs(this.method_5968().method_23318() - this.method_23318()) > 4.0) {
                    timeout = 160;
                    Utils.sendAnimationPacket(this.method_37908(), (class_1309)this, AnimationName.TELEPORT, timeout);
                    Utils.addRunAfter(() -> {
                        if (this.method_5968() != null) {
                            this.method_20620(this.method_5968().method_23317(), this.method_5968().method_23318() + 1.0, this.method_5968().method_23321());
                        }
                    }, 70);
                    Utils.addRunAfter(() -> this.createShockwave(), 100);
                    this.useSkillCooldownCounter = 0;
                    this.resetSkill(timeout);
                    return;
                }
                if (distance <= (double)this.attack2Range) {
                    int rand = WelcomeToMyWorld.random.nextInt(0, 100);
                    if (rand < 60) {
                        timeout = 30;
                        Utils.sendAnimationPacket(this.method_37908(), (class_1309)this, AnimationName.ATTACK2, timeout);
                        Utils.addRunAfter(this::createDamageBox, 15);
                    } else {
                        timeout = 50;
                        Utils.sendAnimationPacket(this.method_37908(), (class_1309)this, AnimationName.ATTACK3, timeout);
                        Utils.addRunAfter(this::createShockwave, 30);
                    }
                    this.useSkillCooldownCounter = 0;
                    this.resetSkill(timeout);
                    return;
                }
                if (distance > 10.0) {
                    int rand = WelcomeToMyWorld.random.nextInt(0, 100);
                    if (rand < 60) {
                        timeout = 50;
                        Utils.sendAnimationPacket(this.method_37908(), (class_1309)this, AnimationName.ATTACK3, timeout);
                        Utils.addRunAfter(() -> this.createShockwave(), 30);
                    } else {
                        timeout = 160;
                        Utils.sendAnimationPacket(this.method_37908(), (class_1309)this, AnimationName.TELEPORT, timeout);
                        Utils.addRunAfter(() -> {
                            if (this.method_5968() != null) {
                                this.method_20620(this.method_5968().method_23317(), this.method_5968().method_23318() + 1.0, this.method_5968().method_23321());
                            }
                        }, 70);
                        Utils.addRunAfter(() -> this.createShockwave(), 100);
                    }
                    this.useSkillCooldownCounter = 0;
                    this.resetSkill(timeout);
                }
            }
        }
    }

    private void resetSkill(int timeout) {
        this.setIsUsingSkill(true);
        Utils.addRunAfter(() -> this.setIsUsingSkill(false), timeout);
    }

    private void handleAnimationSoundsAndEffect() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        if (this.walkAnimationState.method_41327()) {
            this.handleWalkSounds();
        }
        if (this.attack2AnimationState.method_41327()) {
            this.handleAttack2Sounds();
        }
        if (this.attack3AnimationState.method_41327()) {
            this.handleAttack3Sounds();
        }
        if (this.teleportAnimationState.method_41327()) {
            this.handleTeleportSounds();
        }
    }

    private void handleWalkSounds() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        long animTime = this.walkAnimationState.method_43687();
        int currentPos = (int)(animTime % 4000L);
        for (int timing : FOOTSTEP_TIMINGS_MS) {
            boolean wrapAround;
            int timingInCycle = timing % 4000;
            if (this.previousWalkPosition == -1) continue;
            boolean normalCross = this.previousWalkPosition < timingInCycle && currentPos >= timingInCycle;
            boolean bl = wrapAround = timingInCycle == 0 && this.previousWalkPosition > currentPos;
            if (!normalCross && !wrapAround) continue;
            Utils.playClientSound(this.method_24515(), SoundsManager.FALLEN_KNIGHT_STEP, 20);
        }
        this.previousWalkPosition = currentPos;
    }

    private void handleAttack2Sounds() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        long animTime = this.attack2AnimationState.method_43687();
        int currentPos = (int)(animTime % 1460L);
        for (int timing : ATTACK_2_SOUND_TIMINGS_MS) {
            boolean cycleWrap;
            int windowStart = timing - 25;
            int windowEnd = timing + 25;
            boolean inWindow = currentPos >= windowStart && currentPos <= windowEnd;
            boolean bl = cycleWrap = timing > 1435 && currentPos < timing - 1460 + 25;
            if (!inWindow && !cycleWrap || this.attack2PlayedFrames.contains(timing)) continue;
            this.triggerAttack2SoundSound(timing);
            this.attack2PlayedFrames.add(timing);
        }
        if (currentPos > 1260) {
            this.attack2PlayedFrames.clear();
        }
    }

    private void triggerAttack2SoundSound(int timing) {
        class_3414 soundId = null;
        if (timing >= 670) {
            soundId = SoundsManager.FALLEN_KNIGHT_SWING;
        }
        if (soundId == null) {
            return;
        }
        Utils.sendSoundPacket(soundId, this.method_24515());
    }

    private void handleAttack3Sounds() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        long animTime = this.attack3AnimationState.method_43687();
        int currentPos = (int)(animTime % 2500L);
        for (int timing : ATTACK_3_SOUND_TIMINGS_MS) {
            boolean cycleWrap;
            int windowStart = timing - 25;
            int windowEnd = timing + 25;
            boolean inWindow = currentPos >= windowStart && currentPos <= windowEnd;
            boolean bl = cycleWrap = timing > 2475 && currentPos < timing - 2500 + 25;
            if (!inWindow && !cycleWrap || this.attack3PlayedFrames.contains(timing)) continue;
            this.triggerAttack3SoundSound(timing);
            this.attack3PlayedFrames.add(timing);
        }
        if (currentPos > 2350) {
            this.attack3PlayedFrames.clear();
        }
    }

    private void triggerAttack3SoundSound(int timing) {
        class_3414 soundId = null;
        if (timing >= 400 && timing <= 500) {
            soundId = SoundsManager.FALLEN_KNIGHT_SWING_UP;
        } else if (timing >= 1220 && timing <= 1350) {
            soundId = SoundsManager.FALLEN_KNIGHT_GROUND_IMPACT;
        }
        if (soundId == null) {
            return;
        }
        Utils.playClientSound(this.method_24515(), soundId, 30);
    }

    private void handleTeleportSounds() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        long animTime = this.teleportAnimationState.method_43687();
        int currentPos = (int)animTime;
        for (int timing : TELEPORT_SOUND_TIMINGS_MS) {
            boolean inWindow;
            int windowStart = timing - 50;
            int windowEnd = timing + 50;
            boolean bl = inWindow = currentPos >= windowStart && currentPos <= windowEnd;
            if (!inWindow || this.teleportPlayedFrames.contains(timing)) continue;
            this.triggerTeleportSound(timing);
            this.teleportPlayedFrames.add(timing);
        }
        if (currentPos > 8000) {
            this.teleportPlayedFrames.clear();
        }
    }

    private void triggerTeleportSound(int timing) {
        class_3414 soundId = null;
        if (timing >= 0 && timing <= 150) {
            soundId = SoundsManager.FALLEN_KNIGHT_PORTAL_AMBIENT;
        } else if (timing >= 4250 && timing <= 4400) {
            soundId = SoundsManager.FALLEN_KNIGHT_PORTAL_OPEN;
        } else if (timing >= 4850 && timing <= 5200) {
            soundId = SoundsManager.FALLEN_KNIGHT_GROUND_IMPACT;
        }
        if (soundId == null) {
            return;
        }
        Utils.playClientSound(this.method_24515(), soundId, 30);
    }

    private void createShockwave() {
        if (!this.method_37908().field_9236) {
            class_3218 serverWorld = (class_3218)this.method_37908();
            class_2338 center = this.method_24515();
            class_238 checkArea = new class_238(this.method_24515()).method_1014((double)this.attack3Range);
            List livingEntities = this.method_37908().method_8390(class_1309.class, checkArea, entity -> true);
            HashSet<class_2338> particleSpawnedBlocks = new HashSet<class_2338>();
            for (int x = -this.attack3Range; x <= this.attack3Range; ++x) {
                for (int z = -this.attack3Range; z <= this.attack3Range; ++z) {
                    if (x * x + z * z > this.attack3Range * this.attack3Range) continue;
                    for (int yOffset = 0; yOffset >= -1; --yOffset) {
                        class_2338 targetPos = center.method_10069(x, yOffset, z);
                        class_2680 state = serverWorld.method_8320(targetPos);
                        class_2338 blockAbove = targetPos.method_10084();
                        if (yOffset < 0 && particleSpawnedBlocks.contains(blockAbove) || state.method_26215()) continue;
                        this.spawnParticles(serverWorld, targetPos, state);
                        particleSpawnedBlocks.add(targetPos);
                    }
                }
            }
            for (class_1309 entity2 : livingEntities) {
                class_1321 tameable;
                if (entity2 == this || this.method_35057() != null && entity2 == this.method_35057() || entity2 instanceof class_1321 && (tameable = (class_1321)entity2).method_6181() && tameable.method_35057() != null && tameable.method_35057() == this.method_35057()) continue;
                if (entity2 instanceof class_1308) {
                    class_1308 mobEntity = (class_1308)entity2;
                    if (mobEntity instanceof FallenKnight) continue;
                    if (mobEntity.method_5968() == null) {
                        mobEntity.method_5980((class_1309)this);
                    }
                }
                float damage = (float)this.method_6127().method_26856(class_5134.field_23721) * (float)this.attack3DamageMultiply;
                this.damageBlockingShield(entity2, damage);
                entity2.method_5762(0.0, (double)1.4f, 0.0);
                entity2.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), damage);
            }
        }
    }

    private void createDamageBox() {
        if (!this.method_37908().field_9236) {
            class_238 checkArea = new class_238(this.method_24515()).method_1014((double)this.attack2Range);
            List livingEntities = this.method_37908().method_8390(class_1309.class, checkArea, entity -> true);
            for (class_1309 entity2 : livingEntities) {
                class_1321 tameable;
                if (entity2 == this || this.method_35057() != null && entity2 == this.method_35057() || entity2 instanceof class_1321 && (tameable = (class_1321)entity2).method_6181() && tameable.method_35057() != null && tameable.method_35057() == this.method_35057()) continue;
                if (entity2 instanceof class_1308) {
                    class_1308 mobEntity = (class_1308)entity2;
                    if (mobEntity instanceof FallenKnight) continue;
                    if (mobEntity.method_5968() == null) {
                        mobEntity.method_5980((class_1309)this);
                    }
                }
                class_243 knockbackDirection = new class_243(entity2.method_23317() - this.method_23317(), entity2.method_23318() - this.method_23318(), entity2.method_23321() - this.method_23321()).method_1029();
                entity2.method_45319(knockbackDirection.method_18805(2.0, 0.0, 2.0));
                float damage = (float)this.method_6127().method_26856(class_5134.field_23721) * (float)this.attack2DamageMultiply;
                this.damageBlockingShield(entity2, damage);
                entity2.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), damage);
            }
        }
    }

    private void damageBlockingShield(class_1309 target, float damage) {
        if (this.method_5968() == null) {
            return;
        }
        if (target.method_6039() && target.method_6030().method_7963()) {
            float reducedDamage = damage * 0.8f;
            target.method_6030().method_7956((int)reducedDamage, target, entity -> entity.method_20236(target.method_6058()));
        }
    }

    private void spawnParticles(class_3218 world, class_2338 pos, class_2680 state) {
        class_2388 particle = new class_2388(class_2398.field_11217, state);
        world.method_14199((class_2394)particle, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 10, 0.2, 0.5, 0.2, 0.1);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            if (this.getCanBeTamed() && itemStack.method_31574(this.getTameFood()) && (this.method_35057() == null || !this.method_6181())) {
                return class_1269.field_21466;
            }
            return class_1269.field_5811;
        }
        if (this.method_6181() && this.method_35057() == player) {
            this.method_24346(!this.method_24345());
            this.setIsPatrolling(false);
            this.field_6185.method_6280((class_1352)new class_1400((class_1308)this, class_1588.class, true));
            return class_1269.field_5812;
        }
        if (this.getCanBeTamed() && itemStack.method_31574(this.getTameFood())) {
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            if (this.field_5974.method_43048(2) == 0) {
                this.method_6170(player);
                this.method_6173(true);
                this.method_24346(false);
                this.animationTimeout = 1;
                this.method_5980(null);
                this.setCanBeTamed(false);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private class_1792 getTameFood() {
        return class_1802.field_23842;
    }

    public void method_6125(float speed) {
        super.method_6125(speed);
    }

    @Override
    public void startAnimation(AnimationName name) {
        AnimationName na = null;
        for (AnimationName n : this.animationHashMap.keySet()) {
            if (n.equals((Object)name)) {
                na = n;
                continue;
            }
            this.animationHashMap.get((Object)n).method_41325();
        }
        if (na != null) {
            this.animationHashMap.get((Object)na).method_41322(this.field_6012);
            this.animationTimeout = 15;
        }
    }

    @Override
    public void startAnimation(AnimationName name, int timeout) {
        AnimationName na = null;
        for (AnimationName n : this.animationHashMap.keySet()) {
            if (n.equals((Object)name)) {
                na = n;
                continue;
            }
            this.animationHashMap.get((Object)n).method_41325();
        }
        if (na != null) {
            this.animationHashMap.get((Object)na).method_41322(this.field_6012);
            this.animationTimeout = timeout;
            if (na == AnimationName.TELEPORT) {
                this.teleportPlayedFrames.clear();
            }
        }
    }

    public void stopAllAnimation() {
        Object na = null;
        for (AnimationName n : this.animationHashMap.keySet()) {
            this.animationHashMap.get((Object)n).method_41325();
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.method_37908().field_9236) {
            class_1657 player;
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972) == this.method_35057() && player.method_5715()) {
                this.patrolCenterPos = this.method_24515();
                this.setIsPatrolling(!this.getIsPatrolling());
                if (this.getIsPatrolling()) {
                    this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1588.class, true));
                } else {
                    this.patrolCenterPos = null;
                    this.field_6185.method_6280((class_1352)new class_1400((class_1308)this, class_1588.class, true));
                }
                return false;
            }
            if (!this.getCanBeTamed() && source.method_5529() != this.method_35057()) {
                if (source.method_5526() instanceof class_1667) {
                    return false;
                }
                class_12972 = source.method_5529();
                if (class_12972 instanceof class_1657 && ((player = (class_1657)class_12972).method_7337() || player.method_7325())) {
                    return super.method_5643(source, amount);
                }
                this.method_5980(source.method_5529() instanceof class_1309 ? (class_1309)source.method_5529() : null);
            }
        }
        return super.method_5643(source, amount);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14959;
    }

    public void method_6114(class_1297 target) {
        super.method_6114(target);
        if (!this.method_37908().field_9236) {
            class_243 knockbackDirection = new class_243(target.method_23317() - this.method_23317(), target.method_23318() - this.method_23318(), target.method_23321() - this.method_23321()).method_1029();
            target.method_45319(knockbackDirection.method_18805(2.0, 0.0, 2.0));
            for (class_3222 player : ((class_3218)this.method_37908()).method_18456()) {
                if (!player.method_6057((class_1297)this)) continue;
                class_2540 buf = PacketByteBufs.create();
                buf.writeInt(this.method_5628());
                buf.method_10817((Enum)AnimationName.ATTACK);
                buf.writeInt(15);
                ServerPlayNetworking.send((class_3222)player, (class_2960)WelcomeToMyWorld.ANIMATION_PACKET, (class_2540)buf);
            }
        }
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    public boolean getIsUsingSkill() {
        return (Boolean)this.field_6011.method_12789(IS_USING_SKILL);
    }

    public void setIsUsingSkill(boolean variant) {
        this.field_6011.method_12778(IS_USING_SKILL, (Object)variant);
    }

    public boolean getIsRandomFirstTime() {
        return (Boolean)this.field_6011.method_12789(IS_RANDOM_FIRST_TIME);
    }

    public void setIsRandomFirstTime(boolean variant) {
        this.field_6011.method_12778(IS_RANDOM_FIRST_TIME, (Object)variant);
    }

    public boolean getCanBeTamed() {
        return (Boolean)this.field_6011.method_12789(CAN_BE_TAMED);
    }

    public void setCanBeTamed(boolean variant) {
        this.field_6011.method_12778(CAN_BE_TAMED, (Object)variant);
    }

    public boolean getIsPatrolling() {
        return (Boolean)this.field_6011.method_12789(IS_PATROLLING);
    }

    public void setIsPatrolling(boolean variant) {
        this.field_6011.method_12778(IS_PATROLLING, (Object)variant);
    }

    public float getAllSkillCooldown() {
        return ((Float)this.field_6011.method_12789(ALL_SKILL_COOLDOWN)).floatValue();
    }

    public void setAllSkillCooldown(float variant) {
        this.field_6011.method_12778(ALL_SKILL_COOLDOWN, (Object)Float.valueOf(variant));
    }

    public boolean getCanBeTamedSet() {
        return (Boolean)this.field_6011.method_12789(CAN_BE_TAMED_SET);
    }

    public void setCanBeTamedSet(boolean variant) {
        this.field_6011.method_12778(CAN_BE_TAMED_SET, (Object)variant);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("canBeTamed", this.getCanBeTamed());
        nbt.method_10556("canBeTamedSet", this.getCanBeTamedSet());
        nbt.method_10548("allSkillCooldown", this.getAllSkillCooldown());
        nbt.method_10556("isRandomFirstTime", this.getIsRandomFirstTime());
        if (this.patrolCenterPos != null) {
            class_2499 homePos = new class_2499();
            homePos.add((Object)class_2489.method_23241((double)this.method_31477()));
            homePos.add((Object)class_2489.method_23241((double)this.method_31478()));
            homePos.add((Object)class_2489.method_23241((double)this.method_31479()));
            nbt.method_10566("patrolPos", (class_2520)homePos);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setCanBeTamed(nbt.method_10577("canBeTamed"));
        this.setCanBeTamedSet(nbt.method_10577("canBeTamedSet"));
        this.setIsRandomFirstTime(nbt.method_10577("isRandomFirstTime"));
        if (nbt.method_10583("allSkillCooldown") > 0.0f) {
            this.setAllSkillCooldown(nbt.method_10583("allSkillCooldown"));
        }
        if (nbt.method_10573("patrolPos", 9)) {
            class_2499 homePos = nbt.method_10554("patrolPos", 6);
            this.patrolCenterPos = new class_2338((int)homePos.method_10611(0), (int)homePos.method_10611(1), (int)homePos.method_10611(2));
        } else {
            this.patrolCenterPos = null;
        }
    }

    public class StopMoveAndLookWhenCanBeTamed
    extends class_1352 {
        private final FallenKnight mob;

        public StopMoveAndLookWhenCanBeTamed(FallenKnight mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.mob.getCanBeTamed();
        }

        public void method_6269() {
            this.mob.method_5942().method_6340();
        }

        public boolean method_6266() {
            return this.mob.getCanBeTamed();
        }

        public void method_6268() {
            this.mob.method_5942().method_6340();
        }
    }

    public class PatrollingGoal
    extends class_1352 {
        private final FallenKnight mob;
        private final double maxTeleportDistance = 20.0;
        private int cooldown = 0;

        public PatrollingGoal(FallenKnight mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.mob.getIsPatrolling() && this.mob.patrolCenterPos != null;
        }

        public boolean method_6266() {
            return this.mob.getIsPatrolling() && this.mob.patrolCenterPos != null;
        }

        public void method_6268() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return;
            }
            class_243 patrolPos = this.mob.patrolCenterPos.method_46558();
            double distance = this.mob.method_19538().method_1022(patrolPos);
            if (distance > 20.0) {
                if (this.mob.method_6082(patrolPos.field_1352, patrolPos.field_1351, patrolPos.field_1350, true)) {
                    this.cooldown = 100;
                    this.mob.method_5980(null);
                }
                return;
            }
            if (distance > (double)this.mob.patrolRadius) {
                this.moveToPatrolPos();
            } else if (this.mob.method_5968() == null) {
                this.wanderAroundPatrolPos();
            }
        }

        private void moveToPatrolPos() {
            this.mob.method_5942().method_6337((double)this.mob.patrolCenterPos.method_10263(), (double)this.mob.patrolCenterPos.method_10264(), (double)this.mob.patrolCenterPos.method_10260(), 1.2);
        }

        private void wanderAroundPatrolPos() {
            if (this.mob.method_5942().method_6357()) {
                class_243 randomTarget = this.findRandomTargetBlock();
                this.mob.method_5942().method_6337(randomTarget.field_1352, randomTarget.field_1351, randomTarget.field_1350, 0.8);
            }
        }

        private class_243 findRandomTargetBlock() {
            class_5819 random = this.mob.method_6051();
            return new class_243((double)this.mob.patrolCenterPos.method_10263() + (random.method_43058() - 0.5) * 10.0, (double)this.mob.patrolCenterPos.method_10264(), (double)this.mob.patrolCenterPos.method_10260() + (random.method_43058() - 0.5) * 10.0);
        }

        public void method_6270() {
            this.mob.method_5942().method_6340();
            this.cooldown = 0;
        }
    }

    public class CustomFollowOwnerGoal
    extends class_1352 {
        private final FallenKnight mob;
        private class_1309 owner;
        private final class_1937 world;
        private final double speed;
        private final float minFollowDistance;
        private final float maxFollowDistance;
        private final boolean leavesAllowed;
        private int teleportCooldown;
        private int pathUpdateCooldown;

        public CustomFollowOwnerGoal(FallenKnight mob, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
            this.mob = mob;
            this.world = mob.method_37908();
            this.speed = speed;
            this.minFollowDistance = minDistance;
            this.maxFollowDistance = maxDistance;
            this.leavesAllowed = leavesAllowed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.mob.getIsPatrolling() || this.mob.method_5968() != null) {
                return false;
            }
            class_1309 owner = this.mob.method_35057();
            if (owner == null) {
                return false;
            }
            double distanceSq = this.mob.method_5858((class_1297)owner);
            return distanceSq > (double)(this.maxFollowDistance * this.maxFollowDistance);
        }

        public boolean method_6266() {
            if (this.mob.getIsPatrolling() || this.mob.method_5968() != null) {
                return false;
            }
            class_1309 owner = this.mob.method_35057();
            if (owner == null) {
                return false;
            }
            double distanceSq = this.mob.method_5858((class_1297)owner);
            return distanceSq > (double)(this.minFollowDistance * this.minFollowDistance);
        }

        public void method_6269() {
            this.teleportCooldown = 0;
            this.pathUpdateCooldown = 0;
            this.owner = this.mob.method_35057();
        }

        public void method_6268() {
            this.mob.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.mob.method_5978());
            double distance = this.mob.method_5739((class_1297)this.owner);
            this.handleTeleportation(distance);
            this.handlePathfinding(distance);
        }

        private void handleTeleportation(double distance) {
            if (this.teleportCooldown > 0) {
                --this.teleportCooldown;
            }
            if (distance > (double)this.maxFollowDistance && this.teleportCooldown <= 0 && this.tryTeleportToOwner()) {
                this.teleportCooldown = 40;
                this.pathUpdateCooldown = 0;
            }
        }

        private void handlePathfinding(double distance) {
            if (this.pathUpdateCooldown > 0) {
                --this.pathUpdateCooldown;
                return;
            }
            if (distance > (double)this.minFollowDistance) {
                this.pathUpdateCooldown = 10;
                this.mob.method_5942().method_6335((class_1297)this.owner, this.speed);
            } else {
                this.mob.method_5942().method_6340();
            }
        }

        private boolean tryTeleportToOwner() {
            if (!this.leavesAllowed && !this.world.method_8320(this.owner.method_24515()).method_26215()) {
                return false;
            }
            return this.mob.method_6082(this.owner.method_23317(), this.owner.method_23318(), this.owner.method_23321(), true);
        }

        public void method_6270() {
            this.mob.method_5942().method_6340();
            this.owner = null;
            this.teleportCooldown = 0;
            this.pathUpdateCooldown = 0;
        }

        public boolean method_38846() {
            return true;
        }
    }

    public class StopWhenUsingSkill
    extends class_1352 {
        private final FallenKnight mob;

        public StopWhenUsingSkill(FallenKnight mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.mob.getIsUsingSkill();
        }

        public void method_6269() {
            this.mob.method_5942().method_6340();
        }

        public boolean method_6266() {
            return this.mob.getIsUsingSkill();
        }

        public void method_6268() {
            if (!this.mob.getIsUsingSkill()) {
                return;
            }
            this.mob.method_5942().method_6340();
        }
    }

    public class CustomMeleeAttackGoal
    extends class_1352 {
        private final int attackCooldown;
        private int counter = 0;
        private float speed = 1.0f;
        private FallenKnight mob;

        public CustomMeleeAttackGoal(FallenKnight mob, int attackCooldown, float speed) {
            this.attackCooldown = attackCooldown;
            this.counter = attackCooldown;
            this.mob = mob;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.mob.method_5968() != null;
        }

        public boolean method_6266() {
            return this.mob.method_5968() != null;
        }

        public void method_6270() {
            this.mob.method_19540(false);
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            super.method_6268();
            if (this.counter < this.attackCooldown) {
                ++this.counter;
                return;
            }
            class_1309 target = this.mob.method_5968();
            if (target == null) {
                return;
            }
            this.mob.method_5942().method_6335((class_1297)target, (double)this.speed);
            this.mob.method_5988().method_35111((class_1297)target);
            if (this.mob.method_5739((class_1297)target) < 4.5f) {
                this.counter = 0;
                this.mob.method_19540(true);
                this.mob.method_6121((class_1297)target);
            }
        }
    }

    public class LargeEntityWanderGoal
    extends class_1352 {
        private final class_1314 mob;
        private double targetX;
        private double targetY;
        private double targetZ;
        private final double speed;
        private final int chance;
        private final class_5819 random;

        public LargeEntityWanderGoal(class_1314 mob, double speed, int chance) {
            this.mob = mob;
            this.speed = speed;
            this.chance = chance;
            this.random = mob.method_6051();
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.mob.method_5782()) {
                return false;
            }
            if (this.mob.method_6051().method_43048(LargeEntityWanderGoal.method_38848((int)this.chance)) != 0) {
                return false;
            }
            class_243 target = this.getWanderTarget();
            if (target == null) {
                return false;
            }
            this.targetX = target.field_1352;
            this.targetY = target.field_1351;
            this.targetZ = target.field_1350;
            return true;
        }

        @Nullable
        protected class_243 getWanderTarget() {
            double width = this.mob.method_17681();
            double height = this.mob.method_17682();
            double minDistance = 5.0 + width;
            double maxDistance = 20.0 + width;
            double distance = minDistance + this.random.method_43058() * (maxDistance - minDistance);
            double angle = this.random.method_43058() * 2.0 * Math.PI;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            class_243 target = class_5532.method_31510((class_1314)this.mob, (int)((int)distance), (int)((int)height));
            if (target == null) {
                return new class_243(this.mob.method_23317() + offsetX, this.mob.method_23318(), this.mob.method_23321() + offsetZ);
            }
            return target;
        }

        public boolean method_6266() {
            return !this.mob.method_5942().method_6357();
        }

        public void method_6269() {
            this.mob.method_5942().method_6337(this.targetX, this.targetY + 0.15, this.targetZ, this.speed);
        }

        public void method_6270() {
            this.mob.method_5942().method_6340();
        }
    }

    class CustomTrackOwnerAttackGoal
    extends class_1405 {
        private final FallenKnight mob;
        private class_1309 attacker;
        private int lastAttackedTime;

        public CustomTrackOwnerAttackGoal(FallenKnight mob) {
            super((class_1308)mob, false);
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            if (this.mob.method_6181() && !this.mob.method_24345() && !this.mob.getIsPatrolling()) {
                class_1309 livingEntity = this.mob.method_35057();
                if (livingEntity == null) {
                    return false;
                }
                this.attacker = livingEntity.method_6065();
                int i = livingEntity.method_6117();
                return i != this.lastAttackedTime && this.method_6328(this.attacker, class_4051.field_18092) && this.mob.method_6178(this.attacker, livingEntity);
            }
            return false;
        }

        public void method_6269() {
            this.mob.method_5980(this.attacker);
            class_1309 livingEntity = this.mob.method_35057();
            if (livingEntity != null) {
                this.lastAttackedTime = livingEntity.method_6117();
            }
            super.method_6269();
        }
    }

    public class CustomAttackWithOwnerGoal
    extends class_1405 {
        private final FallenKnight tameable;
        private class_1309 attacking;
        private int lastAttackTime;

        public CustomAttackWithOwnerGoal(FallenKnight tameable) {
            super((class_1308)tameable, false);
            this.tameable = tameable;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            if (this.tameable.method_6181() && !this.tameable.method_24345() && !this.tameable.getIsPatrolling()) {
                class_1309 livingEntity = this.tameable.method_35057();
                if (livingEntity == null) {
                    return false;
                }
                this.attacking = livingEntity.method_6052();
                int i = livingEntity.method_6083();
                return i != this.lastAttackTime && this.method_6328(this.attacking, class_4051.field_18092) && this.tameable.method_6178(this.attacking, livingEntity);
            }
            return false;
        }

        public void method_6269() {
            this.field_6660.method_5980(this.attacking);
            class_1309 livingEntity = this.tameable.method_35057();
            if (livingEntity != null) {
                this.lastAttackTime = livingEntity.method_6083();
            }
            super.method_6269();
        }
    }
}

