/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.features;

import com.trongthang.welcometomyworld.GlobalConfig;
import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.managers.ItemsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_5250;

public class BossesSpawningHandler {
    public int checkInterval = 5000;
    public int counter = 0;
    public double bossSpawnChance = 0.5;
    final int SPAWN_MIN_DISTANCE = 32;
    final int SPAWN_MAX_DISTANCE = 64;
    private final ConcurrentHashMap<String, class_1299> ancientMobs = new ConcurrentHashMap();
    List<AncientMobDrops> ancientMobDrops = List.of(new AncientMobDrops(ItemsManager.ANCIENT_FRAGMENT, 1.0), new AncientMobDrops(ItemsManager.REPAIR_KNOWLEDGE, 0.6));
    private final Random random = new Random();

    public BossesSpawningHandler() {
        this.ancientMobs.put("Grimstalker", class_1299.field_6051);
        this.ancientMobs.put("Bonecrusher", class_1299.field_6051);
        this.ancientMobs.put("Fleshgrinder", class_1299.field_6079);
        this.ancientMobs.put("Shadowmancer", class_1299.field_6145);
        this.ancientMobs.put("Dreadfiend", class_1299.field_6051);
        this.ancientMobs.put("Soulstealer", class_1299.field_6079);
        this.ancientMobs.put("Deathbringer", class_1299.field_6051);
        this.ancientMobs.put("Rotting Revenant", class_1299.field_6051);
        this.ancientMobs.put("Plaguebearer", class_1299.field_6079);
        this.ancientMobs.put("Creeping Dread", class_1299.field_6079);
        this.ancientMobs.put("Ghoulmancer", class_1299.field_6051);
        this.ancientMobs.put("Fleshweaver", class_1299.field_6051);
        this.ancientMobs.put("Necrofiend", class_1299.field_6079);
        this.ancientMobs.put("Hallow's Wrath", class_1299.field_6145);
        this.ancientMobs.put("Nightcrawler", class_1299.field_6079);
        this.ancientMobs.put("Blightbringer", class_1299.field_6051);
        this.ancientMobs.put("Venomous Viper", class_1299.field_6079);
        this.ancientMobs.put("The Unseen", class_1299.field_6051);
        this.ancientMobs.put("Vile Wretch", class_1299.field_6051);
        this.ancientMobs.put("Chillbringer", class_1299.field_6051);
        this.ancientMobs.put("Soul Siphoner", class_1299.field_6145);
        this.ancientMobs.put("Cursed One", class_1299.field_6051);
        this.ancientMobs.put("Maw of Darkness", class_1299.field_6051);
        this.ancientMobs.put("Gravewalker", class_1299.field_6051);
        this.ancientMobs.put("Boneclaw", class_1299.field_6051);
        this.ancientMobs.put("Scourgecaller", class_1299.field_6079);
        this.ancientMobs.put("Doomharbinger", class_1299.field_6051);
        this.ancientMobs.put("Slime King", class_1299.field_6069);
        this.ancientMobs.put("The Unholy", class_1299.field_6079);
        this.ancientMobs.put("Death's Grin", class_1299.field_6051);
        this.ancientMobs.put("Spiteful Specter", class_1299.field_6079);
        this.ancientMobs.put("Fleshrot", class_1299.field_6051);
        this.ancientMobs.put("Black Widow", class_1299.field_6079);
        this.ancientMobs.put("The Hollow Lord", class_1299.field_6051);
        this.ancientMobs.put("Screeching Terror", class_1299.field_6079);
        this.ancientMobs.put("Rotface", class_1299.field_6051);
        this.ancientMobs.put("Fleshbeast", class_1299.field_6079);
        this.ancientMobs.put("Shattered Soul", class_1299.field_6051);
        this.ancientMobs.put("Hellspawn", class_1299.field_6051);
        this.ancientMobs.put("Swarmlord", class_1299.field_6079);
        this.ancientMobs.put("Venomous Shade", class_1299.field_6079);
        this.ancientMobs.put("Soulflayer", class_1299.field_6051);
        this.ancientMobs.put("Ender Wraith", class_1299.field_6091);
        this.ancientMobs.put("Enderenderman", class_1299.field_6091);
        ConcurrentHashMap updatedMap = new ConcurrentHashMap();
        this.ancientMobs.forEach((key, value) -> {
            String newKey = "Ancient " + key;
            updatedMap.put(newKey, value);
        });
        this.ancientMobs.clear();
        this.ancientMobs.putAll(updatedMap);
    }

    public void spawnZombieNearPlayers(class_3218 world) {
        ++this.counter;
        if (this.counter < this.checkInterval) {
            return;
        }
        this.counter = 0;
        double r = this.random.nextDouble();
        if (r > this.bossSpawnChance) {
            return;
        }
        world.method_18456().forEach(player -> {
            ArrayList mobNames;
            String randomMobName;
            class_1299 mobEntityType;
            class_1308 mob;
            class_2338 playerPos = player.method_24515();
            class_2338 spawnPos = this.findValidSpawnPosition(world, playerPos);
            if (spawnPos != null && (mob = (class_1308)(mobEntityType = this.ancientMobs.get(randomMobName = (String)(mobNames = new ArrayList(this.ancientMobs.keySet())).get(this.random.nextInt(mobNames.size())))).method_5883((class_1937)world)) != null) {
                mob.method_5808((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260(), 0.0f, 0.0f);
                mob.method_5665((class_2561)class_2561.method_43470((String)randomMobName).method_27694(style -> style.method_10977(class_124.field_1064)));
                Utils.applyEffectForMobs((class_1309)mob, 3, 200);
                class_5250 message = class_2561.method_43470((String)"\u2620").method_27694(style -> style.method_10977(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" An ").method_27694(style -> style.method_10977(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)randomMobName).method_27694(style -> style.method_10977(class_124.field_1064))).method_10852((class_2561)class_2561.method_43470((String)" just spawned nearby, be careful...").method_27694(style -> style.method_10977(class_124.field_1068))));
                player.method_43496((class_2561)message);
                this.spawnLightningForNoticePlayers(world, mob);
                world.method_8649((class_1297)mob);
                this.spawnParticlesUpToTheSky(world, mob);
                Utils.addRunAfter(() -> {
                    mob.method_5996(class_5134.field_23716).method_6192((double)(mob.method_6063() + 50.0f));
                    mob.method_5996(class_5134.field_23721).method_6192(mob.method_5996(class_5134.field_23721).method_6201() + 5.0);
                    mob.method_5996(class_5134.field_23724).method_6192(mob.method_5996(class_5134.field_23724).method_6201() + 2.0);
                    mob.method_6033(mob.method_6063());
                }, 30);
            }
        });
    }

    private class_2338 findValidSpawnPosition(class_3218 world, class_2338 playerPos) {
        if (world.method_8530()) {
            return null;
        }
        int i = 0;
        if (i < 10) {
            double angle = world.field_9229.method_43058() * 2.0 * Math.PI;
            int distance = 32 + world.field_9229.method_43048(33);
            int offsetX = (int)(Math.cos(angle) * (double)distance);
            int offsetZ = (int)(Math.sin(angle) * (double)distance);
            class_2338 randomOffset = playerPos.method_10069(offsetX, 0, offsetZ);
            class_2338 surfacePos = world.method_8598(class_2902.class_2903.field_13202, randomOffset);
            return surfacePos;
        }
        return null;
    }

    private void spawnParticlesUpToTheSky(class_3218 world, class_1308 mob) {
        class_2338 mobPos = mob.method_24515();
        int startY = mobPos.method_10264();
        int maxY = 256;
        for (int y = startY; y <= maxY; ++y) {
            class_2338 particlePos = new class_2338(mobPos.method_10263(), y, mobPos.method_10260());
            world.method_14199((class_2394)class_2398.field_11240, (double)particlePos.method_10263() + 0.5, (double)particlePos.method_10264() + 0.5, (double)particlePos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.05);
        }
    }

    private void spawnLightningForNoticePlayers(class_3218 world, class_1308 mob) {
        class_2338 pos = mob.method_24515();
        class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)world);
        lightning.method_24203((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        lightning.method_29498(true);
        world.method_8649((class_1297)lightning);
    }

    public void bossDropsRegister() {
        if (!GlobalConfig.canBossesSpawningHanlder) {
            return;
        }
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, world1) -> {
            if (entity instanceof class_1308 && entity.method_5797() != null && this.ancientMobs.containsKey(entity.method_5797().getString())) {
                class_2338 deathPos = entity.method_24515();
                class_3218 serverWorld = entity.method_5682().method_30002();
                if (serverWorld == null) {
                    return;
                }
                for (AncientMobDrops i : this.ancientMobDrops) {
                    double r = this.random.nextDouble();
                    if (!(r < i.getDropChance())) continue;
                    serverWorld.method_8649((class_1297)new class_1542((class_1937)serverWorld, (double)deathPos.method_10263(), (double)(deathPos.method_10264() + 1), (double)deathPos.method_10260(), i.getDropItem()));
                }
            }
        });
    }

    class AncientMobDrops {
        private class_1799 dropItem;
        private double chance;

        public AncientMobDrops(class_1792 dropItem, double chance) {
            this.dropItem = new class_1799((class_1935)dropItem);
            this.chance = chance;
        }

        public class_1799 getDropItem() {
            return this.dropItem;
        }

        public double getDropChance() {
            return this.chance;
        }
    }
}

