/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.features;

import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.PlayerData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class GiveStartingItemsHandler {
    public static ConcurrentHashMap<class_3222, List<class_1799>> pendingItems = new ConcurrentHashMap();

    public static void giveItemHandler(class_3222 player, boolean clearItem) {
        PlayerData p = WelcomeToMyWorld.dataHandler.playerDataMap.get(player.method_5667());
        GiveStartingItemsHandler.processPendingItems(player);
        if (!p.firstRemoveStartingItems && GiveStartingItemsHandler.hasAnyItemInInventory(player)) {
            if (clearItem) {
                player.method_31548().method_5448();
            }
            p.firstRemoveStartingItems = true;
            GiveStartingItemsHandler.giveStartingItems(player);
        }
    }

    private static void giveStartingItems(class_3222 player) {
        if (player == null) {
            return;
        }
        PlayerData p = WelcomeToMyWorld.dataHandler.playerDataMap.get(player.method_5667());
        if (p.firstGivingStartingItems) {
            return;
        }
        p.firstGivingStartingItems = true;
        MinecraftServer server = player.method_5682();
        class_1799 sandwich = GiveStartingItemsHandler.getModdedItems("croptopia:blt", 1);
        class_1799 purrifiedWater = new class_1799((class_1935)class_1802.field_8574);
        purrifiedWater.method_7948().method_10582("Potion", "minecraft:purified_water");
        class_1799 gamingConsole = GiveStartingItemsHandler.getModdedItems("gamediscs:gaming_console", 1);
        class_1799 gameDisc = GiveStartingItemsHandler.getModdedItems("gamediscs:game_disc_flappy_bird", 1);
        if (sandwich != null) {
            server.execute(() -> player.method_31548().method_7394(sandwich));
        }
        if (purrifiedWater != null) {
            server.execute(() -> player.method_31548().method_7394(purrifiedWater));
        }
        if (gamingConsole != null) {
            server.execute(() -> player.method_31548().method_7367(9, gamingConsole));
        }
        if (gameDisc != null) {
            server.execute(() -> player.method_31548().method_7367(10, gameDisc));
        }
        WelcomeToMyWorld.LOGGER.info("Gave starting items to player {}", (Object)player.method_5820());
    }

    public void giveMoreItems(class_3222 player) {
        if (player == null) {
            return;
        }
        class_1799 summonGolem = GiveStartingItemsHandler.getModdedItems("advancedgolems:golem_spawner", 1);
        class_1799 golemController = GiveStartingItemsHandler.getModdedItems("advancedgolems:golem_control", 1);
        if (summonGolem != null) {
            GiveStartingItemsHandler.dropItemToPlayer(player, summonGolem);
        }
        if (golemController != null) {
            GiveStartingItemsHandler.dropItemToPlayer(player, golemController);
        }
    }

    public static void dropItemToPlayer(class_3222 player, class_1799 item) {
        if (GiveStartingItemsHandler.hasFreeInventorySlot(player)) {
            player.method_5682().execute(() -> {
                class_3222 currentPlayer = player.method_5682().method_3760().method_14602(player.method_5667());
                if (currentPlayer == null) {
                    return;
                }
                class_3218 serverWorld = player.method_51469();
                class_1542 itemEntity = new class_1542((class_1937)serverWorld, currentPlayer.method_23317(), currentPlayer.method_23318(), currentPlayer.method_23321(), item);
                serverWorld.method_8649((class_1297)itemEntity);
            });
        } else {
            pendingItems.computeIfAbsent(player, k -> new ArrayList()).add(item);
        }
    }

    public static class_1799 getModdedItems(String itemId, int count) {
        class_2960 identifier = new class_2960(itemId);
        if (class_7923.field_41178.method_10250(identifier)) {
            WelcomeToMyWorld.LOGGER.info("Found: " + itemId);
            if (itemId.toLowerCase().equals("ftbquests:book")) {
                class_1799 item = new class_1799((class_1935)class_7923.field_41178.method_10223(identifier), count);
                item.method_7977((class_2561)class_2561.method_43470((String)"Just A Book Of Mine"));
                return item;
            }
            return new class_1799((class_1935)class_7923.field_41178.method_10223(identifier), count);
        }
        WelcomeToMyWorld.LOGGER.warn("Item with ID '{}' not found", (Object)itemId);
        return null;
    }

    private static boolean hasAnyItemInInventory(class_3222 player) {
        for (class_1799 itemStack : player.method_31548().field_7547) {
            if (itemStack.method_7960()) continue;
            return true;
        }
        for (class_1799 itemStack : player.method_31548().field_7548) {
            if (itemStack.method_7960()) continue;
            return true;
        }
        return !((class_1799)player.method_31548().field_7544.get(0)).method_7960();
    }

    public static boolean hasFreeInventorySlot(class_3222 player) {
        class_2371 mainInventory = player.method_31548().field_7547;
        return mainInventory.stream().anyMatch(class_1799::method_7960);
    }

    public static void processPendingItems(class_3222 player) {
        List<class_1799> items = pendingItems.get(player);
        if (items == null || items.isEmpty()) {
            return;
        }
        if (GiveStartingItemsHandler.hasFreeInventorySlot(player)) {
            items.removeIf(item -> {
                if (GiveStartingItemsHandler.hasFreeInventorySlot(player)) {
                    player.method_31548().method_7394(item);
                    return true;
                }
                return false;
            });
        }
        if (items.isEmpty()) {
            pendingItems.remove(player);
        }
    }
}

