/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.features;

import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.MonsterSpawn;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SpawnMonstersPackEveryMins {
    private static final double CHANCE_TO_HAPPEN = 69.0;
    private static final int COOLDOWN = 6000;
    private static int counter = 0;
    private static final int MONSTER_DESPAWN_AFTER_TICK = 4000;
    private static final int PACK_MIN_SIZE = 7;
    private static final int PACK_MAX_SIZE = 15;
    private static final int MIN_SPAWN_DISTANCE = 24;
    private static final int MAX_SPAWN_DISTANCE = 64;
    public static final int stopSpawningDay = 369;
    private static final List<MonsterSpawn> MONSTERS = List.of(new MonsterSpawn("minecraft:zombie", 50), new MonsterSpawn("minecraft:skeleton", 30), new MonsterSpawn("minecraft:creeper", 30));
    private static final Random RANDOM = new Random();

    public static void spawnMonsters(MinecraftServer server) {
        if (++counter <= 6000) {
            return;
        }
        counter = 0;
        if (WelcomeToMyWorld.dayAndNightCounterAnimationHandler.currentDay >= 369) {
            return;
        }
        class_3218 world = server.method_30002();
        if (world == null) {
            return;
        }
        if (!world.method_23886()) {
            return;
        }
        if ((double)RANDOM.nextInt(100) >= 69.0) {
            return;
        }
        List players = world.method_18456();
        if (players.isEmpty()) {
            return;
        }
        class_3222 player = (class_3222)players.get(RANDOM.nextInt(players.size()));
        class_1937 w = player.method_37908();
        if (w.method_27983() != class_1937.field_25179) {
            return;
        }
        if (player.method_7337() || player.method_7325()) {
            return;
        }
        int packSize = RANDOM.nextInt(9) + 7;
        for (int i = 0; i < packSize; ++i) {
            class_1297 entity;
            MonsterSpawn selectedMonster;
            class_2338 spawnPos = SpawnMonstersPackEveryMins.findSafeSpawnPosition(world, player.method_24515());
            if (spawnPos == null || (selectedMonster = SpawnMonstersPackEveryMins.getRandomMonster()) == null || (entity = Utils.spawnMob((class_1937)world, spawnPos, selectedMonster.getId())) == null) continue;
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                mob.method_5980((class_1309)player);
            }
            Utils.addRunAfter(() -> Utils.discardEntity(world, entity), 4000);
        }
    }

    private static MonsterSpawn getRandomMonster() {
        int totalWeight = MONSTERS.stream().mapToInt(MonsterSpawn::getData).sum();
        if (totalWeight <= 0) {
            return null;
        }
        int randomValue = RANDOM.nextInt(totalWeight);
        int currentWeight = 0;
        for (MonsterSpawn monster : MONSTERS) {
            if (randomValue >= (currentWeight += monster.getData())) continue;
            return monster;
        }
        return null;
    }

    public static class_2338 findSafeSpawnPosition(class_3218 world, class_2338 playerPos) {
        int MAX_ATTEMPTS = 40;
        int VERTICAL_SEARCH_RANGE = 10;
        for (int i = 0; i < 40; ++i) {
            double distance = 24.0 + RANDOM.nextDouble() * 40.0;
            double angle = RANDOM.nextDouble() * 2.0 * Math.PI;
            int offsetX = (int)(Math.cos(angle) * distance);
            int offsetZ = (int)(Math.sin(angle) * distance);
            class_2338 candidatePos = playerPos.method_10069(offsetX, 0, offsetZ);
            for (int offsetY = -10; offsetY <= 10; ++offsetY) {
                class_2338 blockBelow;
                class_2338 potentialPos = candidatePos.method_10069(0, offsetY, 0);
                if (!world.method_24794(potentialPos) || !world.method_8320(blockBelow = potentialPos.method_10074()).method_51367() || !SpawnMonstersPackEveryMins.isAirSpaceClear(world, potentialPos)) continue;
                return potentialPos;
            }
        }
        return null;
    }

    private static boolean isAirSpaceClear(class_3218 world, class_2338 pos) {
        for (int i = 0; i < 3; ++i) {
            if (world.method_22347(pos.method_10086(i))) continue;
            return false;
        }
        return true;
    }
}

