/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.mixin;

import com.trongthang.welcometomyworld.GlobalConfig;
import com.trongthang.welcometomyworld.Utilities.Utils;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1560.class})
public abstract class EndermanAIMixin
extends class_1297 {
    private final int COOLDOWN_TIME = 900;
    private int counter = 900;
    private boolean canUseTeleportSkill = true;
    private static boolean endermanCanPickBlocks = true;
    private final double chanceToUseSkill = 0.8;
    private final double chanceToSwitchBetweenTwoWayOfPickingPlayers = 0.5;
    private class_2338 lastPos;
    private class_2338 playerPos;
    private class_2338 destinationPos;
    private int delay = 4;
    private int counterDelay = 0;
    private boolean isUsingSkill = false;
    private class_1657 liftingPlayer;
    private Random rand = new Random();
    private int blockBelowPlayer = 8;

    public EndermanAIMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"tickMovement"}, at={@At(value="HEAD")})
    public void onTickMovement(CallbackInfo ci) {
        if (!GlobalConfig.canEndermanAI) {
            return;
        }
        if (!this.isUsingSkill && !this.canUseTeleportSkill) {
            ++this.counter;
            if (this.counter > 900) {
                this.canUseTeleportSkill = true;
            }
            return;
        }
        class_1560 enderman = (class_1560)this;
        class_1937 world = enderman.method_37908();
        if (world.method_27983().method_29177().equals((Object)new class_2960("minecraft:the_end"))) {
            return;
        }
        class_1657 targetPlayer = enderman.method_5968() instanceof class_1657 ? (class_1657)enderman.method_5968() : null;
        ++this.counterDelay;
        if (this.counterDelay > this.delay) {
            if (this.playerPos != null) {
                enderman.method_20620((double)this.playerPos.method_10263(), (double)this.playerPos.method_10264(), (double)this.playerPos.method_10260());
            }
            if (this.destinationPos != null) {
                enderman.method_20620((double)this.destinationPos.method_10263(), (double)this.destinationPos.method_10264(), (double)this.destinationPos.method_10260());
            }
            this.counterDelay = 0;
        }
        if (this.liftingPlayer != null) {
            this.teleportPlayerInFrontOfEnderman();
            class_243 direction = this.liftingPlayer.method_19538().method_1020(enderman.method_19538()).method_1029();
            double yaw = Math.atan2(direction.field_1352, direction.field_1350);
            double pitch = Math.asin(direction.field_1351);
            enderman.method_36456((float)(yaw * 57.29577951308232));
            enderman.method_36457((float)(pitch * 57.29577951308232));
        }
        if (targetPlayer == null) {
            this.liftingPlayer = null;
            return;
        }
        if (targetPlayer != null && enderman.method_7028() && this.canUseTeleportSkill) {
            double chance = this.rand.nextDouble();
            if (chance > 0.8) {
                this.canUseTeleportSkill = false;
                this.counter = 0;
                return;
            }
            this.canUseTeleportSkill = false;
            this.counter = 0;
            this.isUsingSkill = true;
            if (!targetPlayer.method_5770().method_8311(targetPlayer.method_24515())) {
                this.liftingPlayer = null;
                return;
            }
            enderman.method_7032(class_2246.field_10566.method_9564());
            if (chance <= 0.5 && enderman.method_7027() == null) {
                enderman.method_7032(class_2246.field_10124.method_9564());
                this.teleportToPlayer(targetPlayer, enderman);
                Utils.addRunAfter(() -> this.pickPlayerUp(targetPlayer, enderman), 30);
                Utils.addRunAfter(() -> this.teleportToSkyWithPlayer(targetPlayer, enderman), 50);
                Utils.addRunAfter(() -> this.teleportBackToTheLastPos(enderman), 60);
            } else {
                this.checkAroundAndPickBlock(enderman);
                Utils.addRunAfter(() -> this.teleportToPlayer(targetPlayer, enderman), 10);
                Utils.addRunAfter(() -> this.pickPlayerUp(targetPlayer, enderman), 40);
                Utils.addRunAfter(() -> this.teleportToSkyWithPlayer(targetPlayer, enderman), 50);
                Utils.addRunAfter(() -> this.placeBlockBelowPlayer(enderman), 55);
                Utils.addRunAfter(() -> this.teleportBackToTheLastPos(enderman), 60);
            }
        }
    }

    private void teleportToPlayer(class_1657 targetPlayer, class_1560 enderman) {
        if (enderman.method_6032() <= 0.0f) {
            return;
        }
        class_3222 player = null;
        if (targetPlayer != null) {
            player = targetPlayer.method_5682().method_3760().method_14602(targetPlayer.method_5667());
        }
        if (player == null) {
            return;
        }
        this.lastPos = enderman.method_24515();
        enderman.method_20620(targetPlayer.method_23317(), targetPlayer.method_23318(), targetPlayer.method_23321());
        this.playerPos = targetPlayer.method_24515();
        this.playSoundAndSpawnParticles(enderman.method_24515(), class_2398.field_11214, class_3417.field_14879);
    }

    private void pickPlayerUp(class_1657 targetPlayer, class_1560 enderman) {
        if (enderman.method_6032() <= 0.0f) {
            return;
        }
        class_3222 player = null;
        if (targetPlayer != null) {
            player = targetPlayer.method_5682().method_3760().method_14602(targetPlayer.method_5667());
        }
        if (player == null) {
            return;
        }
        if (enderman.method_5739((class_1297)targetPlayer) > 6.0f) {
            this.playSoundAndSpawnParticles(enderman.method_24515(), class_2398.field_11231, class_3417.field_14797);
            enderman.method_5980((class_1309)targetPlayer);
            this.playerPos = null;
            this.liftingPlayer = null;
            return;
        }
        this.playSoundAndSpawnParticles(enderman.method_24515(), class_2398.field_11204, class_3417.field_14785);
        this.playerPos = null;
        this.liftingPlayer = targetPlayer;
    }

    private void teleportToSkyWithPlayer(class_1657 targetPlayer, class_1560 enderman) {
        if (enderman.method_6032() <= 0.0f) {
            return;
        }
        class_3222 player = null;
        if (this.liftingPlayer != null) {
            player = this.liftingPlayer.method_5682().method_3760().method_14602(this.liftingPlayer.method_5667());
        }
        if (player == null) {
            return;
        }
        this.isUsingSkill = false;
        enderman.method_5980(null);
        enderman.method_29513(null);
        if (this.liftingPlayer == null) {
            return;
        }
        if (enderman.method_6032() <= 0.0f) {
            return;
        }
        class_2338 targetPos = targetPlayer.method_24515().method_10069(0, this.rand.nextInt(100, 140), 0);
        this.playSoundAndSpawnParticles(targetPos, class_2398.field_11214, class_3417.field_14879);
        targetPlayer.method_5859((double)(targetPos.method_10263() - 1), (double)targetPos.method_10264(), (double)(targetPos.method_10260() - 1));
        enderman.method_5859((double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260());
        this.playerPos = null;
        this.destinationPos = targetPos;
    }

    private void placeBlockBelowPlayer(class_1560 enderman) {
        class_2338 targetPos;
        if (enderman.method_6032() <= 0.0f) {
            return;
        }
        class_3222 player = null;
        if (this.liftingPlayer != null) {
            player = this.liftingPlayer.method_5682().method_3760().method_14602(this.liftingPlayer.method_5667());
        }
        if (player == null) {
            return;
        }
        class_1937 world = this.liftingPlayer.method_37908();
        if (!world.method_22347(targetPos = player.method_24515().method_10087(this.blockBelowPlayer))) {
            return;
        }
        class_2248 endermanHoldingBlock = enderman.method_7027().method_26204();
        enderman.method_5859((double)(targetPos.method_10263() - 1), (double)(targetPos.method_10264() - 2), (double)(targetPos.method_10260() - 1));
        this.playSoundAndSpawnParticles(targetPos, class_2398.field_11214, class_3417.field_14879);
        world.method_8501(targetPos, endermanHoldingBlock.method_9564());
        world.method_8396(null, targetPos, endermanHoldingBlock.method_9564().method_26231().method_10598(), class_3419.field_15245, 1.0f, 1.0f);
        this.playerPos = null;
        enderman.method_7032(null);
    }

    public void checkAroundAndPickBlock(class_1560 enderman) {
        class_2680 block = enderman.method_7027();
        if (block != null) {
            return;
        }
        class_1937 world = enderman.method_37908();
        class_2338 endermanPos = enderman.method_24515();
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius - 1; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos = endermanPos.method_10069(x, y, z);
                    class_2680 blockState = world.method_8320(pos);
                    if (!EndermanAIMixin.isValidEndermanPickup(blockState)) continue;
                    world.method_8501(pos, class_2246.field_10124.method_9564());
                    Utils.playSound(enderman.method_5682().method_30002(), enderman.method_24515(), blockState.method_26204().method_9564().method_26231().method_10595());
                    enderman.method_7032(blockState.method_26204().method_9564());
                    return;
                }
            }
        }
    }

    public boolean checkAroundTargetBlockIfItsAir(class_1560 enderman, class_2338 pos) {
        int radius = 3;
        class_1937 world = enderman.method_37908();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (world.method_8320(pos.method_10069(x, y, z)).method_26215()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isValidEndermanPickup(class_2680 state) {
        return state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10102) || state.method_27852(class_2246.field_10255) || state.method_27852(class_2246.field_10460) || state.method_27852(class_2246.field_10415) || state.method_27852(class_2246.field_10495);
    }

    private void teleportBackToTheLastPos(class_1560 enderman) {
        class_3222 player = null;
        if (this.liftingPlayer != null) {
            player = this.liftingPlayer.method_5682().method_3760().method_14602(this.liftingPlayer.method_5667());
        }
        if (player == null) {
            return;
        }
        this.liftingPlayer = null;
        endermanCanPickBlocks = true;
        enderman.method_7032(null);
        this.playSoundAndSpawnParticles(enderman.method_24515(), class_2398.field_11214, class_3417.field_14879);
        this.destinationPos = null;
        enderman.method_20620((double)this.lastPos.method_10263(), (double)this.lastPos.method_10264(), (double)this.lastPos.method_10260());
        enderman.method_5980(null);
        enderman.method_29513(null);
    }

    private void teleportPlayerInFrontOfEnderman() {
        class_3222 player = null;
        if (this.liftingPlayer != null) {
            player = this.liftingPlayer.method_5682().method_3760().method_14602(this.liftingPlayer.method_5667());
        }
        if (player == null) {
            return;
        }
        class_2338 endermanPos = this.method_24515();
        class_2338 frontOfEnderman = endermanPos.method_10069(1, 0, 0);
        this.liftingPlayer.method_5859((double)frontOfEnderman.method_10263(), (double)frontOfEnderman.method_10264(), (double)frontOfEnderman.method_10260());
    }

    private void playSoundAndSpawnParticles(class_2338 pos, class_2400 type, class_3414 soundEvent) {
        MinecraftServer server = this.method_5682();
        if (server == null) {
            return;
        }
        class_3218 serverWorld = server.method_30002();
        for (int i = 0; i < 30; ++i) {
            double offsetX = (serverWorld.method_8409().method_43058() - 0.5) * 2.0;
            double offsetY = serverWorld.method_8409().method_43058() * 2.0;
            double offsetZ = (serverWorld.method_8409().method_43058() - 0.5) * 2.0;
            serverWorld.method_14199((class_2394)type, (double)pos.method_10263() + offsetX, (double)pos.method_10264() + offsetY, (double)pos.method_10260() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            serverWorld.method_8396(null, pos, soundEvent, class_3419.field_15251, 0.8f, 1.0f);
        }
    }

    @Inject(method={"setCarriedBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventBlockPickup(class_2680 state, CallbackInfo ci) {
        if (!endermanCanPickBlocks) {
            ci.cancel();
        }
    }
}

