/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld;

import com.trongthang.welcometomyworld.BlocksPlacedAndBrokenByMobsHandler;
import com.trongthang.welcometomyworld.CompatityChecker;
import com.trongthang.welcometomyworld.ConfigLoader;
import com.trongthang.welcometomyworld.DataHandler;
import com.trongthang.welcometomyworld.GlobalConfig;
import com.trongthang.welcometomyworld.ServerNetworking;
import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.classes.PlayerData;
import com.trongthang.welcometomyworld.events.SpawnEvents;
import com.trongthang.welcometomyworld.features.AchievementsHandler;
import com.trongthang.welcometomyworld.features.AwakeHandler;
import com.trongthang.welcometomyworld.features.BossesSpawningHandler;
import com.trongthang.welcometomyworld.features.BreakingBlocksSpawnMobsHandler;
import com.trongthang.welcometomyworld.features.DayAndNightCounterAnimationHandler;
import com.trongthang.welcometomyworld.features.DeathCounter;
import com.trongthang.welcometomyworld.features.EventsOfTheWorld;
import com.trongthang.welcometomyworld.features.FallingToWaterDamage;
import com.trongthang.welcometomyworld.features.GiveStartingItemsHandler;
import com.trongthang.welcometomyworld.features.IntroOfTheWorldHandler;
import com.trongthang.welcometomyworld.features.LightningsStrikePlayersInRain;
import com.trongthang.welcometomyworld.features.NauseaInWaterHandler;
import com.trongthang.welcometomyworld.features.PunchingBlocksPenalties;
import com.trongthang.welcometomyworld.features.SpawnMonstersPackEveryMins;
import com.trongthang.welcometomyworld.features.WorldDifficultyBasedOnInGameDay;
import com.trongthang.welcometomyworld.items.BuffTalisman;
import com.trongthang.welcometomyworld.items.RepairTalisman;
import com.trongthang.welcometomyworld.managers.BlocksEntitiesManager;
import com.trongthang.welcometomyworld.managers.BlocksManager;
import com.trongthang.welcometomyworld.managers.EntitiesManager;
import com.trongthang.welcometomyworld.managers.ItemsManager;
import com.trongthang.welcometomyworld.managers.PlayerStatsDataManager;
import com.trongthang.welcometomyworld.managers.SoundsManager;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WelcomeToMyWorld
implements ModInitializer {
    public static Random random = new Random();
    public static final String MOD_ID = "welcometomyworld";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"welcometomyworld");
    public static DataHandler dataHandler = new DataHandler();
    public static CompatityChecker compatityChecker = new CompatityChecker();
    public static BlocksPlacedAndBrokenByMobsHandler blocksPlacedAndBrokenByMobsHandler = new BlocksPlacedAndBrokenByMobsHandler();
    public static final class_2960 FIRST_ORIGIN_CHOOSING_SCREEN = new class_2960("welcometomyworld", "first_origin_choosing_screen");
    public static final class_2960 STOP_SENDING_ORIGINS_SCREEN = new class_2960("welcometomyworld", "stop_sending_origins_screen");
    public static final class_2960 PLAY_BLOCK_PORTAL_TRAVEL = new class_2960("welcometomyworld", "play_block_portal_travel");
    public static final class_2960 PLAY_BLOCK_LEVER_CLICK = new class_2960("welcometomyworld", "play_block_lever_click");
    public static final class_2960 PLAY_EXPERIENCE_ORB_PICK_UP = new class_2960("welcometomyworld", "play_experience_orb_pick_up");
    public static final class_2960 PLAY_ENTITY_PLAYER_LEVELUP = new class_2960("welcometomyworld", "play_entity_player_levelup");
    public static final class_2960 PLAY_WOLF_HOWL = new class_2960("welcometomyworld", "play_wolf_howl");
    public static final class_2960 PLAY_ANVIL_USE = new class_2960("welcometomyworld", "play_anvil_use");
    public static final class_2960 TIRED_SOUND = new class_2960("welcometomyworld", "tired_sound");
    public static final class_2960 A_LIVING_CHEST_EATING_SOUND = new class_2960("welcometomyworld", "a_living_chest_eating_sound");
    public static final class_2960 A_LIVING_CHEST_MOUTH_CLOSE = new class_2960("welcometomyworld", "a_living_chest_mouth_close");
    public static final class_2960 A_LIVING_CHEST_MOUTH_OPEN = new class_2960("welcometomyworld", "a_living_chest_mouth_open");
    public static final class_2960 A_LIVING_CHEST_JUMP = new class_2960("welcometomyworld", "a_living_chest_jump");
    public static final class_2960 A_LIVING_CHEST_EAT_ANIMATION = new class_2960("welcometomyworld", "eat_animation");
    public static final class_2960 A_LIVING_CHEST_ATTACK = new class_2960("welcometomyworld", "a_living_chest_attack");
    public static final class_2960 PORTALER_COMPLETE_PORTAL_CHANGING = new class_2960("welcometomyworld", "portaler_complete_portal_changing");
    public static final class_2960 PLAY_BELL = new class_2960("welcometomyworld", "play_bell");
    public static final class_2960 SOUND_PACKET_ID = new class_2960("welcometomyworld", "sound_packet");
    public static final class_2960 ANIMATION_PACKET = new class_2960("welcometomyworld", "animation_packet");
    public static final class_2960 CHANGE_PERSPECTIVE = new class_2960("welcometomyworld", "change_perspective_packet");
    public static final class_2960 PLAYER_BREAKING_BLOCK = new class_2960("welcometomyworld", "breaking_block");
    public static final class_2960 FALLING_TO_WATER = new class_2960("welcometomyworld", "falling_to_water");
    public static DeathCounter deathCounter = new DeathCounter();
    public static FallingToWaterDamage fallingToWaterDamage = new FallingToWaterDamage();
    public static GiveStartingItemsHandler giveStartingItemsHandler = new GiveStartingItemsHandler();
    public static IntroOfTheWorldHandler introOfTheWorldHandler = new IntroOfTheWorldHandler();
    public static BreakingBlocksSpawnMobsHandler breakingBlocksSpawnMobsHandler = new BreakingBlocksSpawnMobsHandler();
    public static AwakeHandler awakeHandler = new AwakeHandler();
    public static DayAndNightCounterAnimationHandler dayAndNightCounterAnimationHandler = new DayAndNightCounterAnimationHandler();
    public static PunchingBlocksPenalties punchingBlocksPenalties = new PunchingBlocksPenalties();
    public static WorldDifficultyBasedOnInGameDay worldDifficultyBasedOnInGameDay = new WorldDifficultyBasedOnInGameDay();
    public static AchievementsHandler achievementsHandler = new AchievementsHandler();
    public static NauseaInWaterHandler nauseaInWaterHandler = new NauseaInWaterHandler();
    public static BossesSpawningHandler bossesSpawningHandler = new BossesSpawningHandler();
    public static LightningsStrikePlayersInRain lightningsStrikePlayersInRain = new LightningsStrikePlayersInRain();
    MinecraftServer server;

    public void onInitialize() {
        ConfigLoader.loadConfig();
        compatityChecker.OriginCheck();
        ServerLifecycleEvents.SERVER_STARTING.register(t -> {
            WelcomeToMyWorld.introOfTheWorldHandler.alreadySpawnedPhantom = false;
            dataHandler.initializeWorldData(t);
            dayAndNightCounterAnimationHandler.resetFields();
            this.registerEvents();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(t -> {
            Utils.preloadHorizontalChunksAtSpawn(t.method_30002());
            class_3218 world = t.method_30002();
            if (world != null) {
                ((class_1928.class_4312)world.method_8450().method_20746(class_1928.field_28357)).method_35236(100, t);
            }
            this.server = t;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            boolean keepInventory = server.method_3767().method_8355(class_1928.field_19389);
            if (keepInventory) {
                LOGGER.info("keepInventory is true. Checking stack trace....  This is a debug log of WelcomeToMyWorld mod, it's used to debug what mod sometimes set the KeepInventory to true, please send me the log if you see this message");
                Thread.dumpStack();
            }
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(t -> {
            dataHandler.saveData(t);
            this.server = null;
        });
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, packetSender, minecraftServer) -> this.performAllActionsFirstJoin(serverPlayNetworkHandler.method_32311()));
        PlayerBlockBreakEvents.AFTER.register((world, playerEntity, blockPos, blockState, blockEntity) -> {
            if (!GlobalConfig.canBreakBlockSpawnMobs) {
                return;
            }
            breakingBlocksSpawnMobsHandler.handleBlockBreakMobSpawn(world, playerEntity, blockPos, blockState, blockEntity);
        });
        ServerTickEvents.START_SERVER_TICK.register(this::onStartServerTick);
        ServerTickEvents.END_SERVER_TICK.register(this::onEndServerTick);
        punchingBlocksPenalties.handlePunchingBlock();
        deathCounter.startCountingDeaths();
        if (GlobalConfig.canWaterFallDamage) {
            fallingToWaterDamage.handleFallingToWaterDamage();
        }
        ItemsManager.initialize();
        EntitiesManager.register();
        BlocksEntitiesManager.initialize();
        BlocksManager.registerModBlocks();
        PlayerStatsDataManager.start();
        SoundsManager.registerSounds();
        ServerNetworking.register();
        SpawnEvents.register();
    }

    private void performAllActionsFirstJoin(class_3222 player) {
        UUID playerUUID = player.method_5667();
        LOGGER.info("Checking if player {} is a first-time joiner in this world...", (Object)player.method_5477().getString());
        if (WelcomeToMyWorld.dataHandler.playerDataMap.containsKey(playerUUID)) {
            LOGGER.info("Player {} has already joined before in this world. Skipping teleport.", (Object)player.method_5477().getString());
            return;
        }
        LOGGER.info("Player {} is joining for the first time in this world. Adding to firstTimePlayers set and teleporting.", (Object)player.method_5477().getString());
        WelcomeToMyWorld.dataHandler.playerDataMap.put(playerUUID, new PlayerData(true));
        ServerPlayNetworking.send((class_3222)player, (class_2960)CHANGE_PERSPECTIVE, (class_2540)PacketByteBufs.empty());
        if (player.method_5805() && GlobalConfig.canSwitchPerspective) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Easycraft - Creator: TrongThang").method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)));
        }
    }

    private void onStartServerTick(MinecraftServer server) {
    }

    private void onEndServerTick(MinecraftServer server) {
        if (GlobalConfig.canBedsExplode) {
            awakeHandler.checkAndExplodeIfSleeping(server);
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            if (GlobalConfig.canDayAndNightCounterAnimation) {
                dayAndNightCounterAnimationHandler.onServerTick(player);
            }
            if (ConfigLoader.getInstance().introOfTheWorld) {
                introOfTheWorldHandler.handlePlayerFirstJoin(player);
            }
            if (GlobalConfig.canNauseaInWater) {
                nauseaInWaterHandler.onServerTick(server);
            }
            if (GlobalConfig.canBossesSpawningHanlder) {
                bossesSpawningHandler.spawnZombieNearPlayers(server.method_30002());
            }
            if (ConfigLoader.getInstance().giveStartingItems) {
                GiveStartingItemsHandler.giveItemHandler(player, ConfigLoader.getInstance().clearItemsBeforeGivingStartingItems);
            }
            ((RepairTalisman)ItemsManager.REPAIR_TALISMAN_IRON).onServerTick(player, ItemsManager.REPAIR_TALISMAN_IRON);
            ((RepairTalisman)ItemsManager.REPAIR_TALISMAN_GOLD).onServerTick(player, ItemsManager.REPAIR_TALISMAN_GOLD);
            ((RepairTalisman)ItemsManager.REPAIR_TALISMAN_EMERALD).onServerTick(player, ItemsManager.REPAIR_TALISMAN_EMERALD);
            ((BuffTalisman)ItemsManager.POWER_TALISMAN).onServerTick(player, ItemsManager.POWER_TALISMAN);
            ((BuffTalisman)ItemsManager.SPEED_TALISMAN).onServerTick(player, ItemsManager.SPEED_TALISMAN);
            ((BuffTalisman)ItemsManager.LIFE_TALISMAN).onServerTick(player, ItemsManager.LIFE_TALISMAN);
            ((BuffTalisman)ItemsManager.RESISTANCE_TALISMAN).onServerTick(player, ItemsManager.RESISTANCE_TALISMAN);
        }
        if (GlobalConfig.canEventsOfTheWorld) {
            EventsOfTheWorld.onServerTick(server);
        }
        if (GlobalConfig.canWorldDifficultyBasedOnDay) {
            worldDifficultyBasedOnInGameDay.onServerTick(server);
        }
        if (GlobalConfig.canAchievementHandler) {
            achievementsHandler.onServerTick(server);
        }
        if (GlobalConfig.canLightningsStrikePlayersInRain) {
            lightningsStrikePlayersInRain.onServerTick(server);
        }
        blocksPlacedAndBrokenByMobsHandler.onSererTick(server);
        Utils.onServerTick(server);
        SpawnMonstersPackEveryMins.spawnMonsters(server);
    }

    public void registerEvents() {
        bossesSpawningHandler.bossDropsRegister();
        introOfTheWorldHandler.registerIntroEvents();
    }
}

