/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.entities;

import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.AnimationName;
import com.trongthang.welcometomyworld.classes.StartAnimation;
import com.trongthang.welcometomyworld.client.ClientData;
import com.trongthang.welcometomyworld.managers.SoundsManager;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1730;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import net.minecraft.class_747;
import org.jetbrains.annotations.Nullable;

public class Enderchester
extends class_1321
implements StartAnimation {
    ConcurrentHashMap<AnimationName, class_7094> animationHashMap = new ConcurrentHashMap();
    private static final class_2940<Boolean> IS_SLEEPING = class_2945.method_12791(Enderchester.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CAN_SLEEP = class_2945.method_12791(Enderchester.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_OPENING_CHEST = class_2945.method_12791(Enderchester.class, (class_2941)class_2943.field_13323);
    List<class_1792> hateItems = List.of(class_1802.field_8831, class_1802.field_8270);
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 walkAnimationState = new class_7094();
    public final class_7094 sitAnimationState = new class_7094();
    public final class_7094 sleepAnimationState = new class_7094();
    public final class_7094 mouthOpenAnimationState = new class_7094();
    public final class_7094 mouthCloseAnimationState = new class_7094();
    public final class_7094 eatAnimationState = new class_7094();
    public final class_7094 splitAnimationState = new class_7094();
    public final class_7094 jumpAnimationState = new class_7094();
    public final class_7094 attackAnimationState = new class_7094();
    public int animationTimeout = 0;
    public boolean chestIsClose = true;
    public double chanceToSleep = 0.35;
    public int sleepingCheckCooldown = 2000;
    public int sleepingCheckCounter = 0;
    public int sleepingMinDuration = 400;
    private int sleepDurationCurrent = 0;
    public int canSleepCooldown = 400;
    public int canSleepCounter = 0;
    private class_2394 particleEffect = class_2398.field_11214;
    public int particleSpawnCounter = 0;
    public int eatingThingsCouter = 0;
    public int passiveHealingCounter = 0;
    public boolean isInCombat = false;
    public int inCombatCooldown = 20;
    public int inCombatCounter = 0;
    public class_1792 tameFood = class_1802.field_8634;
    public float passiveHealingAmount = 6.0f;
    public static int DEFAULT_ANIMATION_TIMEOUT = 15;
    public static int DEFAULT_PARTICLE_SPAWN_COOLDOWN = 20;
    public static int DEFAULT_EATING_COOLDOWN = 20;
    public static int EAT_AREA = 7;
    public static int PASSIVE_HEALING_COOLDOWN = 60;
    private boolean isCatchingFish;

    public Enderchester(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.animationHashMap.put(AnimationName.IDLE, this.idleAnimationState);
        this.animationHashMap.put(AnimationName.EAT_ITEMS, this.eatAnimationState);
        this.animationHashMap.put(AnimationName.WALK, this.walkAnimationState);
        this.animationHashMap.put(AnimationName.MOUTH_CLOSE, this.mouthCloseAnimationState);
        this.animationHashMap.put(AnimationName.MOUTH_OPEN, this.mouthOpenAnimationState);
        this.animationHashMap.put(AnimationName.SPLIT_ITEMS, this.splitAnimationState);
        this.animationHashMap.put(AnimationName.SIT, this.sitAnimationState);
        this.animationHashMap.put(AnimationName.JUMP, this.jumpAnimationState);
        this.animationHashMap.put(AnimationName.SLEEP, this.sleepAnimationState);
        this.animationHashMap.put(AnimationName.ATTACK, this.attackAnimationState);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23719, (double)0.15f).method_26868(class_5134.field_23721, 12.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_SLEEPING, (Object)false);
        this.field_6011.method_12784(CAN_SLEEP, (Object)true);
        this.field_6011.method_12784(IS_OPENING_CHEST, (Object)false);
    }

    public void setIsSleepingData(boolean value) {
        this.field_6011.method_12778(IS_SLEEPING, (Object)value);
    }

    public boolean getIsSleepingData() {
        return (Boolean)this.field_6011.method_12789(IS_SLEEPING);
    }

    public void setCanSleepData(boolean value) {
        this.field_6011.method_12778(CAN_SLEEP, (Object)value);
    }

    public boolean getCanSleepData() {
        return (Boolean)this.field_6011.method_12789(CAN_SLEEP);
    }

    public void setIsOpeningChestData(boolean value) {
        this.field_6011.method_12778(IS_OPENING_CHEST, (Object)value);
    }

    public boolean getIsOpeningChestData() {
        return (Boolean)this.field_6011.method_12789(IS_OPENING_CHEST);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new SleepingNoMove(this));
        this.field_6201.method_6277(6, (class_1352)new StopMovementGoalWhenOpeningChest(this));
        this.field_6201.method_6277(7, (class_1352)new class_1350((class_1321)this, 3.0, 8.0f, 2.0f, false));
        this.field_6201.method_6277(8, (class_1352)new FleeFromNearbyPlayersGoal(this, 15.0f, 2.8));
        this.field_6201.method_6277(9, (class_1352)new class_1366((class_1314)this, 2.2, true));
        this.field_6201.method_6277(10, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(11, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(12, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
    }

    public void method_6114(class_1297 target) {
        super.method_6114(target);
        class_2540 id = PacketByteBufs.create();
        id.writeInt(this.method_5628());
        this.animationTimeout = 25;
        if (this.method_35057() == null) {
            for (class_3222 p : this.method_5682().method_3760().method_14571()) {
                if (!p.method_6057((class_1297)this)) continue;
                ServerPlayNetworking.send((class_3222)p, (class_2960)WelcomeToMyWorld.A_LIVING_CHEST_ATTACK, (class_2540)id);
            }
        } else {
            ServerPlayNetworking.send((class_3222)((class_3222)this.method_35057()), (class_2960)WelcomeToMyWorld.A_LIVING_CHEST_ATTACK, (class_2540)id);
        }
    }

    public void method_6173(boolean tamed) {
        byte b = (Byte)this.field_6011.method_12789(field_6322);
        if (tamed) {
            this.field_6011.method_12778(field_6322, (Object)((byte)(b | 4)));
        } else {
            this.field_6011.method_12778(field_6322, (Object)((byte)(b & 0xFFFFFFFB)));
        }
        this.method_5996(class_5134.field_23716).method_6192(100.0);
        this.method_5996(class_5134.field_23719).method_6192((double)0.15f);
        this.method_5996(class_5134.field_23721).method_6192(30.0);
        this.method_6033(50.0f);
    }

    private void setupAnimationStates() {
        if (this.method_37908().field_9236) {
            boolean isMoving;
            boolean isSleeping = this.getIsSleepingData();
            if (isSleeping) {
                if (!this.sleepAnimationState.method_41327()) {
                    this.startAnimation(AnimationName.SLEEP, this.sleepingMinDuration);
                }
            } else if (this.sleepAnimationState.method_41327()) {
                this.sleepAnimationState.method_41325();
            }
            class_243 velocity = this.method_18798();
            boolean bl = isMoving = velocity.field_1352 != 0.0 || velocity.field_1350 != 0.0;
            if (this.animationTimeout <= 0) {
                if (!this.getIsOpeningChestData()) {
                    if (!this.method_24345()) {
                        if (isMoving) {
                            if (!this.walkAnimationState.method_41327()) {
                                this.startAnimation(AnimationName.WALK);
                            }
                        } else if (!this.idleAnimationState.method_41327()) {
                            this.startAnimation(AnimationName.IDLE);
                        }
                    } else if (!this.sitAnimationState.method_41327()) {
                        this.startAnimation(AnimationName.SIT);
                    }
                    if (this.chestIsClose) {
                        this.startAnimation(AnimationName.MOUTH_CLOSE);
                        this.chestIsClose = false;
                    }
                } else if (this.getIsOpeningChestData() && !this.chestIsClose && !this.mouthOpenAnimationState.method_41327()) {
                    this.startAnimation(AnimationName.MOUTH_OPEN);
                    this.chestIsClose = true;
                }
            }
            if (this.animationTimeout > 0) {
                --this.animationTimeout;
            }
        }
        if (!this.method_37908().method_8608()) {
            ++this.eatingThingsCouter;
            if (this.eatingThingsCouter >= DEFAULT_EATING_COOLDOWN) {
                this.eatItemsOnGround();
                this.eatingThingsCouter = 0;
            }
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("sleepDurationCurrent", this.sleepDurationCurrent);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.sleepDurationCurrent = nbt.method_10550("sleepDurationCurrent");
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            if (this.getCanSleepData() && !this.getIsSleepingData() && this.method_35057() == null) {
                ++this.sleepingCheckCounter;
                if (this.sleepingCheckCounter > this.sleepingCheckCooldown) {
                    this.sleepingCheckCounter = 0;
                    if (this.field_5974.method_43058() < this.chanceToSleep) {
                        this.setIsSleepingData(true);
                        this.sleepDurationCurrent = 0;
                    }
                }
            }
            if (this.getIsSleepingData()) {
                ++this.sleepDurationCurrent;
                if (this.sleepDurationCurrent >= this.sleepingMinDuration) {
                    this.setIsSleepingData(false);
                    this.canSleepCounter = 0;
                    this.sleepDurationCurrent = 0;
                }
            }
            if (!this.getCanSleepData()) {
                ++this.canSleepCounter;
                if (this.canSleepCounter > this.canSleepCooldown) {
                    this.setCanSleepData(true);
                    this.canSleepCounter = 0;
                }
            }
        }
        this.setupAnimationStates();
        if (this.method_6032() <= 0.0f) {
            return;
        }
        if (!this.getCanSleepData()) {
            ++this.canSleepCounter;
            if (this.canSleepCounter > this.canSleepCooldown) {
                this.setCanSleepData(true);
                this.canSleepCounter = 0;
            }
        }
        if (this.isInCombat) {
            if (this.inCombatCounter <= this.inCombatCooldown) {
                ++this.inCombatCounter;
            }
            if (this.inCombatCounter > this.inCombatCooldown) {
                this.isInCombat = false;
            }
        }
        ++this.passiveHealingCounter;
        if (this.passiveHealingCounter >= PASSIVE_HEALING_COOLDOWN) {
            if (this.method_35057() == null && this.method_6181()) {
                this.method_6173(false);
            }
            this.passiveHealingCounter = 0;
            this.method_6033(this.method_6032() + this.passiveHealingAmount);
        }
        ++this.particleSpawnCounter;
        if (this.particleSpawnCounter >= DEFAULT_PARTICLE_SPAWN_COOLDOWN) {
            this.spawnParticlesAround();
            this.particleSpawnCounter = 0;
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            if (this.method_6181() && this.method_35057() == player) {
                ClientData.LAST_INTERACTED_MOB_ID = this.method_5628();
                this.chestIsClose = false;
                this.openMobChest(player);
                return class_1269.field_5812;
            }
            if (this.getIsSleepingData() && itemStack.method_31574(this.getTameFood())) {
                return class_1269.field_21466;
            }
            return class_1269.field_5811;
        }
        if (this.method_6181() && this.method_35057() == player) {
            ClientData.LAST_INTERACTED_MOB_ID = this.method_5628();
            this.setIsOpeningChestData(true);
            this.chestIsClose = false;
            this.animationTimeout = 1;
            this.openMobChest(player);
            return class_1269.field_5812;
        }
        if (this.getIsSleepingData() && itemStack.method_31574(this.getTameFood())) {
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            if (this.field_5974.method_43048(3) == 0) {
                this.method_6170(player);
                this.method_6173(true);
                this.setIsSleepingData(false);
                this.method_24346(false);
                this.animationTimeout = 1;
                this.method_37908().method_8421((class_1297)this, (byte)7);
                class_2540 buf = PacketByteBufs.create();
                buf.writeInt(this.method_5628());
                ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)WelcomeToMyWorld.A_LIVING_CHEST_JUMP, (class_2540)buf);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void openMobChest(class_1657 player) {
        class_1730 enderChestInventory = player.method_7274();
        player.method_17355((class_3908)new class_747((syncId, inventory, playerx) -> class_1707.method_19245((int)syncId, (class_1661)inventory, (class_1263)enderChestInventory), (class_2561)class_2561.method_43471((String)"container.enderchest")));
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972) == this.method_35057() && player.method_5715()) {
            this.method_24346(!this.method_24345());
            return false;
        }
        this.isInCombat = true;
        this.inCombatCounter = 0;
        if (this.getIsSleepingData()) {
            this.setIsSleepingData(false);
            this.animationTimeout = 1;
        }
        return super.method_5643(source, amount);
    }

    protected class_3414 method_5994() {
        if (this.field_5974.method_43048(3) == 0) {
            return class_3417.field_14922;
        }
        return this.field_5974.method_43058() > 50.0 ? SoundsManager.ENDERCHESTER_AMBIENT : SoundsManager.ENDERCHESTER_AMBIENT2;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SoundsManager.ENDERCHESTER_HURT;
    }

    protected class_3414 method_6002() {
        return SoundsManager.ENDERCHESTER_HURT;
    }

    protected float method_6107() {
        return 0.4f;
    }

    public void spawnParticlesAround() {
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            double x = this.method_23317();
            double y = this.method_23318() + (double)(this.method_17682() / 3.0f);
            double z = this.method_23321();
            for (int i = 0; i < 5; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double radius = 0.5;
                double offsetX = radius * Math.cos(angle);
                double offsetZ = radius * Math.sin(angle);
                world.method_8406(this.getParticleEffect(), x + offsetX, y, z + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public class_2394 getParticleEffect() {
        return this.particleEffect;
    }

    public class_1792 getTameFood() {
        return this.tameFood;
    }

    public void eatItemsOnGround() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.method_29504()) {
            return;
        }
        if (this.getIsSleepingData()) {
            return;
        }
        if (this.method_35057() == null) {
            return;
        }
        if (this.method_5682() == null) {
            return;
        }
        class_3222 player = this.method_5682().method_3760().method_14602(this.method_35057().method_5667());
        if (player == null) {
            return;
        }
        class_238 checkArea = new class_238(this.method_24515()).method_1014((double)EAT_AREA);
        List itemEntities = this.method_37908().method_8390(class_1542.class, checkArea, entity -> true);
        class_1277 enderChestInventory = this.getChest((class_1657)player);
        boolean isAdded = false;
        for (class_1542 itemEntity : itemEntities) {
            boolean added;
            class_1799 stack = itemEntity.method_6983();
            if (this.hateItems.contains(stack.method_7909()) || !(added = this.addItemToChest(enderChestInventory, stack))) continue;
            isAdded = true;
            itemEntity.method_31472();
        }
        if (isAdded) {
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(this.method_5628());
            this.startAnimation(AnimationName.EAT_ITEMS, 30);
            ServerPlayNetworking.send((class_3222)((class_3222)this.method_35057()), (class_2960)WelcomeToMyWorld.A_LIVING_CHEST_EAT_ANIMATION, (class_2540)buf);
            ServerPlayNetworking.send((class_3222)((class_3222)this.method_35057()), (class_2960)WelcomeToMyWorld.A_LIVING_CHEST_EATING_SOUND, (class_2540)PacketByteBufs.empty());
        }
    }

    public class_1277 getChest(class_1657 player) {
        return player.method_7274();
    }

    public boolean addItemToChest(class_1277 chest, class_1799 stack) {
        boolean newStack = false;
        for (int i = 0; i < chest.method_5439(); ++i) {
            class_1799 slotStack = chest.method_5438(i);
            if (slotStack.method_7960()) {
                chest.method_5447(i, stack);
                return true;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)stack)) continue;
            int transferAmount = Math.min(slotStack.method_7914() - slotStack.method_7947(), stack.method_7947());
            slotStack.method_7933(transferAmount);
            stack.method_7934(transferAmount);
            if (!stack.method_7960()) continue;
            return true;
        }
        return false;
    }

    public boolean method_6474(class_1429 other) {
        return false;
    }

    @Override
    public void startAnimation(AnimationName name) {
        AnimationName na = null;
        for (AnimationName n : this.animationHashMap.keySet()) {
            if (n.equals((Object)name)) {
                na = n;
                continue;
            }
            this.animationHashMap.get((Object)n).method_41325();
        }
        if (na != null) {
            this.animationHashMap.get((Object)na).method_41322(this.field_6012);
            this.animationTimeout = DEFAULT_ANIMATION_TIMEOUT;
        }
    }

    @Override
    public void startAnimation(AnimationName name, int timeout) {
        AnimationName na = null;
        for (AnimationName n : this.animationHashMap.keySet()) {
            if (n.equals((Object)name)) {
                na = n;
                continue;
            }
            this.animationHashMap.get((Object)n).method_41325();
        }
        if (na != null) {
            this.animationHashMap.get((Object)na).method_41322(this.field_6012);
            this.animationTimeout = timeout;
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    class SleepingNoMove
    extends class_1352 {
        private final Enderchester mob;

        public SleepingNoMove(Enderchester mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.mob.getIsSleepingData();
        }

        public void method_6269() {
            this.mob.method_5942().method_6340();
        }

        public boolean method_6266() {
            return this.mob.getIsSleepingData();
        }

        public void method_6268() {
            if (!this.mob.getIsSleepingData()) {
                return;
            }
            this.mob.method_5942().method_6340();
        }
    }

    class StopMovementGoalWhenOpeningChest
    extends class_1352 {
        private final Enderchester mob;

        public StopMovementGoalWhenOpeningChest(Enderchester mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return this.mob.getIsOpeningChestData();
        }

        public void method_6269() {
            this.mob.method_5942().method_6340();
        }

        public boolean method_6266() {
            return this.mob.getIsOpeningChestData();
        }

        public void method_6268() {
            this.mob.method_5942().method_6340();
        }
    }

    public class FleeFromNearbyPlayersGoal
    extends class_1352 {
        private final Enderchester mob;
        private final double fleeSpeed;
        private final float checkDistance;
        private class_1657 threateningEntity;
        private int cooldown;

        public FleeFromNearbyPlayersGoal(Enderchester mob, float checkDistance, double fleeSpeed) {
            this.mob = mob;
            this.checkDistance = checkDistance;
            this.fleeSpeed = fleeSpeed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.mob.getIsSleepingData() || this.mob.getIsOpeningChestData() || this.mob.method_35057() != null) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.threateningEntity = (class_1657)this.mob.method_37908().method_21726(class_1657.class, class_4051.method_36626().method_18418((double)this.checkDistance), (class_1309)this.mob, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), this.mob.method_5829().method_1014((double)this.checkDistance));
            if (this.threateningEntity == null) {
                return false;
            }
            if (this.threateningEntity.method_7325() || this.threateningEntity.method_7337()) {
                return false;
            }
            if (this.threateningEntity == null) {
                return false;
            }
            return !this.threateningEntity.equals((Object)this.mob) && (!this.mob.method_6181() || !this.threateningEntity.equals((Object)this.mob.method_35057()));
        }

        public void method_6269() {
            class_243 threatPos = this.threateningEntity.method_19538();
            class_243 mobPos = this.mob.method_19538();
            class_243 fleeDir = new class_243(mobPos.field_1352 - threatPos.field_1352, 0.0, mobPos.field_1350 - threatPos.field_1350).method_1029();
            class_243 targetPos = mobPos.method_1019(fleeDir.method_1021(25.0));
            this.mob.method_5942().method_6337(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, this.fleeSpeed);
            this.cooldown = 15;
        }

        public boolean method_6266() {
            if (this.mob.getIsSleepingData() || this.mob.getIsOpeningChestData() || this.mob.method_35057() != null) {
                return false;
            }
            boolean shouldContinue = !this.mob.method_5942().method_6357() && this.threateningEntity.method_5805() && (double)this.threateningEntity.method_5739((class_1297)this.mob) < (double)this.checkDistance * 1.5;
            this.mob.setCanSleepData(shouldContinue);
            this.mob.canSleepCounter = 0;
            this.mob.sleepingCheckCounter = 0;
            return shouldContinue;
        }

        public void method_6270() {
            this.threateningEntity = null;
            this.mob.method_5942().method_6340();
        }
    }
}

