/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.entities;

import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.AnimationName;
import com.trongthang.welcometomyworld.classes.StartAnimation;
import com.trongthang.welcometomyworld.client.ClientScheduler;
import com.trongthang.welcometomyworld.entities.Enderchester;
import com.trongthang.welcometomyworld.managers.SoundsManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1379;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_7923;

public class TheEnderChest
extends class_1308
implements StartAnimation {
    public static int totalTheEnderChest = 0;
    public static final int MAX_ENDER_CHEST = 12;
    ConcurrentHashMap<AnimationName, class_7094> animationHashMap = new ConcurrentHashMap();
    private static final class_2940<Boolean> CAN_DISAPPEAR = class_2945.method_12791(TheEnderChest.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_SCAM = class_2945.method_12791(TheEnderChest.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ATE_ENDER_EYES = class_2945.method_12791(TheEnderChest.class, (class_2941)class_2943.field_13327);
    private static final int WALK_CYCLE_DURATION_MS = 5380;
    private static final int[] FOOTSTEP_TIMINGS_MS = new int[]{1280, 4000};
    private int previousWalkPosition = -1;
    private static final int MOUNTH_OPEN_DURATION_MS = 8000;
    private static final int[] MOUTH_OPEN_TIMINGS_MS = new int[]{0, 330, 790, 1170, 1500, 1790, 2040, 2250, 2420, 2500, 2558};
    private final Set<Integer> portalPlayedFrames = new HashSet<Integer>();
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 mouthOpenAnimationState = new class_7094();
    public final class_7094 disappearAnimationState = new class_7094();
    public final class_7094 scamAnimationState = new class_7094();
    public final class_7094 eatItemsAnimationState = new class_7094();
    private boolean isDisappearStarting = false;
    public int animationTimeout = 0;
    public static final int DEFAULT_ANIMATION_TIMEOUT = 15;
    private int particleSpawnCounter;
    private boolean completeOpenMouthSound = false;
    private int healthDecreaseCooldown = 300;
    private int healthDecreaseCounter = 0;
    private int healthDecrease = 5;
    private int healthDisappear = 10;
    private double scamChance = 50.0;
    private int enderEyeScanCooldown = 40;
    private int enderEyesScanColldownCounter = 0;
    private int eyeOfEnderNeeded = WelcomeToMyWorld.random.nextInt(3, 6);
    private boolean isScammingDisappear = false;
    private static final int MAX_ATTEMPTS = 50;

    public TheEnderChest(class_1299<? extends class_1308> entityType, class_1937 world) {
        super(entityType, world);
        this.animationHashMap.put(AnimationName.IDLE, this.idleAnimationState);
        this.animationHashMap.put(AnimationName.MOUTH_OPEN, this.mouthOpenAnimationState);
        this.animationHashMap.put(AnimationName.DISAPPEAR, this.disappearAnimationState);
        this.animationHashMap.put(AnimationName.SCAM, this.scamAnimationState);
        this.animationHashMap.put(AnimationName.EAT_ITEMS, this.eatItemsAnimationState);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 100.0).method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23721, 0.0).method_26868(class_5134.field_23717, 0.0).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CAN_DISAPPEAR, (Object)false);
        this.field_6011.method_12784(IS_SCAM, (Object)false);
        this.field_6011.method_12784(ATE_ENDER_EYES, (Object)0);
    }

    protected void method_5959() {
        this.field_6201.method_35115().removeIf(g -> g.method_19058() instanceof class_1379 || g.method_19058() instanceof class_1394);
    }

    public void setAnimationStates() {
        if (this.method_37908().field_9236) {
            if (this.getIsScam()) {
                if (!this.scamAnimationState.method_41327()) {
                    this.startAnimation(AnimationName.SCAM, 400);
                }
                return;
            }
            if (this.getCanDisappear() && !this.isDisappearStarting) {
                if (!this.mouthOpenAnimationState.method_41327()) {
                    this.startAnimation(AnimationName.MOUTH_OPEN, 500);
                }
                this.isDisappearStarting = true;
                ClientScheduler.schedule(() -> this.startAnimation(AnimationName.DISAPPEAR, 20), 150);
                return;
            }
            if (!this.isDisappearStarting) {
                boolean isMoving;
                class_243 velocity = this.method_18798();
                boolean bl = isMoving = velocity.field_1352 != 0.0 || velocity.field_1350 != 0.0;
                if (this.animationTimeout <= 0 && !this.idleAnimationState.method_41327() && !isMoving) {
                    this.startAnimation(AnimationName.IDLE);
                }
            }
        }
        if (this.animationTimeout >= 0) {
            --this.animationTimeout;
        }
    }

    public void method_5773() {
        super.method_5773();
        ++this.enderEyesScanColldownCounter;
        if (this.enderEyesScanColldownCounter > this.enderEyeScanCooldown) {
            this.eatEnderEyesOnGround();
            this.enderEyesScanColldownCounter = 0;
        }
        if (!this.method_37908().field_9236) {
            if (this.getIsScam() && !this.isScammingDisappear) {
                Utils.addRunAfter(() -> {
                    Utils.playSound(this.method_37908(), this.method_24515(), class_3417.field_14879);
                    this.method_31472();
                }, 23);
                this.isScammingDisappear = true;
            }
            if (this.getAteEnderEye() >= this.eyeOfEnderNeeded && !this.getCanDisappear() && !this.getIsScam()) {
                if ((double)WelcomeToMyWorld.random.nextInt(0, 100) < this.scamChance && !this.isScammingDisappear) {
                    this.setIsScam(true);
                } else if (!this.getCanDisappear() && !this.getIsScam()) {
                    this.setCanDisappear(true);
                    List<class_1792> items = TheEnderChest.getRandomItem(WelcomeToMyWorld.random.nextInt(5, 25));
                    int startingTime = 51;
                    if (!items.isEmpty()) {
                        for (class_1792 item : items) {
                            Utils.addRunAfter(() -> TheEnderChest.shootItemUp(this.method_37908(), new class_243(this.method_23317(), this.method_23318(), this.method_23321()), item), startingTime += 3);
                        }
                    }
                }
            }
            if (this.method_6032() > (float)this.healthDisappear) {
                ++this.healthDecreaseCounter;
                if (this.healthDecreaseCounter > this.healthDecreaseCooldown) {
                    this.healthDecreaseCounter = 0;
                    this.method_6033(this.method_6032() - (float)this.healthDecrease);
                }
            } else if (this.method_6032() < (float)this.healthDisappear) {
                Utils.playSound(this.method_37908(), this.method_24515(), class_3417.field_14879);
                this.method_31472();
                return;
            }
        }
        this.setAnimationStates();
        if (!this.method_37908().field_9236 && this.getCanDisappear() && !this.isDisappearStarting) {
            this.isDisappearStarting = true;
            Utils.addRunAfter(() -> ((TheEnderChest)this).method_31472(), 200);
        }
        this.handleAnimationSounds();
        this.spawnParticlesAround();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    private void handleAnimationSounds() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        if (this.mouthOpenAnimationState.method_41327() && !this.completeOpenMouthSound) {
            this.handleSwitchSounds();
        }
    }

    private void handleWalkSounds() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        if (!this.mouthOpenAnimationState.method_41327()) {
            return;
        }
        long animTime = this.mouthOpenAnimationState.method_43687();
        int currentPos = (int)(animTime % 8000L);
        for (int timing : FOOTSTEP_TIMINGS_MS) {
            int timingInCycle = timing % 8000;
            if (this.previousWalkPosition == -1) continue;
            boolean normalCross = this.previousWalkPosition < timingInCycle && currentPos >= timingInCycle;
            boolean wrapAround = timingInCycle == 0 && this.previousWalkPosition > currentPos;
            class_2540 buf = PacketByteBufs.create();
            buf.method_10807(this.method_24515());
            buf.method_10812(SoundsManager.PORTALER_STEP.method_14833());
            if (!normalCross && !wrapAround) continue;
            ClientPlayNetworking.send((class_2960)WelcomeToMyWorld.SOUND_PACKET_ID, (class_2540)buf);
        }
        this.previousWalkPosition = currentPos;
    }

    private void handleSwitchSounds() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        if (!this.mouthOpenAnimationState.method_41327()) {
            return;
        }
        long animTime = this.mouthOpenAnimationState.method_43687();
        int currentPos = (int)(animTime % 8000L);
        for (int timing : MOUTH_OPEN_TIMINGS_MS) {
            boolean cycleWrap;
            int windowStart = timing - 25;
            int windowEnd = timing + 25;
            boolean inWindow = currentPos >= windowStart && currentPos <= windowEnd;
            boolean bl = cycleWrap = timing > 7975 && currentPos < timing - 8000 + 25;
            if (!inWindow && !cycleWrap || this.portalPlayedFrames.contains(timing)) continue;
            this.triggerMouthOpenSound(timing);
            this.portalPlayedFrames.add(timing);
        }
        if (currentPos > 7850) {
            this.portalPlayedFrames.clear();
        }
    }

    private void triggerMouthOpenSound(int timing) {
        class_2960 soundId;
        if (timing >= 2510 && timing <= 2558) {
            soundId = SoundsManager.THE_ENDER_CHEST_MOUTH_OPEN.method_14833();
            this.completeOpenMouthSound = true;
            if (this.method_37908().field_9236) {
                this.createSquarePillarEffect(20, 3.0f, -0.1f, 0.7f);
            }
        } else {
            soundId = SoundsManager.THE_ENDER_CHEST_SHAKE1.method_14833();
        }
        ClientPlayNetworking.send((class_2960)WelcomeToMyWorld.SOUND_PACKET_ID, (class_2540)PacketByteBufs.create().method_10807(this.method_24515()).method_10812(soundId));
    }

    public static void shootItemUp(class_1937 world, class_243 pos, class_1792 item) {
        if (world.field_9236) {
            return;
        }
        class_1799 stack = new class_1799((class_1935)item);
        class_1542 itemEntity = new class_1542(world, pos.field_1352, pos.field_1351, pos.field_1350, stack);
        class_5819 random = world.field_9229;
        double angle = random.method_43058() * Math.PI * 3.0;
        double horizontalSpeed = 0.08;
        double verticalSpeed = 0.79;
        class_243 velocity = new class_243(Math.cos(angle) * horizontalSpeed, verticalSpeed, Math.sin(angle) * horizontalSpeed);
        velocity = velocity.method_1031((random.method_43058() - 0.5) * 0.1, random.method_43058() * 0.1, (random.method_43058() - 0.5) * 0.1);
        itemEntity.method_18799(velocity);
        world.method_8649((class_1297)itemEntity);
    }

    public static List<class_1792> getRandomItem(int totalItems) {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        int registrySize = class_7923.field_41178.method_10204();
        if (registrySize == 0) {
            return items;
        }
        block0: for (int x = 0; x < totalItems; ++x) {
            for (int i = 0; i < 50; ++i) {
                int randomIndex = WelcomeToMyWorld.random.nextInt(registrySize);
                class_1792 item = (class_1792)class_7923.field_41178.method_10200(randomIndex);
                if (!TheEnderChest.isValidItem(item)) continue;
                items.add(item);
                continue block0;
            }
        }
        return items;
    }

    private static boolean isValidItem(class_1792 item) {
        return item != class_1802.field_8162 && !(item instanceof class_1826) && !TheEnderChest.isHiddenItem(item) && !(item instanceof class_1747);
    }

    private static boolean isHiddenItem(class_1792 item) {
        String namespace = class_7923.field_41178.method_10221((Object)item).method_12836();
        return namespace.equals("minecraft") && item instanceof class_1772;
    }

    public void spawnParticlesAround() {
        ++this.particleSpawnCounter;
        if (this.particleSpawnCounter >= Enderchester.DEFAULT_PARTICLE_SPAWN_COOLDOWN) {
            this.particleSpawnCounter = 0;
            class_1937 world = this.method_37908();
            if (world.field_9236) {
                double x = this.method_23317();
                double y = this.method_23318() + (double)(this.method_17682() / 3.0f);
                double z = this.method_23321();
                for (int i = 0; i < 5; ++i) {
                    double angle = Math.random() * 2.0 * Math.PI;
                    double radius = 0.8;
                    double offsetX = radius * Math.cos(angle);
                    double offsetZ = radius * Math.sin(angle);
                    world.method_8406((class_2394)class_2398.field_11214, x + offsetX, y, z + offsetZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void startAnimation(AnimationName name) {
        AnimationName na = null;
        for (AnimationName n : this.animationHashMap.keySet()) {
            if (n.equals((Object)name)) {
                na = n;
                continue;
            }
            this.animationHashMap.get((Object)n).method_41325();
        }
        if (na != null) {
            this.animationHashMap.get((Object)na).method_41322(this.field_6012);
            this.animationTimeout = 15;
        }
    }

    @Override
    public void startAnimation(AnimationName name, int timeout) {
        AnimationName na = null;
        for (AnimationName n : this.animationHashMap.keySet()) {
            if (n.equals((Object)name)) {
                na = n;
                continue;
            }
            this.animationHashMap.get((Object)n).method_41325();
        }
        if (na != null) {
            this.animationHashMap.get((Object)na).method_41322(this.field_6012);
            this.animationTimeout = timeout;
        }
    }

    public void eatEnderEyesOnGround() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.method_29504()) {
            return;
        }
        if (this.method_5682() == null) {
            return;
        }
        class_238 checkArea = new class_238(this.method_24515()).method_1014(1.0);
        List itemEntities = this.method_37908().method_8390(class_1542.class, checkArea, entity -> true);
        class_1542 itemEn = null;
        int totalEnderEyesEaten = this.getAteEnderEye();
        for (class_1542 itemEntity : itemEntities) {
            class_1799 stack = itemEntity.method_6983();
            if (stack.method_7909() == class_1802.field_8449 && totalEnderEyesEaten < this.eyeOfEnderNeeded) {
                ++totalEnderEyesEaten;
                itemEn = itemEntity;
                itemEntity.method_31472();
            }
            if (totalEnderEyesEaten < this.eyeOfEnderNeeded) continue;
            break;
        }
        this.setAteEnderEye(totalEnderEyesEaten);
        if (itemEn != null) {
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(this.method_5628());
            buf.method_10817((Enum)AnimationName.EAT_ITEMS);
            buf.writeInt(12);
            for (class_3222 p : this.method_37908().method_8503().method_3760().method_14571()) {
                if (!(p.method_5739((class_1297)this) < 64.0f)) continue;
                ServerPlayNetworking.send((class_3222)p, (class_2960)WelcomeToMyWorld.ANIMATION_PACKET, (class_2540)buf);
            }
            this.method_5783(class_3417.field_20614, 0.8f, 1.0f);
        }
    }

    private void createSquarePillarEffect(final int durationTicks, final float maxHeight, float yOffset, final float maxRadius) {
        if (!this.method_37908().method_8608()) {
            return;
        }
        final int[] currentTick = new int[]{0};
        final class_243 startPos = this.method_19538().method_1031(0.0, (double)yOffset, 0.0);
        Runnable effectTask = new Runnable(){

            @Override
            public void run() {
                if (currentTick[0] > durationTicks) {
                    return;
                }
                float progress = (float)currentTick[0] / (float)durationTicks;
                float currentHeight = maxHeight * progress;
                float currentRadius = maxRadius * progress;
                for (int side = 0; side < 4; ++side) {
                    for (int i = 0; i <= 8; ++i) {
                        double x = 0.0;
                        double z = 0.0;
                        switch (side) {
                            case 0: {
                                x = -currentRadius + 2.0f * currentRadius * (float)i / 10.0f;
                                z = currentRadius;
                                break;
                            }
                            case 1: {
                                x = currentRadius;
                                z = currentRadius - 2.0f * currentRadius * (float)i / 10.0f;
                                break;
                            }
                            case 2: {
                                x = currentRadius - 2.0f * currentRadius * (float)i / 10.0f;
                                z = -currentRadius;
                                break;
                            }
                            case 3: {
                                x = -currentRadius;
                                z = -currentRadius + 2.0f * currentRadius * (float)i / 10.0f;
                            }
                        }
                        class_243 particlePos = startPos.method_1031(x, (double)currentHeight, z);
                        TheEnderChest.this.spawnPillarParticle(particlePos);
                    }
                }
                currentTick[0] = currentTick[0] + 1;
                if (currentTick[0] <= durationTicks) {
                    ClientScheduler.schedule(this, 1);
                }
            }
        };
        ClientScheduler.schedule(effectTask, 0);
    }

    private void spawnPillarParticle(class_243 pos) {
        if (this.method_37908().field_9236) {
            this.method_37908().method_8406((class_2394)class_2398.field_11207, pos.field_1352, pos.field_1351, pos.field_1350, (double)((this.field_5974.method_43057() - 0.5f) * 0.1f), (double)0.1f, (double)((this.field_5974.method_43057() - 0.5f) * 0.1f));
        }
    }

    public boolean getCanDisappear() {
        return (Boolean)this.field_6011.method_12789(CAN_DISAPPEAR);
    }

    public void setCanDisappear(boolean canDisappear) {
        this.field_6011.method_12778(CAN_DISAPPEAR, (Object)canDisappear);
    }

    public boolean getIsScam() {
        return (Boolean)this.field_6011.method_12789(IS_SCAM);
    }

    public void setIsScam(boolean canDisappear) {
        this.field_6011.method_12778(IS_SCAM, (Object)canDisappear);
    }

    public int getAteEnderEye() {
        return (Integer)this.field_6011.method_12789(ATE_ENDER_EYES);
    }

    public void setAteEnderEye(int ateEnderEye) {
        this.field_6011.method_12778(ATE_ENDER_EYES, (Object)ateEnderEye);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("canDisappear", this.getCanDisappear());
        nbt.method_10556("isScam", this.getIsScam());
        nbt.method_10569("ateEnderEye", this.getAteEnderEye());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setCanDisappear(nbt.method_10577("canDisappear"));
        this.setIsScam(nbt.method_10577("isScam"));
        this.setAteEnderEye(nbt.method_10550("ateEnderEye"));
    }
}

