/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.features;

import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.PlayerData;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PunchingBlocksPenalties {
    List<class_2248> nonDamagingBlocks = List.of(class_2246.field_10491);

    public void handlePunchingBlock() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)WelcomeToMyWorld.PLAYER_BREAKING_BLOCK, (server, p, handler, buf, responseSender) -> {
            int x = buf.readInt();
            int y = buf.readInt();
            int z = buf.readInt();
            UUID playerUuid = buf.method_10790();
            server.execute(() -> {
                class_3222 player = server.method_3760().method_14602(playerUuid);
                if (player != null) {
                    class_2338 blockPos = new class_2338(x, y, z);
                    this.applyBlockDamage(server, player, blockPos);
                }
            });
        });
    }

    private void applyBlockDamage(MinecraftServer server, class_3222 player, class_2338 blockPos) {
        float hardness;
        class_1937 world = player.method_37908();
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_26215() || blockState.method_26204() == class_2246.field_10382) {
            return;
        }
        if (!this.nonDamagingBlocks.contains(blockState.method_26204()) && (hardness = blockState.method_26214((class_1922)world, blockPos)) > 0.0f) {
            float finalDamageIfHasSomethingOnHand;
            float damage = Utils.calculateDamageWithArmor(this.calculateDamage(hardness), (class_1309)player);
            float f = player.method_6047().method_7960() ? damage : (finalDamageIfHasSomethingOnHand = !player.method_6047().method_7951(blockState) ? damage / 2.0f : 0.0f);
            if (finalDamageIfHasSomethingOnHand > 20.0f) {
                finalDamageIfHasSomethingOnHand = 20.0f;
            }
            if ((double)finalDamageIfHasSomethingOnHand > 1.1) {
                player.method_5643(player.method_37908().method_48963().method_48830(), finalDamageIfHasSomethingOnHand);
                PlayerData p = WelcomeToMyWorld.dataHandler.playerDataMap.get(player.method_5667());
                if (!p.firstPunchingBlocksDamage) {
                    Utils.grantAdvancement(player, "first_punching_blocks_damage");
                    p.firstPunchingBlocksDamage = true;
                }
                if (player.method_6032() <= 0.0f && !p.firstPunchingBlocksDie) {
                    Utils.grantAdvancement(player, "first_punching_blocks_die");
                    p.firstPunchingBlocksDie = true;
                }
            }
        }
    }

    public float calculateDamage(float hardness) {
        double damage = 1.0 + 2.5 * Math.log(hardness + 1.0f);
        return (float)Math.min(damage, 10.0);
    }
}

