/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.features;

import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.MonsterSpawn;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class SpawnMonstersAtNight {
    private static final int SPAWN_DISTANCE = 64;
    private static int MAX_MONSTERS_FOR_EACH_PLAYER = 15;
    private static double chanceToHappen = 70.0;
    private static int monsterWillIncreasePerDay = 10;
    private static int increaseMonsterByDay = 1;
    private static int eachPlayerIncreaseMonster = 10;
    private static int monsterDespawnAfterTick = 6000;
    public static final int stopSpawningDay = 269;
    private static List<MonsterSpawn> monsters = List.of(new MonsterSpawn("minecraft:zombie", 0), new MonsterSpawn("minecraft:skeleton", 2), new MonsterSpawn("minecraft:creeper", 4));

    public static void spawnMonsters(class_3218 world, int currentDay) {
        if (currentDay <= 0 || currentDay >= 269) {
            return;
        }
        if ((double)WelcomeToMyWorld.random.nextInt(0, 100) > chanceToHappen) {
            return;
        }
        List players = world.method_18456();
        int counter = 0;
        int totalMonstersWillSpawn = currentDay / monsterWillIncreasePerDay * increaseMonsterByDay + players.size() * eachPlayerIncreaseMonster;
        int monsterWillSpawnForEachPlayer = totalMonstersWillSpawn / players.size();
        for (class_3222 player : players) {
            for (int y = 0; y <= monsterWillSpawnForEachPlayer; ++y) {
                MonsterSpawn mon;
                do {
                    mon = monsters.get(WelcomeToMyWorld.random.nextInt(0, monsters.size()));
                } while (mon.data > currentDay);
                class_2338 safePos = Utils.findSafeSpawnPositionAroundTheCenterPos(world, player.method_19538(), 64);
                class_1297 entity = safePos != null ? Utils.spawnMob((class_1937)world, safePos, mon.id) : null;
                if (entity == null) {
                    return;
                }
                ((class_1308)entity).method_5980((class_1309)player);
                Utils.addRunAfter(() -> Utils.discardEntity(world, entity), monsterDespawnAfterTick);
                if (++counter >= MAX_MONSTERS_FOR_EACH_PLAYER) break;
            }
            counter = 0;
        }
    }
}

