/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.mixin;

import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.managers.BlocksManager;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4970.class})
public class AbstractBlockMixinTick {
    private static final int MIN_ADD_TIME = 1;
    private static final int SCHEDULE_DELAY_TIME = 20;
    private static final int RUSTY_IRON_BLOCK_TIME = 240;
    private static final int PLANKS_LOGS_TURN_TO_BURNING_BLOCK_TIME = 80;
    private static final ConcurrentHashMap<class_2338, Integer> blockTurnIntoCounter = new ConcurrentHashMap();

    @Inject(method={"scheduledTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void scheduledTick(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
        this.scheduledTickMethod(state, world, pos);
    }

    @Inject(method={"onStateReplaced"}, at={@At(value="HEAD")})
    private void onStateReplaced(class_2680 oldState, class_1937 world, class_2338 pos, class_2680 newState, boolean moved, CallbackInfo ci) {
        this.stateAddAndRemove(class_3481.field_15475, newState, oldState, world, pos);
        this.stateAddAndRemove(class_3481.field_15471, newState, oldState, world, pos);
        if (newState.method_27852(class_2246.field_10036)) {
            class_2338 burningPos = Utils.checkFireDirection(newState, pos);
            if (burningPos == null) {
                return;
            }
            class_2680 currentBurningState = world.method_8320(burningPos);
            if (!blockTurnIntoCounter.containsKey(burningPos)) {
                // empty if block
            }
            if (currentBurningState.method_26164(class_3481.field_15471) || currentBurningState.method_26164(class_3481.field_15475)) {
                world.method_39279(burningPos, currentBurningState.method_26204(), 20);
            }
        }
    }

    @Deprecated
    public void onBlockAdded(class_2680 newState, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
    }

    private void scheduledTickMethod(class_2680 state, class_3218 world, class_2338 pos) {
        if (state.method_26164(class_3481.field_15471) || state.method_26164(class_3481.field_15475)) {
            boolean isBurning = Utils.isFireBurningAtTheBlock((class_1937)world, pos);
            if (!isBurning) {
                blockTurnIntoCounter.remove(pos);
            } else {
                blockTurnIntoCounter.putIfAbsent(pos, 0);
                int counter = blockTurnIntoCounter.get(pos);
                if ((counter += WelcomeToMyWorld.random.nextInt(1, 20)) > 80) {
                    if (world.method_8503() != null) {
                        Utils.spawnBlockBreakParticles(world.method_8503().method_30002(), pos, new class_2388(class_2398.field_11217, state.method_26204().method_9564()));
                    }
                    world.method_8501(pos, BlocksManager.BURNING_PLANK.method_9564());
                    blockTurnIntoCounter.remove(pos);
                }
                blockTurnIntoCounter.put(pos, counter);
                world.method_39279(pos, state.method_26204(), 20);
            }
        }
    }

    private void stateAddAndRemove(class_6862 tag, class_2680 newState, class_2680 oldState, class_1937 world, class_2338 pos) {
        if (newState.method_26164(tag)) {
            world.method_39279(pos, newState.method_26204(), 20);
        }
        if (oldState.method_26164(tag)) {
            blockTurnIntoCounter.remove(pos);
        }
    }

    private void stateAddAndRemove(class_2248 checkBlock, class_2680 newState, class_2680 oldState, class_1937 world, class_2338 pos) {
        if (newState.method_27852(checkBlock)) {
            world.method_39279(pos, newState.method_26204(), 20);
        }
        if (oldState.method_27852(checkBlock)) {
            blockTurnIntoCounter.remove(pos);
        }
    }
}

