/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.PlayerData;
import com.trongthang.welcometomyworld.classes.PlayerStatsData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class DataHandler {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2338.class, (Object)new BlockPosAdapter()).registerTypeAdapter(class_2680.class, (Object)new BlockStateAdapter()).registerTypeAdapter(Path.class, (Object)new PathAdapter()).setPrettyPrinting().disableHtmlEscaping().create();
    public Path playerDataSavePath;
    public static final Type PLAYER_DATA_TYPE = new TypeToken<ConcurrentHashMap<UUID, PlayerData>>(){}.getType();
    public ConcurrentHashMap<UUID, PlayerData> playerDataMap = new ConcurrentHashMap();
    public Path playerStatsDataSavePath;
    public static final Type PLAYER_STATS_DATA_TYPE = new TypeToken<ConcurrentHashMap<UUID, PlayerStatsData>>(){}.getType();
    public ConcurrentHashMap<UUID, PlayerStatsData> playerStatsData = new ConcurrentHashMap();
    public Path blocksPlacedByMobs;
    public static final Type BLOCKS_PLACED_BY_MOBS_DATA_TYPE = new TypeToken<ConcurrentHashMap<class_2338, Integer>>(){}.getType();
    public ConcurrentHashMap<class_2338, Integer> blocksPlacedByMobWillRemove = new ConcurrentHashMap();
    public Path blocksBrokenByMobs;
    public static final Type BLOCKS_BROKEN_BY_MOBS_DATA_TYPE = new TypeToken<ConcurrentHashMap<class_2338, class_2680>>(){}.getType();
    public ConcurrentHashMap<class_2338, class_2680> blocksBrokenByMobWillRestore = new ConcurrentHashMap();

    public void initializeWorldData(MinecraftServer server) {
        this.playerDataSavePath = server.method_27050(class_5218.field_24188).resolve("data/welcometomyworld/playerdata.json");
        this.blocksPlacedByMobs = server.method_27050(class_5218.field_24188).resolve("data/welcometomyworld/blocksPlacedByMobs.json");
        this.playerStatsDataSavePath = server.method_27050(class_5218.field_24188).resolve("data/welcometomyworld/playerStatsData.json");
        this.playerDataMap.clear();
        this.playerStatsData.clear();
        this.blocksPlacedByMobWillRemove.clear();
        this.loadPlayerData();
        this.loadPlayerStatsData();
        this.loadBlocksPlacedByMobsData();
        this.findAndAddAlreadyExistPlayers(server);
    }

    public void saveData(MinecraftServer server) {
        if (this.playerDataSavePath == null) {
            this.playerDataSavePath = server.method_27050(class_5218.field_24188).resolve("data/welcometomyworld/playerdata.json");
        }
        this.savePlayerData();
        this.savePlayerStatsData();
        this.saveBlocksPlacedByMobsData();
        this.playerDataMap.clear();
        this.playerStatsData.clear();
        this.blocksPlacedByMobWillRemove.clear();
        this.blocksBrokenByMobWillRestore.clear();
    }

    public void findAndAddAlreadyExistPlayers(MinecraftServer server) {
        Path playerdataPath = server.method_27050(class_5218.field_24182);
        if (!Files.exists(playerdataPath, new LinkOption[0]) || !Files.isDirectory(playerdataPath, new LinkOption[0])) {
            WelcomeToMyWorld.LOGGER.warn("Playerdata directory does not exist: {}", (Object)playerdataPath);
            return;
        }
        try {
            Files.list(playerdataPath).filter(path -> path.toString().endsWith(".dat")).forEach(path -> {
                String fileName = path.getFileName().toString();
                try {
                    UUID uuid = UUID.fromString(fileName.substring(0, fileName.length() - 4));
                    if (!this.playerDataMap.containsKey(uuid)) {
                        this.playerDataMap.put(uuid, PlayerData.CreateExistPlayer());
                    }
                }
                catch (IllegalArgumentException e) {
                    WelcomeToMyWorld.LOGGER.warn("Invalid UUID found in playerdata file name: {}", (Object)fileName);
                }
            });
        }
        catch (IOException e) {
            WelcomeToMyWorld.LOGGER.error("Failed to read playerdata directory: {}", (Object)playerdataPath, (Object)e);
        }
    }

    public void loadPlayerData() {
        WelcomeToMyWorld.LOGGER.info("Loading player data from: {}", (Object)this.playerDataSavePath);
        if (Files.exists(this.playerDataSavePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.playerDataSavePath);){
                ConcurrentHashMap loadedData = (ConcurrentHashMap)GSON.fromJson((Reader)reader, PLAYER_DATA_TYPE);
                if (loadedData != null) {
                    this.playerDataMap.putAll(loadedData);
                }
            }
            catch (IOException e) {
                WelcomeToMyWorld.LOGGER.error("Failed to load player data", (Throwable)e);
            }
        }
    }

    public void savePlayerData() {
        WelcomeToMyWorld.LOGGER.info("Saving player data to: {}", (Object)this.playerDataSavePath);
        try {
            Files.createDirectories(this.playerDataSavePath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.playerDataSavePath, new OpenOption[0]);){
                GSON.toJson(this.playerDataMap, PLAYER_DATA_TYPE, (Appendable)writer);
            }
            WelcomeToMyWorld.LOGGER.info("Saved {} player entries to data file.", (Object)this.playerDataMap.size());
        }
        catch (IOException e) {
            WelcomeToMyWorld.LOGGER.error("Failed to save player data", (Throwable)e);
        }
    }

    public void loadPlayerStatsData() {
        WelcomeToMyWorld.LOGGER.info("Loading player stats data from: {}", (Object)this.playerStatsDataSavePath);
        if (Files.exists(this.playerStatsDataSavePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.playerStatsDataSavePath);){
                ConcurrentHashMap loadedData = (ConcurrentHashMap)GSON.fromJson((Reader)reader, PLAYER_STATS_DATA_TYPE);
                if (loadedData != null) {
                    this.playerStatsData.putAll(loadedData);
                }
            }
            catch (IOException e) {
                WelcomeToMyWorld.LOGGER.error("Failed to load player stats data", (Throwable)e);
            }
        }
    }

    public void savePlayerStatsData() {
        WelcomeToMyWorld.LOGGER.info("Saving player stats data to: {}", (Object)this.playerStatsDataSavePath);
        try {
            Files.createDirectories(this.playerStatsDataSavePath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.playerStatsDataSavePath, new OpenOption[0]);){
                GSON.toJson(this.playerStatsData, PLAYER_DATA_TYPE, (Appendable)writer);
            }
            WelcomeToMyWorld.LOGGER.info("Saved {} player stats entries to data file.", (Object)this.playerStatsData.size());
        }
        catch (IOException e) {
            WelcomeToMyWorld.LOGGER.error("Failed to save player data", (Throwable)e);
        }
    }

    public void loadBlocksPlacedByMobsData() {
        WelcomeToMyWorld.LOGGER.info("Loading blocks placed by mobs data from: {}", (Object)this.blocksPlacedByMobs);
        if (Files.exists(this.blocksPlacedByMobs, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.blocksPlacedByMobs);){
                ConcurrentHashMap loadedData = (ConcurrentHashMap)GSON.fromJson((Reader)reader, BLOCKS_PLACED_BY_MOBS_DATA_TYPE);
                if (loadedData != null) {
                    this.blocksPlacedByMobWillRemove.putAll(loadedData);
                }
            }
            catch (IOException e) {
                WelcomeToMyWorld.LOGGER.error("Failed to load blocks placed by mobs data", (Throwable)e);
            }
        }
    }

    public void saveBlocksPlacedByMobsData() {
        WelcomeToMyWorld.LOGGER.info("Saving blocks placed by mobs data to: {}", (Object)this.blocksPlacedByMobs);
        try {
            Files.createDirectories(this.blocksPlacedByMobs.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.blocksPlacedByMobs, new OpenOption[0]);){
                GSON.toJson(this.blocksPlacedByMobWillRemove, BLOCKS_PLACED_BY_MOBS_DATA_TYPE, (Appendable)writer);
            }
            WelcomeToMyWorld.LOGGER.info("Saved {} blocks placed by mobs entries to data file.", (Object)this.blocksPlacedByMobWillRemove.size());
        }
        catch (IOException e) {
            WelcomeToMyWorld.LOGGER.error("Failed to save blocks placed by mobs data", (Throwable)e);
        }
    }

    public static class BlockPosAdapter
    implements JsonSerializer<class_2338>,
    JsonDeserializer<class_2338> {
        public JsonElement serialize(class_2338 src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("x", (Number)src.method_10263());
            obj.addProperty("y", (Number)src.method_10264());
            obj.addProperty("z", (Number)src.method_10260());
            return obj;
        }

        public class_2338 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                return new class_2338(obj.get("x").getAsInt(), obj.get("y").getAsInt(), obj.get("z").getAsInt());
            }
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                String blockPosStr = json.getAsString();
                try {
                    String[] parts = blockPosStr.replace("BlockPos{", "").replace("}", "").split(", ");
                    int x = Integer.parseInt(parts[0].split("=")[1]);
                    int y = Integer.parseInt(parts[1].split("=")[1]);
                    int z = Integer.parseInt(parts[2].split("=")[1]);
                    return new class_2338(x, y, z);
                }
                catch (Exception e) {
                    throw new JsonParseException("Invalid BlockPos format: " + blockPosStr, (Throwable)e);
                }
            }
            throw new JsonParseException("Expected a JSON object or string for BlockPos, but got: " + json);
        }
    }

    public static class BlockStateAdapter
    implements JsonSerializer<class_2680>,
    JsonDeserializer<class_2680> {
        public JsonElement serialize(class_2680 src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)class_2248.field_10651.method_10206((Object)src));
        }

        public class_2680 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            int stateId = json.getAsInt();
            return (class_2680)class_2248.field_10651.method_10200(stateId);
        }
    }

    public static class PathAdapter
    implements JsonSerializer<Path>,
    JsonDeserializer<Path> {
        public JsonElement serialize(Path src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        public Path deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Path.of(json.getAsString(), new String[0]);
        }
    }
}

