/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.Utilities;

import com.trongthang.welcometomyworld.GlobalVariables;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.classes.AnimationName;
import com.trongthang.welcometomyworld.classes.CustomPositionedSound;
import com.trongthang.welcometomyworld.classes.RunAfter;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class Utils {
    public static final Utils UTILS = new Utils();
    static ConcurrentHashMap<UUID, RunAfter> runnableList = new ConcurrentHashMap();

    public static void grantAdvancement(class_3222 player, String achievement) {
        class_167 progress;
        String advancementId = "welcometomyworld:" + achievement;
        class_161 advancement = player.method_5682().method_3851().method_12896(new class_2960(advancementId));
        if (advancement != null && !(progress = player.method_14236().method_12882(advancement)).method_740()) {
            for (String criterion : progress.method_731()) {
                player.method_14236().method_12878(advancement, criterion);
            }
        }
    }

    public void sendTextAfter(class_3222 player, String text) {
        class_5250 message = class_2561.method_43470((String)"").method_27694(style -> style.method_10977(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"? Unknown:").method_27694(style -> style.method_10977(class_124.field_1054)).method_27694(style -> style.method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)(" " + text)).method_27694(style -> style.method_10977(class_124.field_1068)));
        player.method_43496((class_2561)message);
        ServerPlayNetworking.send((class_3222)player, (class_2960)WelcomeToMyWorld.PLAY_BLOCK_LEVER_CLICK, (class_2540)PacketByteBufs.empty());
    }

    public void sendTextAfter(class_3222 player, String text, int ticks) {
        Utils.addRunAfter(() -> {
            class_3222 currentPlayer = player.method_5682().method_3760().method_14602(player.method_5667());
            if (currentPlayer == null) {
                return;
            }
            class_5250 message = class_2561.method_43470((String)"").method_27694(style -> style.method_10977(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"? Unknown:").method_27694(style -> style.method_10977(class_124.field_1054)).method_27694(style -> style.method_10982(Boolean.valueOf(true)))).method_10852((class_2561)class_2561.method_43470((String)(" " + text)).method_27694(style -> style.method_10977(class_124.field_1068)));
            currentPlayer.method_43496((class_2561)message);
            ServerPlayNetworking.send((class_3222)player, (class_2960)WelcomeToMyWorld.PLAY_BLOCK_LEVER_CLICK, (class_2540)PacketByteBufs.empty());
        }, ticks);
    }

    public static void spawnCircleParticles(class_3222 player) {
        int particleCount = 30;
        double radius = 2.0;
        double yOffset = -2.0;
        class_3218 world = player.method_51469();
        class_243 playerPos = player.method_19538();
        double centerX = playerPos.field_1352;
        double centerY = playerPos.field_1351 + yOffset;
        double centerZ = playerPos.field_1350;
        int i = 0;
        while (i < particleCount) {
            int finalI = i++;
            Utils.addRunAfter(() -> {
                double angle = Math.PI * 2 * (double)finalI / (double)particleCount;
                double x = centerX + radius * Math.cos(angle);
                double z = centerZ + radius * Math.sin(angle);
                world.method_14199((class_2394)class_2398.field_11214, x, centerY, z, 1, 0.0, 0.0, 0.0, 0.0);
            }, 2);
        }
    }

    public static void addRunAfter(Runnable runFunction, int afterTicks) {
        UUID taskId = UUID.randomUUID();
        runnableList.put(taskId, new RunAfter(runFunction, afterTicks));
    }

    public static void onServerTick(MinecraftServer server) {
        for (UUID key : runnableList.keySet()) {
            RunAfter runTask = runnableList.get(key);
            --runTask.runAfterInTick;
            if (runTask.runAfterInTick > 0) continue;
            runTask.functionToRun.run();
            runnableList.remove(key);
        }
    }

    public static void playSound(class_3218 serverWorld, class_2338 pos, class_3414 soundEvent) {
        serverWorld.method_8396(null, pos, soundEvent, class_3419.field_15251, 0.8f, 1.0f);
    }

    public static void playSound(class_3218 serverWorld, class_2338 pos, class_3414 soundEvent, float volume, float pitch) {
        serverWorld.method_8396(null, pos, soundEvent, class_3419.field_15251, volume, pitch);
    }

    public static void playSound(class_1937 world, class_2338 pos, class_3414 soundEvent) {
        world.method_8396(null, pos, soundEvent, class_3419.field_15251, 1.0f, 1.0f);
    }

    public static void spawnParticles(class_3218 serverWorld, class_2338 pos, class_2400 particle) {
        for (int i = 0; i < 10; ++i) {
            double offsetX = (serverWorld.method_8409().method_43058() - 0.5) * 2.0;
            double offsetY = serverWorld.method_8409().method_43058() * 2.0;
            double offsetZ = (serverWorld.method_8409().method_43058() - 0.5) * 2.0;
            serverWorld.method_14199((class_2394)particle, (double)pos.method_10263() + offsetX, (double)pos.method_10264() + offsetY, (double)pos.method_10260() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnBlockBreakParticles(class_3218 world, class_2338 pos, class_2388 particle) {
        world.method_14199((class_2394)particle, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 20, 0.5, 0.5, 0.5, 0.1);
    }

    public static void SpawnItem(class_3218 serverWorld, class_243 pos, class_1799 itemStack) {
        serverWorld.method_8649((class_1297)new class_1542((class_1937)serverWorld, pos.method_10216(), pos.method_10214(), pos.method_10215(), itemStack));
    }

    public static void summonLightning(class_2338 pos, class_3218 world, boolean cosmetic) {
        class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)world);
        lightning.method_24203((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        lightning.method_29498(cosmetic);
        world.method_8649((class_1297)lightning);
    }

    public static void giveEffect(class_1309 entity, class_1291 effect, int timeInTick) {
        class_1293 currentEffect = entity.method_6112(effect);
        if (currentEffect != null) {
            int newAmplifier = Math.min(currentEffect.method_5578() + 1, 24);
            entity.method_6092(new class_1293(effect, currentEffect.method_5584(), newAmplifier));
        } else {
            entity.method_6092(new class_1293(effect, timeInTick, 0));
        }
    }

    public static class_1297 spawnMob(class_1937 world, class_2338 blockPos, String mobId) {
        if (blockPos == null) {
            return null;
        }
        class_2960 mobIdentifier = new class_2960(mobId.toLowerCase());
        class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(mobIdentifier);
        class_1297 entity = null;
        if (entityType != null) {
            entity = entityType.method_5883(world);
            if (entity instanceof class_1308) {
                class_1308 mobEntity = (class_1308)entity;
                mobEntity.method_5808((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, world.field_9229.method_43057() * 360.0f, 0.0f);
                world.method_8649((class_1297)mobEntity);
            } else {
                WelcomeToMyWorld.LOGGER.info("Entity type " + mobId + " not found. Check if mod ID or entity ID is correct.");
            }
        }
        return entity;
    }

    public static class_2338 findSafeSpawnPositionAroundTheCenterPos(class_3218 world, class_243 centerPos, int spawnDistance) {
        int maxTries = 15;
        for (int i = 0; i < maxTries; ++i) {
            int z;
            int y;
            double angle = WelcomeToMyWorld.random.nextDouble() * 2.0 * Math.PI;
            double distance = (double)spawnDistance + WelcomeToMyWorld.random.nextDouble() * 10.0;
            int x = (int)(centerPos.field_1352 + Math.cos(angle) * distance);
            class_2338 potentialPos = new class_2338(x, y = world.method_8624(class_2902.class_2903.field_13202, x, z = (int)(centerPos.field_1350 + Math.sin(angle) * distance)), z);
            if (!Utils.isSafeSpawn(world, potentialPos)) continue;
            return potentialPos;
        }
        return null;
    }

    public static boolean isSafeSpawn(class_3218 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074()) && world.method_8320(pos).method_26215() && world.method_8320(pos.method_10084()).method_26215();
    }

    public static void applyEffectForMobs(class_1309 mob, int howManyEffects, int durationInTicks) {
        HashSet<class_1291> selectedEffects = new HashSet<class_1291>();
        for (int x = 0; x < howManyEffects; ++x) {
            class_1291 randomEffect = GlobalVariables.POSSIBLE_EFFECTS_FOR_MOBS.get(WelcomeToMyWorld.random.nextInt(GlobalVariables.POSSIBLE_EFFECTS_FOR_MOBS.size()));
            selectedEffects.add(randomEffect);
        }
        for (class_1291 effect : selectedEffects) {
            class_1293 currentEffect = mob.method_6112(effect);
            if (currentEffect != null) {
                int newAmplifier = Math.min(currentEffect.method_5578() + 1, 24);
                mob.method_6092(new class_1293(effect, currentEffect.method_5584(), newAmplifier));
                continue;
            }
            mob.method_6092(new class_1293(effect, durationInTicks, 0));
        }
    }

    public static boolean isPlayerStandingOnBlock(class_1309 entity) {
        class_1937 world = entity.method_37908();
        class_238 playerBox = entity.method_5829();
        double checkHeight = 0.1;
        class_238 checkBox = playerBox.method_989(0.0, -checkHeight, 0.0);
        int minX = (int)Math.floor(checkBox.field_1323);
        int minY = (int)Math.floor(checkBox.field_1322);
        int minZ = (int)Math.floor(checkBox.field_1321);
        int maxX = (int)Math.floor(checkBox.field_1320);
        int maxY = (int)Math.floor(checkBox.field_1325);
        int maxZ = (int)Math.floor(checkBox.field_1324);
        for (class_2338 pos : class_2338.method_10097((class_2338)new class_2338(minX, minY, minZ), (class_2338)new class_2338(maxX, maxY, maxZ))) {
            class_2680 blockState = world.method_8320(pos);
            if (blockState.method_26215()) continue;
            return true;
        }
        return false;
    }

    public static float calculateDamageWithArmor(float initialDamage, class_1309 entity) {
        double armor = entity.method_26825(class_5134.field_23724);
        double toughness = entity.method_26825(class_5134.field_23725);
        float reductionFactor = (float)(armor / (5.0 + armor + toughness / 2.0));
        return initialDamage * (1.0f - reductionFactor);
    }

    public static class_2338 checkFireDirection(class_2680 fireBlock, class_2338 pos) {
        if (fireBlock.method_27852(class_2246.field_10036)) {
            boolean isEastBurning = (Boolean)fireBlock.method_11654((class_2769)class_2741.field_12487);
            boolean isWestBurning = (Boolean)fireBlock.method_11654((class_2769)class_2741.field_12527);
            boolean isNorthBurning = (Boolean)fireBlock.method_11654((class_2769)class_2741.field_12489);
            boolean isSouthBurning = (Boolean)fireBlock.method_11654((class_2769)class_2741.field_12540);
            boolean isUpBurning = (Boolean)fireBlock.method_11654((class_2769)class_2741.field_12519);
            class_2338 checkPos = null;
            if (isEastBurning) {
                checkPos = pos.method_10078();
            } else if (isWestBurning) {
                checkPos = pos.method_10067();
            } else if (isNorthBurning) {
                checkPos = pos.method_10095();
            } else if (isSouthBurning) {
                checkPos = pos.method_10072();
            } else if (isUpBurning) {
                checkPos = pos.method_10084();
            }
            return checkPos;
        }
        return null;
    }

    public static boolean isFireBurningAtTheBlock(class_1937 world, class_2338 pos) {
        Object block = null;
        List<class_2680> directions = List.of(world.method_8320(pos.method_10078()), world.method_8320(pos.method_10067()), world.method_8320(pos.method_10072()), world.method_8320(pos.method_10095()), world.method_8320(pos.method_10084()));
        for (class_2680 s : directions) {
            if (!s.method_27852(class_2246.field_10036) || Utils.checkFireDirection(s, pos) == null) continue;
            return true;
        }
        return false;
    }

    public static void discardEntity(class_3218 world, class_1297 entity) {
        class_1923 chunkPos = new class_1923(entity.method_24515());
        if (!world.method_8393(chunkPos.field_9181, chunkPos.field_9180)) {
            return;
        }
        entity.method_31472();
    }

    public static void sendAnimationPacket(class_1937 world, class_1309 entity, AnimationName animation, int timeout) {
        for (class_3222 player : ((class_3218)world).method_18456()) {
            if (!player.method_6057((class_1297)entity)) continue;
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(entity.method_5628());
            buf.method_10817((Enum)animation);
            buf.writeInt(timeout);
            ServerPlayNetworking.send((class_3222)player, (class_2960)WelcomeToMyWorld.ANIMATION_PACKET, (class_2540)buf);
        }
    }

    public static void sendSoundPacket(class_3414 sound, class_2338 pos) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble((double)pos.method_10263()).writeDouble((double)pos.method_10264()).writeDouble((double)pos.method_10260());
        buf.method_10812(sound.method_14833());
        ClientPlayNetworking.send((class_2960)WelcomeToMyWorld.SOUND_PACKET_ID, (class_2540)buf);
    }

    public static void playClientSound(class_2338 pos, class_3414 sound, int maxDistance) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_243 playerPos = client.field_1724.method_19538();
        double distance = playerPos.method_1022(new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
        if (distance <= (double)maxDistance) {
            float volume = Math.max(0.1f, 1.0f - (float)(distance / (double)maxDistance));
            CustomPositionedSound soundInstance = new CustomPositionedSound(sound, pos, class_3419.field_15245, volume, 1.0f);
            client.method_1483().method_4873((class_1113)soundInstance);
        }
    }
}

