/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.features;

import com.trongthang.welcometomyworld.GlobalConfig;
import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import com.trongthang.welcometomyworld.features.SpawnMonstersAtNight;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class DayAndNightCounterAnimationHandler {
    private static final String NIGHT_PREFIX = "Nighttime is coming... ";
    public int currentDay = 0;
    private static final long TICKS_IN_DAY = 24000L;
    private int checkInterval = 40;
    private int counter = 0;
    private String animationText = "";
    private int currentCharIndex = 0;
    private boolean isAnimatingDay = false;
    private boolean isAnimatingNight = false;
    private boolean dayAnimationComplete = false;
    private boolean nightAnimationComplete = false;
    private int tickRandomBound = 27;
    private int tickRandomMin = 12;
    private int delayTick = 0;
    private int currentTick = 0;
    Random rand = new Random();

    public void resetFields() {
        this.delayTick = 0;
        this.currentTick = 0;
        this.counter = 0;
        this.currentDay = 0;
        this.currentCharIndex = 0;
    }

    public void onServerTick(class_3222 player) {
        class_3218 world = player.method_51469();
        if (this.isAnimatingDay || this.isAnimatingNight) {
            ++this.currentTick;
            if (this.currentTick > this.delayTick) {
                if (this.isAnimatingDay) {
                    if (this.currentCharIndex < this.animationText.length()) {
                        String textToSend = this.animationText.substring(0, this.currentCharIndex + 1);
                        this.sendAnimationUpdate(world, textToSend, false);
                        ++this.currentCharIndex;
                    } else {
                        this.isAnimatingDay = false;
                        ServerPlayNetworking.send((class_3222)player, (class_2960)WelcomeToMyWorld.PLAY_BELL, (class_2540)PacketByteBufs.empty());
                    }
                }
                if (this.isAnimatingNight) {
                    String[] words = NIGHT_PREFIX.split(" ");
                    if (this.currentCharIndex < words.length) {
                        this.sendAnimationUpdate(world, words[this.currentCharIndex], true);
                        ++this.currentCharIndex;
                    } else {
                        this.isAnimatingNight = false;
                        ServerPlayNetworking.send((class_3222)player, (class_2960)WelcomeToMyWorld.PLAY_WOLF_HOWL, (class_2540)PacketByteBufs.empty());
                    }
                }
                this.currentTick = 0;
            }
        }
        ++this.counter;
        if (this.counter < this.checkInterval) {
            return;
        }
        this.counter = 0;
        long currentTime = world.method_8532();
        long currentTimeInDay = currentTime % 24000L;
        if (!(currentTimeInDay >= 13000L || this.isAnimatingDay || currentTime / 24000L <= (long)this.currentDay && this.dayAnimationComplete)) {
            this.currentDay = (int)(currentTime / 24000L);
            this.dayAnimationComplete = true;
            this.nightAnimationComplete = false;
            if (this.currentDay == 269) {
                for (class_3222 p : world.method_18456()) {
                    Utils.UTILS.sendTextAfter(p, "You did a great job, The dark will be a little bit easier for you.", 20);
                }
            } else if (this.currentDay == 300) {
                for (class_3222 p : world.method_18456()) {
                    Utils.UTILS.sendTextAfter(p, "I'm tired of summoning random things on you.", 20);
                }
            }
            if (this.currentDay > 0) {
                this.startDayAnimation(world, this.currentDay);
            }
        }
        if (!(currentTimeInDay < 13000L || currentTimeInDay >= 23999L || this.isAnimatingNight || currentTime / 24000L <= (long)this.currentDay && this.nightAnimationComplete)) {
            this.startNightAnimation(world);
            if (GlobalConfig.canSpawnMonstersAtNight) {
                SpawnMonstersAtNight.spawnMonsters(world, this.currentDay);
            }
            this.currentDay = (int)(currentTime / 24000L);
            this.dayAnimationComplete = false;
            this.nightAnimationComplete = true;
        }
    }

    private void startDayAnimation(class_3218 world, int day) {
        this.animationText = "DAY " + day;
        this.currentCharIndex = 0;
        this.delayTick = 0;
        this.isAnimatingDay = true;
    }

    private void startNightAnimation(class_3218 world) {
        this.currentCharIndex = 0;
        this.delayTick = 0;
        this.isAnimatingNight = true;
    }

    private void sendAnimationUpdate(class_3218 world, String textToSend, boolean nighttime) {
        for (class_3222 player : world.method_18456()) {
            if (nighttime) {
                player.method_7353((class_2561)class_2561.method_43470((String)textToSend).method_27692(class_124.field_1079), true);
            } else {
                textToSend = "- " + (String)textToSend + " -";
                player.method_7353((class_2561)class_2561.method_43470((String)textToSend).method_27692(class_124.field_1068), true);
            }
            ServerPlayNetworking.send((class_3222)player, (class_2960)WelcomeToMyWorld.PLAY_BLOCK_LEVER_CLICK, (class_2540)PacketByteBufs.empty());
        }
        this.delayTick = nighttime ? this.rand.nextInt(this.tickRandomMin * 2, this.tickRandomBound * 2) : this.rand.nextInt(this.tickRandomMin, this.tickRandomBound);
    }
}

