/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld.features;

import com.trongthang.welcometomyworld.Utilities.Utils;
import com.trongthang.welcometomyworld.WelcomeToMyWorld;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class EventsOfTheWorld {
    public static final int EVENT_COOLDOWN_IN_TICKS = 24000;
    public static final double HAPPEN_CHANCE = 0.4;
    private static final Map<String, Consumer<class_3218>> EVENT_MAP = new HashMap<String, Consumer<class_3218>>();
    private static int ticksSinceLastEvent = 0;
    public static final int stopEventsDay = 300;

    public static void registerEvent(String name, Consumer<class_3218> eventLogic) {
        EVENT_MAP.put(name, eventLogic);
    }

    public static void onServerTick(MinecraftServer server) {
        if (++ticksSinceLastEvent >= 24000) {
            ticksSinceLastEvent = 0;
            if (WelcomeToMyWorld.dayAndNightCounterAnimationHandler.currentDay >= 300) {
                return;
            }
            server.method_3738().forEach(world -> {
                if (WelcomeToMyWorld.random.nextDouble() < 0.4) {
                    EventsOfTheWorld.triggerRandomEvent(world);
                }
            });
        }
    }

    private static void triggerRandomEvent(class_3218 world) {
        if (EVENT_MAP.isEmpty()) {
            return;
        }
        Object[] eventNames = EVENT_MAP.keySet().toArray();
        String randomEventName = (String)eventNames[WelcomeToMyWorld.random.nextInt(eventNames.length)];
        Consumer<class_3218> eventLogic = EVENT_MAP.get(randomEventName);
        if (eventLogic != null) {
            eventLogic.accept(world);
            WelcomeToMyWorld.LOGGER.info("Triggered event: " + randomEventName);
        }
    }

    public static void circleOfDeaths(class_3218 world) {
        List players = world.method_18456();
        if (players.isEmpty()) {
            return;
        }
        class_3222 targetPlayer = (class_3222)players.get(WelcomeToMyWorld.random.nextInt(players.size()));
        targetPlayer.method_43496((class_2561)class_2561.method_43470((String)"They're around you...").method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)));
        int numberOfMobs = 20;
        double radius = 48.0;
        for (int i = 0; i < numberOfMobs; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)numberOfMobs;
            double x = targetPlayer.method_23317() + radius * Math.cos(angle);
            double z = targetPlayer.method_23321() + radius * Math.sin(angle);
            class_2338 spawnPos = new class_2338((int)x, (int)targetPlayer.method_23318(), (int)z);
            class_1297 zombie = Utils.spawnMob((class_1937)world, spawnPos, "minecraft:zombie");
            if (zombie == null || !(zombie instanceof class_1308)) continue;
            class_1308 mob = (class_1308)zombie;
            mob.method_5980((class_1309)targetPlayer);
            Utils.addRunAfter(() -> Utils.discardEntity(world, (class_1297)mob), 3000);
        }
    }

    public static void circleOfPhantom(class_3218 world) {
        List players = world.method_18456();
        if (players.isEmpty()) {
            System.out.println("No players available for Circle of Phantoms event.");
            return;
        }
        class_3222 targetPlayer = (class_3222)players.get(WelcomeToMyWorld.random.nextInt(players.size()));
        int numberOfPhantoms = 6;
        double radius = 48.0;
        double heightOffset = 0.0;
        targetPlayer.method_43496((class_2561)class_2561.method_43470((String)"Something is coming from the sky...").method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)));
        for (int i = 0; i < numberOfPhantoms; ++i) {
            class_1297 phantom;
            double angle = Math.PI * 2 * (double)i / (double)numberOfPhantoms;
            double x = targetPlayer.method_23317() + radius * Math.cos(angle);
            double z = targetPlayer.method_23321() + radius * Math.sin(angle);
            double y = targetPlayer.method_23318() + heightOffset;
            class_2338 spawnPos = new class_2338((int)x, (int)y, (int)z);
            if (!Utils.isSafeSpawn(world, spawnPos) || (phantom = Utils.spawnMob((class_1937)world, spawnPos, "minecraft:phantom")) == null || !(phantom instanceof class_1308)) continue;
            class_1308 mob = (class_1308)phantom;
            mob.method_5980((class_1309)targetPlayer);
            Utils.addRunAfter(() -> Utils.discardEntity(world, (class_1297)mob), 4000);
        }
    }

    public static void rainOfFood(class_3218 world) {
        List players = world.method_18456();
        if (players.isEmpty()) {
            System.out.println("No players available for Rain of Food event.");
            return;
        }
        class_3222 targetPlayer = (class_3222)players.get(WelcomeToMyWorld.random.nextInt(players.size()));
        int numberOfItems = 30;
        double spawnRadius = 48.0;
        double heightOffset = 64.0;
        class_1799[] foodItems = new class_1799[]{new class_1799((class_1935)class_1802.field_8279, 1), new class_1799((class_1935)class_1802.field_8229, 1), new class_1799((class_1935)class_1802.field_8176, 1), new class_1799((class_1935)class_1802.field_8179, 1), new class_1799((class_1935)class_1802.field_8567, 1), new class_1799((class_1935)class_1802.field_8544, 1)};
        for (int i = 0; i < numberOfItems; ++i) {
            double angle = Math.PI * 2 * WelcomeToMyWorld.random.nextDouble();
            double distance = spawnRadius * WelcomeToMyWorld.random.nextDouble();
            double x = targetPlayer.method_23317() + distance * Math.cos(angle);
            double z = targetPlayer.method_23321() + distance * Math.sin(angle);
            double y = targetPlayer.method_23318() + heightOffset;
            class_243 spawnPos = new class_243(x, y, z);
            class_1799 chosenFood = foodItems[WelcomeToMyWorld.random.nextInt(foodItems.length)];
            Utils.SpawnItem(world, spawnPos, chosenFood);
        }
        System.out.println("Rain of Food event triggered for player: " + targetPlayer.method_5477().getString());
    }

    public static void animalRaising(class_3218 world) {
        List players = world.method_18456();
        if (players.isEmpty()) {
            System.out.println("No players available for Animal Raising event.");
            return;
        }
        class_3222 targetPlayer = (class_3222)players.get(WelcomeToMyWorld.random.nextInt(players.size()));
        int numberOfAnimals = 12;
        int spawnRadius = 64;
        int packs = 3;
        String[] animalTypes = new String[]{"minecraft:cow", "minecraft:sheep", "minecraft:chicken", "minecraft:pig"};
        targetPlayer.method_43496((class_2561)class_2561.method_43470((String)"Even the kindest soul must rise up...").method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)));
        for (int i = 0; i < packs; ++i) {
            for (int j = 0; j < numberOfAnimals / packs; ++j) {
                String chosenAnimal;
                class_1297 animal;
                double angle = Math.PI * 2 * WelcomeToMyWorld.random.nextDouble();
                double distance = WelcomeToMyWorld.random.nextDouble() * (double)spawnRadius;
                double x = targetPlayer.method_23317() + distance * Math.cos(angle);
                double z = targetPlayer.method_23321() + distance * Math.sin(angle);
                double y = world.method_31600() + 1;
                class_2338 spawnPos = Utils.findSafeSpawnPositionAroundTheCenterPos(world, new class_243((double)((int)x), (double)((int)targetPlayer.method_23318()), (double)((int)z)), 4);
                if (spawnPos == null || (animal = Utils.spawnMob((class_1937)world, spawnPos, chosenAnimal = animalTypes[WelcomeToMyWorld.random.nextInt(animalTypes.length)])) == null || !(animal instanceof class_1308)) continue;
                class_1308 mob = (class_1308)animal;
                mob.method_5980((class_1309)targetPlayer);
                Utils.addRunAfter(() -> Utils.discardEntity(world, (class_1297)mob), 2000);
            }
        }
        System.out.println("Animal Raising event triggered for player: " + targetPlayer.method_5477().getString());
    }

    public static void illagerRaid(class_3218 world) {
        List players = world.method_18456();
        if (players.isEmpty()) {
            System.out.println("No players available for Illager Raid event.");
            return;
        }
        class_3222 targetPlayer = (class_3222)players.get(WelcomeToMyWorld.random.nextInt(players.size()));
        int numberOfIllagers = 10;
        int spawnRadius = 20;
        String[] illagerTypes = new String[]{"minecraft:evoker", "minecraft:vindicator", "minecraft:pillager", "minecraft:illusioner"};
        for (int i = 0; i < numberOfIllagers; ++i) {
            String chosenIllager;
            class_1297 illager;
            double angle = Math.PI * 2 * WelcomeToMyWorld.random.nextDouble();
            double distance = WelcomeToMyWorld.random.nextDouble() * (double)spawnRadius;
            double x = targetPlayer.method_23317() + distance * Math.cos(angle);
            double z = targetPlayer.method_23321() + distance * Math.sin(angle);
            double y = world.method_31600() + 1;
            class_2338 spawnPos = Utils.findSafeSpawnPositionAroundTheCenterPos(world, new class_243((double)((int)x), (double)((int)targetPlayer.method_23318()), (double)((int)z)), 4);
            if (spawnPos == null || (illager = Utils.spawnMob((class_1937)world, spawnPos, chosenIllager = illagerTypes[WelcomeToMyWorld.random.nextInt(illagerTypes.length)])) == null || !(illager instanceof class_1308)) continue;
            class_1308 mob = (class_1308)illager;
            mob.method_5980((class_1309)targetPlayer);
            Utils.addRunAfter(() -> Utils.discardEntity(world, (class_1297)mob), 2000);
        }
        WelcomeToMyWorld.LOGGER.info("Illager Raid event triggered for player: " + targetPlayer.method_5477().getString());
    }

    public static void fieldOfGoldenMoths(class_3218 world) {
        List players = world.method_18456();
        if (players.isEmpty()) {
            return;
        }
        class_3222 targetPlayer = (class_3222)players.get(WelcomeToMyWorld.random.nextInt(players.size()));
        Utils.UTILS.sendTextAfter(targetPlayer, "It seems like the golden butterflies are welcome you.", 120);
        int numberOfGoldenMoths = 30;
        double radius = 15.0;
        int counter = 0;
        for (int i = 0; i < numberOfGoldenMoths; ++i) {
            counter = i * 40;
            double angle = Math.PI * 2 * (double)i / (double)numberOfGoldenMoths;
            double x = targetPlayer.method_23317() + radius * Math.cos(angle);
            double z = targetPlayer.method_23321() + radius * Math.sin(angle);
            class_2338 spawnPos = Utils.findSafeSpawnPositionAroundTheCenterPos(world, new class_243((double)((int)x), (double)((int)targetPlayer.method_23318()), (double)((int)z)), 4);
            if (spawnPos == null) continue;
            Utils.addRunAfter(() -> {
                class_1297 goldenMoth = Utils.spawnMob((class_1937)world, spawnPos, "aquamirae:golden_moth");
                if (goldenMoth != null && goldenMoth instanceof class_1308) {
                    class_1308 mob = (class_1308)goldenMoth;
                    mob.method_5980((class_1309)targetPlayer);
                    Utils.addRunAfter(() -> Utils.discardEntity(world, (class_1297)mob), 3000);
                }
            }, counter);
        }
        WelcomeToMyWorld.LOGGER.info("Field Of Golden Moths triggered for player: " + targetPlayer.method_5477().getString());
    }

    static {
        EventsOfTheWorld.registerEvent("CIRCLE_OF_DEATHS", EventsOfTheWorld::circleOfDeaths);
        EventsOfTheWorld.registerEvent("CIRCLE_OF_PHANTOMS", EventsOfTheWorld::circleOfPhantom);
        EventsOfTheWorld.registerEvent("RAIN_OF_FOOD", EventsOfTheWorld::rainOfFood);
        EventsOfTheWorld.registerEvent("ANIMALS_RISING", EventsOfTheWorld::animalRaising);
        EventsOfTheWorld.registerEvent("ILLAGER_RAID", EventsOfTheWorld::illagerRaid);
        EventsOfTheWorld.registerEvent("FIELD_OF_GOLDEN_MOTHS", EventsOfTheWorld::fieldOfGoldenMoths);
    }
}

