/*
 * Decompiled with CFR 0.152.
 */
package com.trongthang.welcometomyworld;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigLoader {
    private static final String CONFIG_FILE_NAME = "welcometomyworld.json";
    private static ConfigLoader INSTANCE;
    @Expose
    @SerializedName(value="introOfTheWorld")
    public boolean introOfTheWorld = true;
    @Expose
    @SerializedName(value="clearItemsBeforeGivingStartingItems")
    public boolean clearItemsBeforeGivingStartingItems = true;
    @Expose
    @SerializedName(value="giveStartingItems")
    public boolean giveStartingItems = true;
    @Expose
    @SerializedName(value="oneShotDebugLog")
    public boolean oneShotDebugLog = false;

    public static void loadConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), CONFIG_FILE_NAME);
        Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                INSTANCE = (ConfigLoader)gson.fromJson((Reader)reader, ConfigLoader.class);
                if (INSTANCE == null) {
                    INSTANCE = new ConfigLoader();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            INSTANCE = new ConfigLoader();
        }
        ConfigLoader.saveConfig(gson, configFile);
    }

    private static void saveConfig(Gson gson, File configFile) {
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ConfigLoader getInstance() {
        return INSTANCE;
    }
}

